/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jfree.util.Log;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.AppsEvent;
import ru.bitel.bgbilling.modules.mobile.server.bean.AbstractAction;
import ru.bitel.bgbilling.modules.mobile.server.bean.ActionContext;
import ru.bitel.bgbilling.modules.mobile.server.bean.ActionHandler;
import ru.bitel.bgbilling.modules.mobile.server.event.MobileRequestEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

public class MobileRequestProcessor {
    private int moduleId;
    private String action;
    private Contract contract = null;
    private Setup setup;
    private Map<String, Map<String, String>> actionsParamsMap = new HashMap<String, Map<String, String>>();
    private Map<String, String> defaultParamMap = null;

    public MobileRequestProcessor(int moduleId, Setup setup, String action, Contract contract) {
        this.moduleId = moduleId;
        this.setup = setup;
        this.action = action;
        this.contract = contract;
    }

    public String doIt(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, ActionContext context, Map<String, Object> map) throws Exception {
        String error = null;
        List actionsList = new ArrayList<String>();
        if ("multiaction".equals(this.action)) {
            actionsList = Utils.toList((String)request.getParameter("actions"));
        } else {
            actionsList.add(this.action);
        }
        for (String action : actionsList) {
            Map<String, String> paramsMap = this.getActionParamMap(action, request);
            Map<String, Object> actionMap = new HashMap<String, Object>();
            MobileRequestEvent event = new MobileRequestEvent(this.moduleId, this.contract, action, request.getParameterMap(), actionMap);
            EventProcessor.getInstance().request((QueueEvent)event);
            if (!event.isProcessed()) {
                AppsEvent appsEvent = null;
                String module = request.getParameter("module");
                String pluginId = request.getParameter("plugin");
                if (module != null) {
                    appsEvent = new AppsEvent(module, Utils.parseInt((String)paramsMap.get("module_id"), (int)0), action, this.contract.getId(), request, paramsMap);
                } else if (pluginId != null) {
                    appsEvent = new AppsEvent(pluginId, action, this.contract.getId(), request, paramsMap);
                }
                if (appsEvent != null) {
                    ThreadContext parentContext = ThreadContext.get();
                    ActionContext context1 = new ActionContext(this.setup, this.moduleId, -1, request, response, servletContext);
                    ThreadContext.set((ThreadContext)context1);
                    appsEvent = (AppsEvent)EventProcessor.getInstance().request((QueueEvent)appsEvent);
                    context1.commit();
                    ThreadContext.pop((ThreadContext)context1, (ThreadContext)parentContext);
                    actionMap = appsEvent.getDataMap();
                    error = (String)request.getAttribute("error");
                } else {
                    String className = "Action" + action.substring(0, 1).toUpperCase() + action.substring(1);
                    Class<?> actionClass = this.attemptFindDynAction(className);
                    if (actionClass == null && (actionClass = Class.forName("ru.bitel.bgbilling.modules.mobile.server.action.apps." + className)) == null) {
                        error = "Action not found";
                        break;
                    }
                    if (AbstractAction.class.isAssignableFrom(actionClass)) {
                        ActionHandler actionHandler = new ActionHandler();
                        actionMap = actionHandler.handle(actionClass.asSubclass(AbstractAction.class), this.contract, paramsMap);
                    }
                }
            }
            if (actionsList.size() == 1) {
                map.putAll(actionMap);
                continue;
            }
            Object keyAction = action;
            if (paramsMap.get("operation") != null) {
                keyAction = (String)keyAction + ":" + paramsMap.get("operation");
            }
            map.put((String)keyAction, actionMap.get(action));
        }
        return error;
    }

    private Map<String, String> getActionParamMap(String action, HttpServletRequest request) {
        Map<String, String> paramsMap = this.actionsParamsMap.get(action);
        if (paramsMap == null) {
            if (this.defaultParamMap == null) {
                this.defaultParamMap = new HashMap<String, String>();
                for (Map.Entry entry : request.getParameterMap().entrySet()) {
                    if (entry.getValue() == null || ((String[])entry.getValue()).length <= 0) continue;
                    this.defaultParamMap.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
                }
            }
            paramsMap = this.defaultParamMap;
        }
        paramsMap.put("action", action);
        return paramsMap;
    }

    private Class<?> attemptFindDynAction(String className) {
        try {
            String dynaction = this.setup.get("dynaction:mobile.apps." + className);
            if (dynaction != null) {
                return DynamicClassManager.getInstance().loadClass(dynaction);
            }
        }
        catch (Exception e) {
            Log.error((Object)e.getMessage(), (Exception)e);
        }
        return null;
    }
}

