/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.mobile.common.bean.MobileContractNotification;
import ru.bitel.bgbilling.modules.mobile.common.bean.PushStatusType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Period;

public class MobileContractNotificationDao
extends AbstractDao<MobileContractNotification> {
    public MobileContractNotificationDao(Connection con, int moduleId) {
        super(con, moduleId, "mobile_contract_notifications");
    }

    protected void updateImpl(MobileContractNotification notification) throws BGException, SQLException {
        PreparedStatement ps;
        String query;
        StringBuilder params = new StringBuilder();
        if (notification.getParams() != null) {
            for (String key : notification.getParams().keySet()) {
                String value = (String)notification.getParams().get(key);
                if (value.contains(";") || key.contains(";")) {
                    throw new BGMessageException("\u041e\u0434\u043d\u043e \u0438\u0437 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u044b\u0439 \u0441\u0438\u043c\u0432\u043e\u043b - \";\" ");
                }
                params.append(key + "=" + value + ";");
            }
        }
        int index = 1;
        if (notification.getId() > 0) {
            query = "UPDATE " + this.tableName + " SET status=?, dateConfirm=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(index++, notification.getStatus().getCode());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)notification.getDateConfirm()));
                ps.setInt(index++, notification.getId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        query = "INSERT INTO " + this.tableName + " SET contractId=?, status=?, text=?, params=?, storable=?, dateSend=?, dateConfirm=?, userId=?";
        ps = this.con.prepareStatement(query, 1);
        try {
            ps.setInt(index++, notification.getContractId());
            ps.setInt(index++, notification.getStatus().getCode());
            ps.setString(index++, notification.getText());
            ps.setString(index++, params.toString());
            ps.setBoolean(index++, notification.isStorable());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)notification.getDateSend()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)notification.getDateConfirm()));
            ps.setInt(index++, notification.getUserId());
            ps.executeUpdate();
            notification.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public void updateStatus(int notificationId, PushStatusType status) throws BGException {
        String query = "UPDATE " + this.tableName + " SET status=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, status.getCode());
            ps.setInt(2, notificationId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    public void updateDateConfirm(int notificationId, Date date) throws BGException {
        String query = "UPDATE " + this.tableName + " SET dateConfirm=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)date));
            ps.setInt(2, notificationId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    public List<MobileContractNotification> getContractNotificationList(int contractId, Period periodSend, Boolean storable, Boolean notConfirm) throws BGException {
        List list;
        block15: {
            Date dateFrom = periodSend != null ? periodSend.getDateFrom() : null;
            Date dateTo = periodSend != null ? periodSend.getDateTo() : null;
            String query = "SELECT * FROM " + this.tableName + " WHERE contractId=?";
            if (dateTo != null) {
                query = query + " AND dateSend<=?";
            }
            if (dateFrom != null) {
                query = query + " AND dateSend>=?";
            }
            if (storable != null) {
                query = query + " AND storable=?";
            }
            if (notConfirm != null) {
                query = query + " AND dateConfirm " + (notConfirm != false ? "IS NULL" : "IS NOT NULL");
            }
            PreparedStatement ps = this.con.prepareStatement(query);
            try {
                int index = 1;
                ps.setInt(index++, contractId);
                if (dateTo != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)dateTo));
                }
                if (dateFrom != null) {
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)dateFrom));
                }
                if (storable != null) {
                    ps.setBoolean(index++, storable);
                }
                ResultSet rs = ps.executeQuery();
                list = this.getListFromRS(rs);
                if (ps == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new BGException(e.getMessage(), (Throwable)e);
                }
            }
            ps.close();
        }
        return list;
    }

    public MobileContractNotification getNotificationById(int id) throws BGException {
        try {
            return (MobileContractNotification)this.getById(id);
        }
        catch (SQLException e) {
            throw new BGException(e.getMessage(), (Throwable)e);
        }
    }

    public void deleteNotification(int id) throws BGException {
        this.delete("id=?", new Object[]{id});
    }

    protected MobileContractNotification getFromRS(ResultSet rs) throws SQLException, BGException {
        MobileContractNotification notification = new MobileContractNotification();
        notification.setId(rs.getInt("id"));
        notification.setContractId(rs.getInt("contractId"));
        notification.setStatus(PushStatusType.getByCode((int)rs.getInt("status")));
        notification.setText(rs.getString("text"));
        notification.setStorable(rs.getBoolean("storable"));
        notification.setDateSend((Date)rs.getTimestamp("dateSend"));
        notification.setDateConfirm((Date)rs.getTimestamp("dateConfirm"));
        notification.setUserId(rs.getInt("userId"));
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        String params = rs.getString("params");
        if (Utils.notBlankString((String)params)) {
            for (String str : Utils.toList((String)params, (String)";")) {
                String[] mas = str.split("=");
                if (mas.length <= 1) continue;
                paramsMap.put(mas[0], mas[1]);
            }
        }
        notification.setParams(paramsMap);
        return notification;
    }
}

