/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.servlet;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.modules.mobile.server.bean.ActionContext;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobileAuthentication;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobileRequestProcessor;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobileResultAuthentication;
import ru.bitel.bgbilling.modules.mobile.server.bean.MobileToken;
import ru.bitel.common.Utils;
import ru.bitel.common.worker.ThreadContext;

@WebServlet(name="mobexecutor", urlPatterns={"/mobapi/*"})
public class MobileExecutor
extends CommonExecutor {
    public void init() throws ServletException {
        super.init();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object error;
        String action;
        HashMap<String, Object> map;
        block25: {
            ActionContext context;
            block26: {
                map = new HashMap<String, Object>();
                action = request.getParameter("action");
                error = null;
                context = null;
                ThreadContext parentContext = null;
                try {
                    int moduleId = MobileExecutor.getModuleId((HttpServletRequest)request);
                    context = new ActionContext(this.setup, moduleId, -1, request, response, this.servletContext);
                    parentContext = ThreadContext.push((ThreadContext)context);
                    MobileAuthentication authentication = new MobileAuthentication(moduleId, this.setup.getModuleSetup(Integer.valueOf(moduleId)), action);
                    MobileResultAuthentication result = authentication.authentication(request, context.getConnection(), map);
                    context.commit();
                    map.put("accessCode", result.getAccessCode());
                    error = result.getErrorText();
                    if (Utils.isBlankString((String)error) && MobileToken.isCodeAccessValid(result.getAccessCode()) && 4 != result.getAccessCode()) {
                        error = new MobileRequestProcessor(moduleId, this.setup, action, result.getContract()).doIt(request, response, this.servletContext, context, map);
                        context.commit();
                    }
                    if (context == null) break block25;
                    if (parentContext == null) break block26;
                }
                catch (BGMessageException e) {
                    error = e.getMessage();
                    break block25;
                }
                catch (Exception e2) {
                    block27: {
                        logger.error(MobileExecutor.getQueryString((HttpServletRequest)request, (boolean)false));
                        logger.error(e2.getMessage(), (Throwable)e2);
                        error = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + e2.getMessage();
                        if (context == null) break block25;
                        if (parentContext == null) break block27;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        ThreadContext.pop((ThreadContext)context, (ThreadContext)parentContext);
                        break block25;
                    }
                    context.destroy();
                    break block25;
                }
                finally {
                    if (context != null) {
                        if (parentContext != null) {
                            ThreadContext.pop(context, parentContext);
                        } else {
                            context.destroy();
                        }
                    }
                }
                ThreadContext.pop((ThreadContext)context, (ThreadContext)parentContext);
                break block25;
            }
            context.destroy();
        }
        ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new JavaTimeModule())).build();
        if (error != null) {
            map.remove(action);
            map.put("error", error);
        }
        if (!"true".equals(map.get("outputStreamWasCalled"))) {
            response.setContentType("application/json; charset=UTF-8");
            if (request.getHeader("Accept-Encoding").contains("gzip")) {
                try (PrintWriter printWriter = new PrintWriter(new GZIPOutputStream((OutputStream)response.getOutputStream()));){
                    response.setHeader("Content-Encoding", "gzip");
                    mapper.writeValue((Writer)printWriter, map);
                }
            }
            try (PrintWriter out = response.getWriter();){
                mapper.writeValue((Writer)out, map);
            }
        }
    }
}

