/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.client.tariff;

import bitel.billing.module.common.BGComboBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

public class MonthCalculateModeTariffTreeNode
extends ru.bitel.bgbilling.kernel.tariff.client.tree.npay.MonthCalculateModeTariffTreeNode {
    private int day = 1;
    private DayMode dayMode = DayMode.DAY;
    private ButtonGroup buttonGroup = null;
    private JRadioButton contractDayButton = null;
    private JRadioButton serviceDayButton = null;
    private JRadioButton customDayButton = null;
    private BGComboBox<IdTitle> monthDayComboBox = null;

    protected void initEdit() {
        super.initEdit();
        ArrayList days = new ArrayList();
        IntStream.range(1, 32).forEach(a -> days.add(new IdTitle(a, String.valueOf(a))));
        this.monthDayComboBox = new BGComboBox(days);
        this.customDayButton = new JRadioButton("\u0437\u0430\u0434\u0430\u043d\u043d\u0430\u044f \u0434\u0430\u0442\u0430 ->");
        this.customDayButton.setActionCommand(DayMode.DAY.name());
        this.customDayButton.setSelected(true);
        this.contractDayButton = new JRadioButton("\u0434\u0430\u0442\u0430 \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        this.contractDayButton.setActionCommand(DayMode.CONTRACT.name());
        this.serviceDayButton = new JRadioButton("\u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0441\u043b\u0443\u0433\u0438");
        this.serviceDayButton.setActionCommand(DayMode.SERVICE.name());
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.contractDayButton);
        this.buttonGroup.add(this.serviceDayButton);
        this.buttonGroup.add(this.customDayButton);
    }

    protected JPanel getEditorPanel() {
        this.initEdit();
        int gridy = 0;
        JPanel edit = new JPanel(new GridBagLayout());
        edit.add((Component)this.getServicePanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        edit.add((Component)this.getSelectDayPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        return edit;
    }

    private JPanel getServicePanel() {
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0423\u0441\u043b\u0443\u0433\u0430 "), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)this.serviceCombo, new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)new JLabel(this.getEditorSuffix()), new GridBagConstraints(gridx++, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getSelectDayPanel() {
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0414\u0430\u0442\u0430 \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f:"), new GridBagConstraints(0, gridy++, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.customDayButton, new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
        panel.add((Component)this.monthDayComboBox, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.contractDayButton, new GridBagConstraints(0, gridy++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
        panel.add((Component)this.serviceDayButton, new GridBagConstraints(0, gridy++, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 0, 0), 0, 0));
        return panel;
    }

    protected String getLabelSuffix() {
        Object txt = " \u043f\u043e\u043c\u0435\u0441\u044f\u0447\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c \u0441\u043d\u044f\u0442\u0438\u044f [\u0434\u0430\u0442\u0430 \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f: ";
        switch (this.dayMode) {
            case DAY: {
                txt = (String)txt + (this.day < 10 ? "0" : "") + this.day;
                break;
            }
            case CONTRACT: {
                txt = (String)txt + " \u0434\u0430\u0442\u0430 \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430";
                break;
            }
            case SERVICE: {
                txt = (String)txt + " \u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0441\u043b\u0443\u0433\u0438";
            }
        }
        return (String)txt + "]";
    }

    protected void extractData() {
        Map data = this.getDataInHash();
        this.sid = Utils.parseInt((String)((String)data.get("sid")), (int)0);
        this.day = Utils.parseInt((String)((String)data.get("day")), (int)1);
        this.dayMode = DayMode.valueOf(data.getOrDefault("dayMode", DayMode.DAY.name()));
    }

    protected void loadData() {
        this.extractData();
        this.setDirectoryItemSelection((JComboBox)this.serviceCombo, this.sid);
        this.setDirectoryItemSelection((JComboBox)this.monthDayComboBox, this.day);
        switch (this.dayMode) {
            case DAY: {
                this.customDayButton.setSelected(true);
                break;
            }
            case CONTRACT: {
                this.contractDayButton.setSelected(true);
                break;
            }
            case SERVICE: {
                this.serviceDayButton.setSelected(true);
            }
        }
    }

    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("sid", String.valueOf(this.getIdFromDirectoryCombo((JComboBox)this.serviceCombo)));
        data.put("day", String.valueOf(this.getIdFromDirectoryCombo((JComboBox)this.monthDayComboBox)));
        data.put("mode", "month");
        data.put("dayMode", this.buttonGroup.getSelection().getActionCommand());
        this.setDataInHash(data);
    }

    static enum DayMode {
        DAY,
        CONTRACT,
        SERVICE;

    }
}

