/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server;

import bitel.billing.server.util.MailMsg;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskRecalculator;
import ru.bitel.bgbilling.modules.npay.server.task.Calculator;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class Recalculator
extends RunTaskRecalculator<Calculator> {
    private int serviceSet;
    private String cids;
    private String comment;
    private boolean detail;
    private List<Integer> contractLabelIds;

    public Recalculator(int mid, Calendar dt, String email, int serviceSet, String cids, String comment) {
        super(mid, dt, email);
        GregorianCalendar now = new GregorianCalendar();
        if (TimeUtils.monthsDelta((Calendar)dt, (Calendar)now) == 0) {
            this.dt = now;
        } else {
            Calendar endDay = (Calendar)dt.clone();
            endDay.set(5, endDay.getActualMaximum(5));
            this.dt = endDay;
        }
        this.serviceSet = serviceSet;
        this.cids = cids;
        this.comment = comment;
        this.dt.set(11, 23);
    }

    public Recalculator(int mid, Calendar dt, String email, int serviceSet, String cids, List<Integer> contractLabelIds, String comment) {
        this(mid, dt, email, serviceSet, cids, comment);
        this.contractLabelIds = contractLabelIds;
    }

    public Recalculator(int mid, Calendar dt, String email, int serviceSet, String cids, String comment, boolean detail) {
        this(mid, dt, email, serviceSet, cids, comment);
        this.detail = detail;
    }

    public Recalculator(int moduleId, Calendar dt, String email, int serviceSet, String cids, List<Integer> contractLabelIds, String comment, boolean detail) {
        this(moduleId, dt, email, serviceSet, cids, contractLabelIds, comment);
        this.detail = detail;
    }

    public void executeTask() {
        try {
            long start = System.currentTimeMillis();
            this.log.info("PaymentRecalculator time: " + TimeUtils.format((Calendar)this.dt, (String)"dd.MM.yyyy HH"));
            Calculator calculator = this.createTask();
            calculator.startTask();
            long end = System.currentTimeMillis();
            if (this.email != null) {
                StringBuffer report = new StringBuffer("\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e\n");
                report.append("\u0412\u0440\u0435\u043c\u044f: ");
                report.append(TimeUtils.formatDeltaTime((long)((end - start) / 1000L)));
                MailMsg msg = new MailMsg((Preferences)this.setup);
                msg.sendMessage(this.email, "\u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043e", report.toString());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected Calculator createTask() {
        Calculator calculator = new Calculator();
        calculator.setExecutingTime(this.dt);
        calculator.initTask(Setup.getSetup(), 0, "mid=" + this.mid + "\nservice.set=" + this.serviceSet + (this.detail ? "" : "\ndetail=0") + "\ncomment=" + this.comment);
        calculator.setCids(this.cids);
        calculator.setContractLabelIds(this.contractLabelIds);
        return calculator;
    }
}

