/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.npay.server.task;

import bitel.billing.server.admin.errorlog.bean.PeriodicErrorManager;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractStatus;
import bitel.billing.server.contract.bean.ContractStatusManager;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.npay.server.bean.DebetStatusManageConfig;
import ru.bitel.bgbilling.modules.npay.server.task.Calculator;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class DebetStatusManageLocker
extends TaskBase {
    private String email;
    private Preferences moduleSetup;
    private Calendar startMonth;
    private PeriodicErrorManager errorManager;
    private Connection con;
    private Connection conSlave;
    private boolean checkAccountChanged = true;
    private static final String CHECK_ACCOUNT_CHANGED = "check.account.changed";
    private ServerContext context;

    protected boolean initTask() {
        boolean result;
        this.email = this.taskSetup.get("email", null);
        boolean bl = result = this.moduleId >= 0;
        if (!result) {
            this.log.error("Incorrect mid in task config!");
        } else {
            this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
            this.checkAccountChanged = this.taskSetup.get(CHECK_ACCOUNT_CHANGED) != null ? this.taskSetup.getBoolean(CHECK_ACCOUNT_CHANGED, true) : this.moduleSetup.getBoolean(CHECK_ACCOUNT_CHANGED, true);
        }
        return result;
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c NPay. \u0417\u0430\u0434\u0430\u0447\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 \u0434\u0435\u0431\u0435\u0442\u043e\u0432\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ".";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeTask() {
        this.context = (ServerContext)ServerContext.get();
        DebetStatusManageConfig config = new DebetStatusManageConfig(this.moduleSetup);
        if (!config.isEnable()) {
            this.log.info("Debet status manage is switch off in module config");
            return;
        }
        String TABLE_GROUPED_SUB_ACCOUNT = " _npay_debet_status_manage_locker_sub_account_" + this.moduleId + " ";
        String TABLE_GROUPED_SUPER_AND_INDEPEND_ACCOUNT = " _npay_debet_status_manage_locker_sub_and_independ_account_" + this.moduleId + " ";
        this.con = this.setup.getDBConnectionFromPool();
        this.conSlave = this.setup.getDBSlaveConnectionFromPool();
        try (BalanceUtils bu = new BalanceUtils(this.conSlave);){
            this.conSlave.createStatement().executeUpdate("DROP TEMPORARY TABLE IF EXISTS " + TABLE_GROUPED_SUB_ACCOUNT);
            this.conSlave.createStatement().executeUpdate("DROP TEMPORARY TABLE IF EXISTS " + TABLE_GROUPED_SUPER_AND_INDEPEND_ACCOUNT);
            String query = null;
            this.startMonth = TimeUtils.getStartMonth((Calendar)this.getOperatingTime());
            String moduleServices = ModuleCache.getInstance().getModuleServicesString(this.moduleId);
            Date currentDate = TimeUtils.convertCalendarToDate((Calendar)this.getOperatingTime());
            this.errorManager = new PeriodicErrorManager(this.con);
            this.errorManager.initErrorMessage(this.moduleId, "NPay", String.valueOf(this.moduleId), this.startMonth.getTime());
            Calculator calculator = new Calculator();
            calculator.setExecutingTime(this.getOperatingTime());
            calculator.initTask(this.setup, 0, "mid=" + this.moduleId + "\nservice.set=" + config.getServiceSet());
            calculator.setPreCalc();
            calculator.setActiveFromDate(null);
            calculator.startTask();
            Map planAccountMap = calculator.getCostCache().getContractAccounts();
            HashSet<Integer> cidsForClose = new HashSet<Integer>();
            ContractStatusManager statusManager = new ContractStatusManager(this.con);
            ContractLabelManager contractLabelManager = new ContractLabelManager(this.con);
            StringBuilder report = new StringBuilder(1000);
            query = "CREATE TEMPORARY TABLE " + TABLE_GROUPED_SUB_ACCOUNT + " (  `scid` int(11) NOT NULL, `summa` decimal(10,2) NOT NULL, PRIMARY KEY  (`scid` ) ) SELECT contract.scid AS scid, SUM(ROUND(account.summa,2)) AS summa FROM contract_account AS account INNER JOIN contract ON account.cid=contract.id WHERE account.yy=? AND account.mm=? AND account.sid IN (" + moduleServices + ") AND contract.sub_mode=0 AND contract.scid>0 GROUP BY contract.scid";
            PreparedStatement psCreateTempTable = this.conSlave.prepareStatement(query);
            psCreateTempTable.setInt(1, this.startMonth.get(1));
            psCreateTempTable.setInt(2, this.startMonth.get(2) + 1);
            psCreateTempTable.executeUpdate();
            psCreateTempTable.close();
            query = "CREATE TEMPORARY TABLE " + TABLE_GROUPED_SUPER_AND_INDEPEND_ACCOUNT + " (  `cid` int(11) NOT NULL, `summa` decimal(10,2) NOT NULL, PRIMARY KEY  (`cid` ) ) SELECT contract.id AS cid, SUM(ROUND(account.summa,2)) AS summa FROM contract_account AS account INNER JOIN contract ON account.cid=contract.id WHERE account.yy=? AND account.mm=? AND account.sid IN (" + moduleServices + ")";
            if (!config.isProcessDependentSub()) {
                query = query + " AND ( contract.scid<=0 OR (contract.sub_mode=1) )";
            }
            query = query + " GROUP BY contract.id";
            psCreateTempTable = this.conSlave.prepareStatement(query);
            psCreateTempTable.setInt(1, this.startMonth.get(1));
            psCreateTempTable.setInt(2, this.startMonth.get(2) + 1);
            psCreateTempTable.executeUpdate();
            psCreateTempTable.close();
            query = "SELECT DISTINCT contract.id, contract.scid, contract.sub_list, contract.sub_mode, contract.closesumma, contract.title, contract.gr, account.summa, sub_account.summa, contract.status  FROM contract INNER JOIN contract_module ON contract.id=contract_module.cid AND contract_module.mid=? LEFT JOIN " + TABLE_GROUPED_SUPER_AND_INDEPEND_ACCOUNT + " AS account ON contract.id=account.cid LEFT JOIN " + TABLE_GROUPED_SUB_ACCOUNT + " AS sub_account ON contract.id=sub_account.scid ";
            if (Utils.notBlankString((String)config.getTariffIds())) {
                String sqlDate = "'" + TimeUtils.format((Calendar)this.getOperatingTime(), (String)"yyyy-MM-dd") + "'";
                query = query + "INNER JOIN contract_tariff ON contract.id=contract_tariff.cid AND contract_tariff.tpid IN (" + config.getTariffIds() + ") AND contract_tariff.date1<=" + sqlDate + "AND (contract_tariff.date2 IS NULL OR " + sqlDate + "<=contract_tariff.date2) ";
            }
            String selectQuery = query + "WHERE contract.mode=1 AND contract.status IN (" + config.getActiveStatusString() + ") AND (contract.scid<=0 OR contract.sub_mode=1) AND (contract.date2 IS NULL OR ?<=contract.date2)";
            PreparedStatement psSelect = this.conSlave.prepareStatement(selectQuery);
            int index = 1;
            psSelect.setInt(index++, this.moduleId);
            psSelect.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)this.getOperatingTime()));
            ResultSet rs = psSelect.executeQuery();
            this.check(config, bu, planAccountMap, report, cidsForClose, currentDate, rs, false, statusManager, contractLabelManager);
            psSelect.close();
            if (!config.isProcessDependentSub()) return;
            selectQuery = query + "WHERE contract.mode=1 AND contract.status IN (" + config.getActiveStatusString() + ") AND (contract.scid>0 AND contract.sub_mode=0) AND (contract.date2 IS NULL OR ?<=contract.date2)";
            psSelect = this.conSlave.prepareStatement(selectQuery);
            index = 1;
            psSelect.setInt(index++, this.moduleId);
            psSelect.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)this.getOperatingTime()));
            rs = psSelect.executeQuery();
            this.check(config, bu, planAccountMap, report, cidsForClose, currentDate, rs, true, statusManager, contractLabelManager);
            psSelect.close();
            return;
        }
        catch (Exception e) {
            if (!this.errorManager.isCapReached()) {
                String subject = e.getMessage();
                String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043d\u0435\u043f\u0440\u0435\u0434\u0432\u0438\u0434\u0435\u043d\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430.";
                this.errorManager.addErrorToList(subject, text, e);
            }
            this.log.error(e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            try {
                this.conSlave.createStatement().executeUpdate("DROP TEMPORARY TABLE IF EXISTS " + TABLE_GROUPED_SUB_ACCOUNT);
                this.conSlave.createStatement().executeUpdate("DROP TEMPORARY TABLE IF EXISTS " + TABLE_GROUPED_SUPER_AND_INDEPEND_ACCOUNT);
                this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.startMonth.getTime());
                this.errorManager.processErrors();
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                ServerUtils.closeConnection((Connection)this.con, (Connection)this.conSlave);
            }
        }
    }

    private void check(DebetStatusManageConfig config, BalanceUtils bu, Map<Integer, BigDecimal> planAccountMap, StringBuilder report, Set<Integer> cidsForClose, Date currentDate, ResultSet rs, boolean checkDuplicate, ContractStatusManager statusManager, ContractLabelManager contractLabelManager) throws SQLException, BGException {
        while (rs.next()) {
            int contractId = rs.getInt(1);
            int superId = rs.getInt(2);
            if (checkDuplicate && (cidsForClose.contains(contractId) || cidsForClose.contains(superId))) continue;
            String subList = rs.getString(3);
            int subMode = rs.getInt(4);
            BigDecimal limit = Utils.maskNull((BigDecimal)rs.getBigDecimal(5));
            String title = rs.getString(6);
            long gr = rs.getLong(7);
            BigDecimal accountSumma = Utils.maskNull((BigDecimal)rs.getBigDecimal(8));
            BigDecimal subSumma = rs.getBigDecimal(9);
            int oldStatus = rs.getInt(10);
            if (subSumma != null && BigDecimal.ZERO.compareTo(subSumma) != 0) {
                accountSumma = accountSumma.add(subSumma);
            }
            BigDecimal planAccount = Utils.maskNull((BigDecimal)planAccountMap.get(contractId));
            if (superId == -1) {
                for (Integer dependSub : Utils.toIntegerList((String)subList)) {
                    BigDecimal subAccount = Utils.maskNull((BigDecimal)planAccountMap.get(dependSub));
                    planAccount = planAccount.add(subAccount);
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("contract: " + contractId + ", planAccount: " + planAccount + ", accountSumma: " + accountSumma);
            }
            if (this.checkAccountChanged && planAccount.compareTo(accountSumma) <= 0) continue;
            Contract contract = new Contract();
            contract.setId(contractId);
            contract.setSuperId(superId);
            contract.setGroups(gr);
            contract.setDependSubList(subList);
            contract.setSubMode(subMode);
            BigDecimal diff = planAccount.subtract(accountSumma);
            BigDecimal balance = bu.getBalanceOut(currentDate, contractId);
            if (this.log.isDebugEnabled()) {
                this.log.debug("  balance: " + balance + ", diff: " + diff + ", limit: " + limit);
            }
            if (balance.subtract(diff).compareTo(limit) >= 0) continue;
            if (config.isEnableForContractLabelIds(contractLabelManager.getContractLabelIds(contractId))) {
                cidsForClose.add(contractId);
                ContractStatus status = new ContractStatus();
                status.setContractId(contractId);
                status.setStatus(config.getNextStatus(oldStatus));
                status.setDateFrom(currentDate);
                status.setDateTo(null);
                status.setComment("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u043a \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442\u044b");
                statusManager.changeStatus(status.clone(), Integer.valueOf(0));
                if (this.context != null) {
                    this.context.commit();
                }
                this.log.info("Locked contract " + title + " balance: " + Utils.formatBigDecimalSumm((BigDecimal)balance) + "; currentAccount: " + Utils.formatBigDecimalSumm((BigDecimal)accountSumma) + "; planAccount: " + Utils.formatBigDecimalSumm((BigDecimal)planAccount));
                if (!Utils.notBlankString((String)this.email)) continue;
                report.append(title);
                report.append("\n");
                continue;
            }
            this.log.info("Skip locking contract (no enable for contract) " + title + " balance: " + Utils.formatBigDecimalSumm((BigDecimal)balance) + "; currentAccount: " + Utils.formatBigDecimalSumm((BigDecimal)accountSumma) + "; planAccount: " + Utils.formatBigDecimalSumm((BigDecimal)planAccount));
        }
    }
}

