/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.JRViewer;
import bitel.billing.module.common.TransferData;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JRHyperlinkListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.reports.client.Report;
import ru.bitel.bgbilling.modules.reports.client.ReportParams;
import ru.bitel.bgbilling.modules.reports.client.TextReportPanel;
import ru.bitel.bgbilling.modules.reports.client.ViewReportPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class BGReportsPanel
extends ServiceConfigTabbedPanel {
    private static final String MODE_JASPER = "jasper";
    private static final String MODE_CSV = "csv";
    private static final String MODE_TEXT = "text";
    private JPanel rightPanel = null;
    private JPanel reportParamsPanel = null;
    private BGButton infoButton = new BGButton("i");
    private JComboBox<ComboBoxItem> reportsList = new JComboBox();
    private BGComboBox<ComboBoxItem> module_CB = new BGComboBox();
    private ViewReportPanel viewPanel = new ViewReportPanel(this);
    private TextReportPanel textPanel = new TextReportPanel(this);
    private JRViewer viewer;
    private boolean inited = false;

    public BGReportsPanel() {
        this.rightPanel = new JPanel(new CardLayout());
        this.rightPanel.add((Component)this.createPrintPanel(), MODE_JASPER);
        this.rightPanel.add((Component)((Object)this.viewPanel), MODE_CSV);
        this.rightPanel.add((Component)((Object)this.textPanel), MODE_TEXT);
        ((CardLayout)this.rightPanel.getLayout()).show(this.rightPanel, MODE_JASPER);
        this.infoButton.setEnabled(false);
        this.infoButton.setToolTipText("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u043e\u0442\u0447\u0435\u0442\u0435");
        this.infoButton.addActionListener(e -> this.showDoc());
        this.infoButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    BGReportsPanel.this.getContext().processException((Throwable)new BGException(BGReportsPanel.this.getReport().getInfo()));
                }
            }
        });
        this.reportsList.setMaximumRowCount(20);
        this.reportsList.setActionCommand("comboBoxChanged");
        this.reportsList.addActionListener(event -> this.changeReport(event));
        this.module_CB.addActionListener(e -> this.moduleChanged());
        this.module_CB.setMaximumRowCount(20);
        this.setLayout(new GridBagLayout());
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)this.createSettingsPanel(), (Component)this.rightPanel, 300L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel createPrintPanel() {
        JPanel printPanel = new JPanel(new BorderLayout());
        try {
            this.viewer = new JRViewer(null);
            this.viewer.addHyperlinkListener(new JRHyperlinkListener(){

                public void gotoHyperlink(JRPrintHyperlink hyperlink) throws JRException {
                    block10: {
                        if (!"Reference".equals(hyperlink.getLinkType())) {
                            return;
                        }
                        try {
                            URI uri;
                            String u = hyperlink.getHyperlinkReference();
                            if (!u.startsWith("bgbilling:") || !"reports".equals((uri = new URI(u.substring(10))).getScheme())) break block10;
                            if ("bitel.billing.module.services.reports.BGReportsPanel".equals(uri.getHost()) || "ru.bitel.bgbilling.modules.reports.client.BGReportsPanel".equals(uri.getHost())) {
                                String[] query = null;
                                Pattern p = Pattern.compile("&");
                                try {
                                    query = p.split(URLDecoder.decode(uri.getQuery(), "UTF-8"));
                                }
                                catch (UnsupportedEncodingException e) {
                                    query = p.split(uri.getQuery());
                                    e.printStackTrace();
                                }
                                HashMap<String, String> params = new HashMap<String, String>();
                                for (String q : query) {
                                    int pos = q.indexOf(61);
                                    if (pos != -1) {
                                        params.put(q.substring(0, pos), q.substring(pos + 1));
                                        continue;
                                    }
                                    params.put(q, "");
                                }
                                Request request = new Request();
                                request.setModule("reports");
                                request.setModuleId(BGReportsPanel.this.getModuleId());
                                request.setAction("Report");
                                request.setAttribute("contentType", "binary");
                                for (String key : params.keySet()) {
                                    request.setAttribute(key, (String)params.get(key));
                                }
                                BGReportsPanel.this.showReport(request, null);
                                break block10;
                            }
                            if ("ru.bitel.bgbilling.kernel.contract.base.client.ContractEditor".equals(uri.getHost()) || "bitel.billing.module.contract.ContractEditor".equals(uri.getHost())) {
                                BGReportsPanel.this.openContract(Utils.parseInt((String)uri.getQuery()));
                            }
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        printPanel.add((Component)this.viewer, "Center");
        return printPanel;
    }

    private JPanel createSettingsPanel() {
        JPanel reportPanel = new JPanel(new GridBagLayout());
        reportPanel.setBorder((Border)new BGTitleBorder("\u041e\u0442\u0447\u0435\u0442"));
        reportPanel.add(this.reportsList, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        reportPanel.add((Component)this.infoButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel modulePanel = new JPanel(new GridBagLayout());
        modulePanel.setBorder((Border)new BGTitleBorder("\u041c\u043e\u0434\u0443\u043b\u044c"));
        modulePanel.add((Component)this.module_CB, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.reportParamsPanel = new JPanel(new CardLayout());
        this.reportParamsPanel.setBorder((Border)new BGTitleBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b"));
        this.reportParamsPanel.setDebugGraphicsOptions(0);
        JButton genButton = new JButton("\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        genButton.addActionListener(e -> this.generateReport());
        JPanel settingPanel = new JPanel(new GridBagLayout());
        settingPanel.setMaximumSize(new Dimension(400, 500));
        settingPanel.setPreferredSize(new Dimension(400, 500));
        settingPanel.add((Component)reportPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 5, 0), 0, 0));
        settingPanel.add((Component)this.reportParamsPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        settingPanel.add((Component)genButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        settingPanel.add((Component)modulePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return settingPanel;
    }

    public void init(String module, int moduleId) {
        super.init(module, moduleId);
        this.viewPanel.init(module, moduleId);
    }

    public void setData() {
        if (!this.inited) {
            this.inited = true;
            ComboBoxItem comboBoxItem = new ComboBoxItem((Object)"none", "---");
            comboBoxItem.put("id", (Object)"-1");
            this.module_CB.addItem((Object)comboBoxItem);
            Request request = new Request();
            request.setModule("reports");
            request.setModuleId(this.getModuleId());
            request.setAction("GetModules");
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                for (Element element : XMLUtils.selectElements((Node)doc, (String)"/data/items/*")) {
                    String title = element.getAttribute("title");
                    if ("separator".equals(element.getLocalName())) {
                        this.module_CB.addItem((Object)new BGComboBox.Separator(title));
                        continue;
                    }
                    if (!"item".equals(element.getLocalName())) continue;
                    ComboBoxItem item = new ComboBoxItem((Object)element.getAttribute("module"), title);
                    item.put("id", (Object)element.getAttribute("mid"));
                    this.module_CB.addItem((Object)item);
                }
            }
        }
    }

    private void moduleChanged() {
        String object;
        this.infoButton.setEnabled(false);
        this.reportsList.removeAllItems();
        this.reportParamsPanel.removeAll();
        this.reportParamsPanel.repaint();
        ComboBoxItem selected = (ComboBoxItem)this.module_CB.getSelectedItem();
        if (selected != null && !"none".equals(object = (String)selected.getObject())) {
            this.doGetReports(object, Integer.parseInt((String)selected.get("id")));
        }
    }

    private void doGetReports(String object, int moduleId) {
        Request request = new Request();
        request.setModule("reports");
        request.setAction("GetReports");
        request.setAttribute("report_module", object);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.loadModuleReports(doc, moduleId);
        }
    }

    private void loadModuleReports(Document doc, int moduleId) {
        Element reports = XMLUtils.selectElement((Node)doc, (String)"/data/reports");
        if (reports == null) {
            return;
        }
        NodeList items = reports.getChildNodes();
        for (int i = 0; i < items.getLength(); ++i) {
            Node node = items.item(i);
            if (node.getNodeType() != 1 || !"item".equals(node.getNodeName())) continue;
            Report report = new Report((Element)items.item(i));
            report.moduleId = moduleId;
            this.reportsList.addItem(new ComboBoxItem((Object)report, report.item.getAttribute("title")));
        }
    }

    public void generateReport() {
        this.setCursor(new Cursor(3));
        try {
            Report report = this.getReport();
            Request request = this.getRequest();
            this.showReport(request, report);
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    public Request getRequest() {
        Report report = this.getReport();
        ReportParams params = this.getReportParams();
        Request request = null;
        if (report != null & params != null && report.id != null) {
            String checkParams = params.checkParams();
            if (checkParams != null) {
                ClientUtils.showErrorMessageDialog((String)checkParams);
            } else {
                request = this.createRequest(report, params);
            }
        }
        return request;
    }

    private Report getReport() {
        ComboBoxItem item = (ComboBoxItem)this.reportsList.getSelectedItem();
        return item != null ? (Report)item.getObject() : null;
    }

    private ReportParams getReportParams() {
        ReportParams selected = null;
        Component[] paramsPanes = this.reportParamsPanel.getComponents();
        for (int i = 0; i < paramsPanes.length; ++i) {
            if (!paramsPanes[i].isVisible()) continue;
            selected = (ReportParams)((Object)paramsPanes[i]);
            break;
        }
        return selected;
    }

    private Request createRequest(Report report, ReportParams params) {
        Request request = new Request();
        request.setModule("reports");
        request.setModuleId(this.getModuleId());
        request.setAction("Report");
        request.setAttribute("contentType", "binary");
        request.setAttribute("report_id", report.id);
        Map<String, Object> paramsObj = params.getParams();
        for (String key : paramsObj.keySet()) {
            request.setAttribute(key, paramsObj.get(key));
        }
        return request;
    }

    private void showReport(Request request, Report report) {
        TransferData.HTTPDataSource source = this.getDataSource(request);
        if (source != null && !source.isError()) {
            try {
                if (source.getContentType() == null || source.getContentType().equals(MODE_JASPER)) {
                    this.viewer.setReport((JasperPrint)JRLoader.loadObject((InputStream)source.getInputStream()));
                    this.repaint();
                    ((CardLayout)this.rightPanel.getLayout()).show(this.rightPanel, MODE_JASPER);
                } else if (source.getContentType().equals("error")) {
                    this.textPanel.showReport(source.getInputStream());
                    ((CardLayout)this.rightPanel.getLayout()).show(this.rightPanel, MODE_TEXT);
                    ClientUtils.showErrorMessageDialog((String)"\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0442\u0447\u0435\u0442\u0430");
                } else if (source.getContentType().equals("json")) {
                    this.viewPanel.setDataInJson(true);
                    this.viewPanel.showReport(source.getInputStream());
                    ((CardLayout)this.rightPanel.getLayout()).show(this.rightPanel, MODE_CSV);
                } else {
                    this.viewPanel.setDataInJson(false);
                    this.viewPanel.showReport(source.getInputStream());
                    ((CardLayout)this.rightPanel.getLayout()).show(this.rightPanel, MODE_CSV);
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private void changeReport(ActionEvent event) {
        ComboBoxItem item = (ComboBoxItem)this.reportsList.getSelectedItem();
        if (item != null) {
            Report report = (Report)item.getObject();
            if (report.reportParams == null) {
                try {
                    ReportParams reportParams = (ReportParams)((Object)Class.forName(report.paramsClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    reportParams.init(this.module, this.getModuleId());
                    reportParams.setReportMid(report.moduleId);
                    reportParams.setReportInfo(report.item);
                    reportParams.setData();
                    report.reportParams = reportParams;
                    this.reportParamsPanel.add((Component)((Object)reportParams), report.id);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            this.infoButton.setEnabled(Utils.notEmptyString((String)report.reportDocUrl));
            this.infoButton.setToolTipText(report.getInfo());
            ((CardLayout)this.reportParamsPanel.getLayout()).show(this.reportParamsPanel, report.id);
        }
    }

    private void showDoc() {
        ComboBoxItem item = (ComboBoxItem)this.reportsList.getSelectedItem();
        if (item != null) {
            Report report = (Report)item.getObject();
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URI(report.reportDocUrl));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), e.getMessage());
                }
            } else {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f.");
            }
        }
    }
}

