/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rscm.server.service;

import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractService;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractServiceInstallment;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMContractServiceInstallmentStatus;
import ru.bitel.bgbilling.modules.rscm.common.bean.RSCMService;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMContractServiceManager;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMRecalculator;
import ru.bitel.bgbilling.modules.rscm.server.bean.RSCMServiceManager;
import ru.bitel.bgbilling.modules.rscm.server.event.RSCMContractServiceUpdateEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.rscm.common.service.RSCMService")
public class RSCMServiceImpl
extends AbstractService
implements ru.bitel.bgbilling.modules.rscm.common.service.RSCMService {
    @PostConstruct
    private void init() {
    }

    public SearchResult<RSCMContractService> searchRSCMContractService(int contractId, Period period, String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setSort(sort);
        searchResult.setPage(page);
        try (RSCMContractServiceManager contractServiceManager = new RSCMContractServiceManager(this.getConnection(), this.moduleId);){
            searchResult.setList(contractServiceManager.getContractServiceList(contractId, period, page, true));
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return searchResult;
    }

    public SearchResult<RSCMService> searchRSCMService(String[] sort, Page page) throws BGException {
        SearchResult searchResult = new SearchResult();
        searchResult.setSort(sort);
        searchResult.setPage(page);
        searchResult.getList().addAll(new RSCMServiceManager(this.getConnection(), this.moduleId).getServiceList());
        page.setRecordCount(searchResult.getList().size());
        return searchResult;
    }

    public RSCMContractService getRSCMContractService(int contractId, int rscmContractServiceId) throws BGException {
        RSCMContractService rSCMContractService;
        RSCMContractServiceManager contractServiceManager = new RSCMContractServiceManager(this.getConnection(), this.moduleId);
        try {
            rSCMContractService = contractServiceManager.getContractService(contractId, rscmContractServiceId);
        }
        catch (Throwable throwable) {
            try {
                try {
                    contractServiceManager.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new BGException((Throwable)e);
            }
        }
        contractServiceManager.close();
        return rSCMContractService;
    }

    public RSCMService getRSCMService(int rscmServiceId) throws BGException {
        return new RSCMServiceManager(this.getConnection(), this.moduleId).getService(rscmServiceId);
    }

    public void updateRSCMContractService(RSCMContractService rscmContractService) throws BGException, BGMessageException {
        Calendar closedDate = null;
        Connection con = this.getConnection();
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionContractServiceUpdate", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, null, (LocalDate)rscmContractService.getDate());
        }
        try (RSCMContractServiceManager contractServiceManager = new RSCMContractServiceManager(con, this.moduleId);){
            boolean checklowerbound;
            int serviceId = rscmContractService.getServiceId();
            int contractId = rscmContractService.getContractId();
            LocalDate date = rscmContractService.getDate();
            if (this.getModuleSetup().getBoolean("hard.tariff.check", false)) {
                contractServiceManager.checkTariffsForService(contractId, serviceId, date);
            }
            JSONObject json = null;
            JSONArray paymentsArray = null;
            RSCMServiceManager rscmServiceManager = new RSCMServiceManager(con, this.moduleId);
            RSCMService rscmService = rscmServiceManager.getServiceByServiceId(serviceId);
            if (rscmService != null && rscmService.getInstallmentData() != null) {
                json = new JSONObject(rscmService.getInstallmentData());
                paymentsArray = json.optJSONArray("paymentsArray");
            }
            if (checklowerbound = this.getModuleSetup().getBoolean("check.lower.bound", false)) {
                String error;
                BigDecimal amount = rscmContractService.getAmount();
                if (paymentsArray != null && !paymentsArray.isEmpty()) {
                    amount = amount.multiply(paymentsArray.getBigDecimal(0)).divide(new BigDecimal(100));
                }
                if (Utils.notBlankString((String)(error = contractServiceManager.checkBalanceForService(contractId, serviceId, amount, date)))) {
                    throw new BGMessageException(error);
                }
            }
            RSCMContractServiceInstallment rscmContractServiceInstallment = null;
            if (rscmContractService.getId() < 1 && rscmService != null && rscmService.getInstallmentData() != null) {
                LocalDate dateNext = date.withDayOfMonth(1).plusMonths(1L);
                dateNext = dateNext.withDayOfMonth(Math.min(date.getDayOfMonth(), dateNext.lengthOfMonth()));
                rscmContractServiceInstallment = new RSCMContractServiceInstallment();
                rscmContractServiceInstallment.setContractId(contractId);
                rscmContractServiceInstallment.setServiceId(serviceId);
                rscmContractServiceInstallment.setDateFrom(date);
                rscmContractServiceInstallment.setDateNext(dateNext);
                rscmContractServiceInstallment.setAmount(rscmContractService.getAmount());
                rscmContractServiceInstallment.setPaymentCount(1);
                rscmContractServiceInstallment.setInstallment(rscmService.getInstallmentData());
                rscmContractServiceInstallment.setStatus(RSCMContractServiceInstallmentStatus.IN_PROGRESS);
                contractServiceManager.updateRSCMContractServiceInstallment(rscmContractServiceInstallment);
                rscmContractService.setInstallmentId(rscmContractServiceInstallment.getId());
                rscmContractService.setComment(String.format("\u0420\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0430. \u0412\u0437\u043d\u043e\u0441 [%s%%] => %s \u0438\u0437 %s ", paymentsArray.getBigDecimal(0), 1, paymentsArray.length()));
                rscmContractService.setAmount(rscmContractService.getAmount().multiply(paymentsArray.getBigDecimal(0)).divide(new BigDecimal(100)));
            }
            contractServiceManager.updateContractService(rscmContractService);
            if (rscmContractServiceInstallment != null) {
                json = new JSONObject(rscmContractServiceInstallment.getInstallment());
                JSONArray contractServiceIds = json.optJSONArray("contractServiceIds");
                if (contractServiceIds == null) {
                    contractServiceIds = new JSONArray();
                    json.put("contractServiceIds", (Object)contractServiceIds);
                }
                contractServiceIds.put(rscmContractService.getId());
                rscmContractServiceInstallment.setInstallment(json.toString());
                contractServiceManager.updateRSCMContractServiceInstallment(rscmContractServiceInstallment);
            }
            this.context.publishAfterCommit((Event)new RSCMContractServiceUpdateEvent(this.userId, this.moduleId, contractId, rscmContractService));
            contractServiceManager.hotCalc(contractId, date);
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateRSCMService(RSCMService rscmService) throws BGException {
        new RSCMServiceManager(this.getConnection(), this.moduleId).updateService(rscmService);
    }

    public void deleteRSCMContractService(int rscmContractServiceId, int contractId, LocalDate month) throws BGException {
        Calendar closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionContractServiceDelete", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (LocalDate)month, null);
        }
        RSCMContractServiceManager contractServiceManager = new RSCMContractServiceManager(this.getConnection(), this.moduleId);
        contractServiceManager.deleteContractService(rscmContractServiceId, contractId, month);
        contractServiceManager.hotCalc(contractId, month);
    }

    public void deleteRSCMService(int rscmServiceId) throws BGException {
        new RSCMServiceManager(this.getConnection(), this.moduleId).deleteService(rscmServiceId);
    }

    public void recalculate(Date startMonth, String email, List<Integer> contractIds) throws BGException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startMonth);
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new RSCMRecalculator(this.moduleId, calendar, email, Utils.toString(contractIds)));
    }

    public List<IdTitle> getRSCMContractServiceList(boolean isUsing) throws BGException {
        ArrayList<IdTitle> idTitles = new ArrayList<IdTitle>();
        for (RSCMService service : new RSCMServiceManager(this.getConnection(), this.moduleId).getServiceList(isUsing)) {
            idTitles.add(new IdTitle(service.getServiceId(), service.getServiceTitle() + " (" + service.getUnit() + ")"));
        }
        return idTitles;
    }

    public List<IdTitle> getRSCMServiceList() throws BGException {
        ArrayList<IdTitle> items = new ArrayList<IdTitle>();
        List serviceList = ModuleCache.getInstance().getModuleServicesList(this.moduleId);
        List<RSCMService> rscmServiceList = new RSCMServiceManager(this.getConnection(), this.moduleId).getServiceList();
        int size_old = serviceList.size();
        int size_new = serviceList.size();
        for (Service service : serviceList) {
            for (RSCMService serv : rscmServiceList) {
                if (service.getId() != serv.getServiceId()) continue;
                size_new = size_old--;
                break;
            }
            if (size_old < size_new) {
                size_new = size_old;
                continue;
            }
            items.add(new IdTitle(service.getId(), service.getTitle()));
        }
        return items;
    }

    public SearchResult<RSCMContractServiceInstallment> searchRSCMContractServiceInstallment(int contractId, String[] sort, Page page) throws BGException, BGMessageException {
        SearchResult searchResult = new SearchResult();
        searchResult.setSort(sort);
        searchResult.setPage(page);
        try (RSCMContractServiceManager contractServiceManager = new RSCMContractServiceManager(this.getConnection(), this.moduleId);){
            contractServiceManager.searchContractServiceInstallment((SearchResult<RSCMContractServiceInstallment>)searchResult, contractId, page);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return searchResult;
    }

    public void deleteRSCMContractServiceInstallment(int id, int contractId) throws BGException, BGMessageException {
        Connection con = this.getConnection();
        try (RSCMContractServiceManager rscmContractServiceManager = new RSCMContractServiceManager(con, this.moduleId);){
            RSCMContractServiceInstallment rscmContractServiceInstallment = rscmContractServiceManager.getContractServiceInstallment(id);
            if (rscmContractServiceInstallment != null) {
                if (rscmContractServiceInstallment.getDateFrom().isBefore(LocalDate.now().withDayOfMonth(1))) {
                    throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u0435\u043a \u0441\u043e\u0437\u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0442\u0435\u043a\u0443\u0449\u0435\u043c \u043c\u0435\u0441\u044f\u0446\u0435");
                }
                if (rscmContractServiceInstallment.getPaymentCount() > 0) {
                    LocalDate now = LocalDate.now();
                    JSONObject json = new JSONObject(rscmContractServiceInstallment.getInstallment());
                    JSONArray serviceIds = json.optJSONArray("contractServiceIds");
                    if (serviceIds != null) {
                        for (int index = 0; index < serviceIds.length(); ++index) {
                            rscmContractServiceManager.deleteContractService(serviceIds.getInt(index), contractId, now);
                        }
                    }
                    rscmContractServiceManager.hotCalc(contractId, now);
                }
                rscmContractServiceManager.deleteContractServiceInstallment(id);
            }
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void infoRSCMContractServiceInstallment(int id) throws BGException, BGMessageException {
    }

    public void suspendRSCMContractServiceInstallment(int id) throws BGException, BGMessageException {
        Connection con = this.getConnection();
        try (RSCMContractServiceManager rscmContractServiceManager = new RSCMContractServiceManager(con, this.moduleId);){
            RSCMContractServiceInstallment rscmContractServiceInstallment = rscmContractServiceManager.getContractServiceInstallment(id);
            if (rscmContractServiceInstallment != null) {
                if (!rscmContractServiceInstallment.getStatus().equals((Object)RSCMContractServiceInstallmentStatus.IN_PROGRESS)) {
                    throw new BGMessageException("\u041f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0443 \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u0442\u0435\u043a\u0443\u0449\u0430\u044f\"");
                }
                rscmContractServiceInstallment.setStatus(RSCMContractServiceInstallmentStatus.SUSPEND);
                rscmContractServiceInstallment.setDateNext(null);
                rscmContractServiceManager.updateRSCMContractServiceInstallment(rscmContractServiceInstallment);
            }
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void resumeRSCMContractServiceInstallment(int id) throws BGException, BGMessageException {
        Connection con = this.getConnection();
        try (RSCMContractServiceManager rscmContractServiceManager = new RSCMContractServiceManager(con, this.moduleId);){
            RSCMContractServiceInstallment rscmContractServiceInstallment = rscmContractServiceManager.getContractServiceInstallment(id);
            if (rscmContractServiceInstallment != null) {
                if (!rscmContractServiceInstallment.getStatus().equals((Object)RSCMContractServiceInstallmentStatus.SUSPEND)) {
                    throw new BGMessageException("\u0412\u043e\u0437\u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0443 \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u043f\u0440\u0438\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u0430\u044f\"");
                }
                LocalDate dateNext = LocalDate.now();
                if (dateNext.getDayOfMonth() > rscmContractServiceInstallment.getDateFrom().getDayOfMonth()) {
                    dateNext = dateNext.withDayOfMonth(1).plusMonths(1L);
                }
                dateNext = dateNext.withDayOfMonth(Math.min(rscmContractServiceInstallment.getDateFrom().getDayOfMonth(), dateNext.lengthOfMonth()));
                rscmContractServiceInstallment.setDateNext(dateNext);
                rscmContractServiceInstallment.setStatus(RSCMContractServiceInstallmentStatus.IN_PROGRESS);
                rscmContractServiceManager.updateRSCMContractServiceInstallment(rscmContractServiceInstallment);
            }
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    public void cancelRSCMContractServiceInstallment(int id) throws BGException, BGMessageException {
        Connection con = this.getConnection();
        try (RSCMContractServiceManager rscmContractServiceManager = new RSCMContractServiceManager(con, this.moduleId);){
            RSCMContractServiceInstallment rscmContractServiceInstallment = rscmContractServiceManager.getContractServiceInstallment(id);
            if (rscmContractServiceInstallment != null) {
                if (!rscmContractServiceInstallment.getStatus().equals((Object)RSCMContractServiceInstallmentStatus.IN_PROGRESS)) {
                    throw new BGMessageException("\u0412\u043e\u0437\u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0440\u0430\u0441\u0441\u0440\u043e\u0447\u043a\u0443 \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u0442\u0435\u043a\u0443\u0449\u0430\u044f\"");
                }
                rscmContractServiceInstallment.setDateNext(null);
                rscmContractServiceInstallment.setStatus(RSCMContractServiceInstallmentStatus.CANCEL);
                rscmContractServiceManager.updateRSCMContractServiceInstallment(rscmContractServiceInstallment);
            }
        }
        catch (BGMessageException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }
}

