/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softkey.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.softkey.common.bean.SoftkeyProduct;
import ru.bitel.bgbilling.modules.softkey.common.bean.SoftkeyTransaction;
import ru.bitel.bgbilling.modules.softkey.common.bean.SoftkeyTransactionLog;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class SoftkeyTransactionManager {
    private String table_name = null;
    private String log_table_name = null;
    private String product_table_name = null;
    private Connection con = null;

    public SoftkeyTransactionManager(Connection con, int mid) {
        this.con = con;
        this.table_name = " softkey_transaction_" + mid;
        this.log_table_name = " softkey_transaction_log_" + mid;
        this.product_table_name = " softkey_product_" + mid;
    }

    public List<SoftkeyTransaction> getTransactionlist(String contractTitle, int status, Date fromDate, Date toDate) throws BGException {
        ArrayList<SoftkeyTransaction> result = new ArrayList<SoftkeyTransaction>();
        StringBuilder query = new StringBuilder("SELECT s.*, contract.title FROM");
        query.append(this.table_name + " AS s");
        query.append(" LEFT JOIN contract ON contract.id=s.cid");
        query.append(" WHERE s.status=" + status);
        if (!Utils.isBlankString((String)contractTitle)) {
            query.append(" AND contract.title LIKE %" + contractTitle + "%");
        }
        if (fromDate != null) {
            query.append(" AND s.dt>=?");
        }
        if (toDate != null) {
            query.append(" AND s.dt<=?");
        }
        query.append(" ORDER BY s.id");
        try {
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            if (fromDate != null) {
                ps.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)fromDate));
            }
            if (toDate != null) {
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)toDate));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                SoftkeyTransaction transaction = this.getTransactionFromRS(rs, true);
                result.add(transaction);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public SoftkeyTransaction getTransactionById(int transactionId) throws BGException {
        SoftkeyTransaction transaction = null;
        try {
            StringBuilder query = new StringBuilder("SELECT * FROM");
            query.append(this.table_name + " WHERE id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, transactionId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                transaction = this.getTransactionFromRS(rs, false);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return transaction;
    }

    public SoftkeyTransaction getTransactionByCid(int contractId, int optionId) throws BGException {
        SoftkeyTransaction result = null;
        StringBuilder query = new StringBuilder("SELECT * FROM");
        query.append(this.table_name + " WHERE cid=?");
        if (optionId > 0) {
            query.append(" AND option_id=?");
        }
        query.append(" AND  status IN (1");
        query.append(" ,2");
        query.append(" ,0 )");
        try {
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int index = 1;
            ps.setInt(index++, contractId);
            if (optionId > 0) {
                ps.setInt(index++, optionId);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result = this.getTransactionFromRS(rs, false);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public SoftkeyTransaction getTransactionByOrderId(int orderId) throws BGException {
        SoftkeyTransaction result = null;
        StringBuilder query = new StringBuilder("SELECT * FROM");
        query.append(this.table_name + " WHERE order_id=" + orderId);
        try {
            ResultSet rs = this.con.prepareStatement(query.toString()).executeQuery();
            while (rs.next()) {
                result = this.getTransactionFromRS(rs, false);
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void addTransaction(SoftkeyTransaction transaction) throws BGException {
        try {
            StringBuilder query = new StringBuilder("INSERT INTO" + this.table_name);
            query.append(" ( cid, order_id, option_id, option_title, status, dt, count, amount, activation_key, pay_dt )");
            query.append(" VALUES ( ?, ?, ?, ?, ?, NOW(), ?, ?, ?, ? )");
            PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getOrderId());
            ps.setInt(index++, transaction.getOptionId());
            ps.setString(index++, transaction.getOptionTitle());
            ps.setInt(index++, transaction.getStatus());
            ps.setInt(index++, transaction.getSubscribeCount());
            ps.setBigDecimal(index++, transaction.getSubscribeAmount());
            ps.setString(index++, transaction.getKey());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getPayDt()));
            ps.executeUpdate();
            int insertedTransactionId = ServerUtils.lastInsertId((PreparedStatement)ps);
            ps.close();
            transaction.setId(insertedTransactionId);
            query = new StringBuilder("INSERT INTO" + this.log_table_name);
            query.append(" SET transaction_id=?, dt=NOW(), status=?");
            ps = this.con.prepareStatement(query.toString());
            index = 1;
            ps.setInt(index++, insertedTransactionId);
            ps.setInt(index++, transaction.getStatus());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void updateTransaction(SoftkeyTransaction transaction) throws BGException {
        try {
            StringBuilder query = new StringBuilder("UPDATE" + this.table_name);
            query.append(" SET cid=?, order_id=?, option_id=?, option_title=?, status=?,");
            query.append(" dt=NOW(), count=?, amount=?, activation_key=?, pay_dt=?");
            query.append(" WHERE id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getOrderId());
            ps.setInt(index++, transaction.getOptionId());
            ps.setString(index++, transaction.getOptionTitle());
            ps.setInt(index++, transaction.getStatus());
            ps.setInt(index++, transaction.getSubscribeCount());
            ps.setBigDecimal(index++, transaction.getSubscribeAmount());
            ps.setString(index++, transaction.getKey());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getPayDt()));
            ps.setInt(index++, transaction.getId());
            ps.executeUpdate();
            ps.close();
            query = new StringBuilder("INSERT INTO" + this.log_table_name);
            query.append(" SET transaction_id=?, dt=NOW(), status=?");
            ps = this.con.prepareStatement(query.toString());
            index = 1;
            ps.setInt(index++, transaction.getId());
            ps.setInt(index++, transaction.getStatus());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<SoftkeyTransactionLog> getTransactionLog(int transactionId) throws BGException {
        ArrayList<SoftkeyTransactionLog> result = new ArrayList<SoftkeyTransactionLog>();
        try {
            StringBuilder query = new StringBuilder("SELECT * FROM" + this.log_table_name);
            query.append(" WHERE transaction_id=?");
            query.append(" ORDER BY id");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, transactionId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                SoftkeyTransactionLog log = new SoftkeyTransactionLog();
                log.setLogDate(TimeUtils.format((Date)rs.getTimestamp("dt"), (String)"dd.MM.yyyy HH:mm:ss"));
                log.setStatus(SoftkeyTransaction.getStatusName((int)rs.getInt("status")));
                result.add(log);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<SoftkeyProduct> getProductList() throws BGException {
        ArrayList<SoftkeyProduct> result = new ArrayList<SoftkeyProduct>();
        String query = "SELECT * FROM " + this.product_table_name + " ORDER BY id";
        try {
            ResultSet rs = this.con.prepareStatement(query).executeQuery();
            while (rs.next()) {
                SoftkeyProduct product = this.getProductFromRS(rs);
                result.add(product);
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public SoftkeyProduct getProductByOptionId(int optionId) throws BGException {
        SoftkeyProduct result = null;
        String query = "SELECT * FROM " + this.product_table_name + " WHERE subscribe_id=" + optionId;
        try {
            ResultSet rs = this.con.prepareStatement(query).executeQuery();
            while (rs.next()) {
                result = this.getProductFromRS(rs);
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void addProduct(SoftkeyProduct product) throws BGException {
        StringBuilder query = new StringBuilder("INSERT INTO " + this.product_table_name);
        query.append(" SET subscribe_id=?, subscribe_name=?, product_name=?, description=?, currency=?, amount=?");
        try {
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, product.getSubscribeId());
            ps.setString(2, product.getSubscribeName());
            ps.setString(3, product.getProductName());
            ps.setString(4, product.getProductDescription());
            ps.setString(5, product.getCurrency());
            ps.setBigDecimal(6, product.getAmount());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteProducts() throws BGException {
        String query = "DELETE FROM " + this.product_table_name;
        try {
            this.con.prepareStatement(query).executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private SoftkeyProduct getProductFromRS(ResultSet rs) throws SQLException {
        SoftkeyProduct product = new SoftkeyProduct();
        product.setId(rs.getInt("id"));
        product.setSubscribeId(rs.getInt("subscribe_id"));
        product.setSubscribeName(rs.getString("subscribe_name"));
        product.setProductName(rs.getString("product_name"));
        product.setProductDescription(rs.getString("description"));
        product.setCurrency(rs.getString("currency"));
        product.setAmount(rs.getBigDecimal("amount"));
        return product;
    }

    private SoftkeyTransaction getTransactionFromRS(ResultSet rs, boolean contractTitle) throws SQLException {
        SoftkeyTransaction result = new SoftkeyTransaction();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        if (contractTitle) {
            result.setContractTitle(rs.getString("contract.title"));
        }
        result.setOrderId(rs.getInt("order_id"));
        result.setOptionId(rs.getInt("option_id"));
        result.setOptionTitle(rs.getString("option_title"));
        result.setStatus(rs.getInt("status"));
        result.setDt(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dt")));
        result.setSubscribeCount(rs.getInt("count"));
        result.setSubscribeAmount(rs.getBigDecimal("amount"));
        result.setKey(rs.getString("activation_key"));
        result.setPayDt(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("pay_dt")));
        return result;
    }
}

