/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.softkey.server.bean;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Signature;
import java.util.Map;
import javax.crypto.Cipher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.softkey.server.bean.SoftkeyParams;
import ru.bitel.common.XMLUtils;

public class SoftkeyUtils {
    private static final Logger log = LogManager.getLogger();

    public static byte[] encrypt(Document doc, SoftkeyParams params) throws BGException {
        byte[] resultBytes = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLUtils.serialize((Node)doc, (OutputStream)baos, (String)"UTF-8");
            byte[] srcBytes = baos.toByteArray();
            log.info(new String("Outgoing xml: " + new String(srcBytes)));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, params.getSoftkeyPublicKey());
            resultBytes = cipher.doFinal(srcBytes);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return resultBytes;
    }

    public static Document decrypt(byte[] in, SoftkeyParams params) throws BGException {
        Document doc = null;
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, params.getISPPrivateKey());
            byte[] answerBytes = cipher.doFinal(in);
            String str = new String(answerBytes);
            log.info("Incoming xml: " + str);
            doc = XMLUtils.parseDocument((byte[])answerBytes);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return doc;
    }

    public static byte[] sign(SoftkeyParams params, byte[] data) throws BGException {
        byte[] resultSign = null;
        try {
            Signature signature = Signature.getInstance("SHA1withRSA");
            signature.initSign(params.getISPPrivateKey());
            signature.update(data);
            resultSign = signature.sign();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return resultSign;
    }

    public static Document createXml(Map<String, String> params) {
        Document doc = XMLUtils.newDocument();
        Element rootElement = doc.createElement("param");
        for (String key : params.keySet()) {
            Element el = XMLUtils.createElement((Element)rootElement, (String)key);
            el.setTextContent(params.get(key));
        }
        doc.appendChild(rootElement);
        return doc;
    }

    public static void setError(Document doc) {
        Element resultElement = XMLUtils.selectElement((Node)doc, (String)"//result");
        Element errorElement = XMLUtils.selectElement((Node)resultElement, (String)"//error");
        Element messageElement = XMLUtils.selectElement((Node)resultElement, (String)"//message");
        log.error(errorElement.getTextContent() + ": " + messageElement.getTextContent(), (Throwable)new BGException());
    }

    public static boolean hasError(Document doc) {
        boolean error = false;
        Element resultElement = XMLUtils.selectElement((Node)doc, (String)"//result");
        Element errorElement = XMLUtils.selectElement((Node)resultElement, (String)"//error");
        if (!errorElement.getTextContent().equals("0")) {
            error = true;
        }
        return error;
    }

    public static Document send(Map<String, String> dataParams, SoftkeyParams params, boolean isCrypt) throws BGException, IOException {
        byte[] xmlData = null;
        byte[] sign = null;
        Document answerDoc = null;
        try {
            if (isCrypt) {
                Document queryDataXml = SoftkeyUtils.createXml(dataParams);
                xmlData = SoftkeyUtils.encrypt(queryDataXml, params);
            } else {
                Document xml = SoftkeyUtils.createXml(dataParams);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLUtils.serialize((Node)xml, (OutputStream)baos, (String)"UTF-8");
                xmlData = baos.toByteArray();
                log.info("Outgoing xml: " + new String(xmlData));
                sign = SoftkeyUtils.sign(params, xmlData);
            }
            URL url = new URL("http://www.softkey.ua/ext_service/query.php");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            if (isCrypt) {
                con.setRequestProperty("X-Softkey-Auth", "crypt");
            } else {
                con.setRequestProperty("X-Softkey-Auth", "sign SHA-1");
            }
            con.setDoInput(true);
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(xmlData);
            if (!isCrypt && sign != null) {
                os.write(sign);
            }
            os.flush();
            os.close();
            String mode = con.getHeaderField("X-Softkey-Auth");
            InputStream is = con.getInputStream();
            Thread.sleep(2000L);
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] answerBytes = new byte[bis.available()];
            bis.read(answerBytes);
            if (mode.equals("crypt")) {
                answerDoc = SoftkeyUtils.decrypt(answerBytes, params);
            } else if (mode.equals("sign SHA-1")) {
                String str = new String(answerBytes, "UTF-8");
                int pos = str.indexOf("</result>");
                String newStr = str.substring(0, pos + 9);
                log.info("Incoming xml: " + newStr);
                answerDoc = XMLUtils.parseDocument((String)newStr);
            } else if (mode.equals("plain")) {
                Document errorDoc = XMLUtils.parseDocument((byte[])answerBytes);
                SoftkeyUtils.setError(errorDoc);
                throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430! \u0421\u043c. \u043b\u043e\u0433\u0438. ");
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return answerDoc;
    }
}

