/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.client;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.sorm.client.ContractsWithClosedSormResourcesDialog;
import ru.bitel.bgbilling.modules.sorm.client.SormSettingsPanel;
import ru.bitel.bgbilling.modules.sorm.client.SormStatisticPanel;
import ru.bitel.bgbilling.modules.sorm.common.SormManufacturer;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.list.BGUList;

public class SormProjectsPanel
extends BGUPanel {
    private static final String SETTINGS_PANEL = "settings";
    static final String LIST_PROJECTS_PANEL = "list_projects_panel";
    protected BGUList<SormProject> projectsList;
    private SormSettingsPanel sormSettingsPanel;
    private SormService sormService;
    private SormStatisticPanel sormStatisticPanel;
    AbstractBGUPanel.AsyncAction<Window> uploadWithoutPayments = new AbstractBGUPanel.AsyncAction<Window>("", "\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0431\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439"){

        protected Window doInBackground() {
            SormProject sormProject = (SormProject)SormProjectsPanel.this.projectsList.getSelectedValue();
            if (!sormProject.isEnable()) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0435\u043a\u0442 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0421\u041e\u0420\u041c \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d!");
                return null;
            }
            Window waitwindow = ClientUtils.showWaitWindow((String)"\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430...");
            try {
                SormProjectsPanel.this.getService().startUpload(sormProject, false);
                SormProjectsPanel.this.sormStatisticPanel.loadStatisticOfProject(sormProject);
            }
            catch (Exception ex) {
                waitwindow.dispose();
                ClientUtils.showErrorMessageDialog((String)ex.getMessage());
            }
            return waitwindow;
        }

        protected void done(Window waitwindow) {
            if (waitwindow != null) {
                waitwindow.dispose();
            }
        }
    };
    AbstractBGUPanel.AsyncAction<Window> uploadWithPayments = new AbstractBGUPanel.AsyncAction<Window>("", "\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430\u043c\u0438"){

        protected Window doInBackground() {
            SormProject sormProject = (SormProject)SormProjectsPanel.this.projectsList.getSelectedValue();
            if (!sormProject.isEnable()) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0435\u043a\u0442 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0421\u041e\u0420\u041c \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d!");
                return null;
            }
            Window waitwindow = ClientUtils.showWaitWindow((String)"\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430...");
            try {
                SormProjectsPanel.this.getService().startUpload(sormProject, true);
                SormProjectsPanel.this.sormStatisticPanel.loadStatisticOfProject(sormProject);
            }
            catch (Exception ex) {
                waitwindow.dispose();
                ClientUtils.showErrorMessageDialog((String)ex.getMessage());
            }
            return waitwindow;
        }

        protected void done(Window waitwindow) {
            if (waitwindow != null) {
                waitwindow.dispose();
            }
        }
    };
    AbstractBGUPanel.AsyncAction<Window> fullUploadWithPayments = new AbstractBGUPanel.AsyncAction<Window>("", "\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u043e\u043b\u043d\u0443\u044e \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0441 \u043f\u043b\u0430\u0442\u0435\u0436\u0430\u043c\u0438"){

        protected Window doInBackground() {
            SormProject sormProject = (SormProject)SormProjectsPanel.this.projectsList.getSelectedValue();
            if (!sormProject.isEnable()) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0435\u043a\u0442 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0421\u041e\u0420\u041c \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d!");
                return null;
            }
            Window waitwindow = ClientUtils.showWaitWindow((String)"\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430...");
            try {
                SormProjectsPanel.this.getService().startFullUpload(sormProject, true);
                SormProjectsPanel.this.sormStatisticPanel.loadStatisticOfProject(sormProject);
            }
            catch (Exception ex) {
                waitwindow.dispose();
                ClientUtils.showErrorMessageDialog((String)ex.getMessage());
            }
            return waitwindow;
        }

        protected void done(Window waitwindow) {
            if (waitwindow != null) {
                waitwindow.dispose();
            }
        }
    };
    AbstractBGUPanel.AsyncAction<Window> fullUploadWithoutPayments = new AbstractBGUPanel.AsyncAction<Window>("", "\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u043e\u043b\u043d\u0443\u044e \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0443 \u0431\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439"){

        protected Window doInBackground() {
            SormProject sormProject = (SormProject)SormProjectsPanel.this.projectsList.getSelectedValue();
            if (!sormProject.isEnable()) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0435\u043a\u0442 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0421\u041e\u0420\u041c \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d!");
                return null;
            }
            Window waitwindow = ClientUtils.showWaitWindow((String)"\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430...");
            try {
                SormProjectsPanel.this.getService().startFullUpload(sormProject, false);
                SormProjectsPanel.this.sormStatisticPanel.loadStatisticOfProject(sormProject);
            }
            catch (Exception ex) {
                waitwindow.dispose();
                ClientUtils.showErrorMessageDialog((String)ex.getMessage());
            }
            return waitwindow;
        }

        protected void done(Window waitwindow) {
            if (waitwindow != null) {
                waitwindow.dispose();
            }
        }
    };
    AbstractBGUPanel.DefaultAction clearStatisticForProject = new AbstractBGUPanel.DefaultAction("", "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u0434\u043b\u044f \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0435\u043a\u0442\u0430"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            SormProject selectedProject = (SormProject)SormProjectsPanel.this.projectsList.getSelectedValue();
            if (selectedProject == null) {
                return;
            }
            if (ClientUtils.confirm((String)("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u0434\u043b\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430 \"" + selectedProject.getTitle() + "\" ?"), (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438")) {
                SormProjectsPanel.this.getService().clearStatisticOfProject(selectedProject.getId(), null);
                SormProjectsPanel.this.sormStatisticPanel.loadStatisticOfProject(selectedProject);
            }
        }
    };
    AbstractBGUPanel.DefaultAction create = new AbstractBGUPanel.DefaultAction("new", "\u0421\u043e\u0437\u0434\u0430\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) {
            SormProjectsPanel.this.showPanel(SormProjectsPanel.SETTINGS_PANEL);
            SormProjectsPanel.this.sormSettingsPanel.performAction("new");
        }
    };
    AbstractBGUPanel.DefaultAction edit = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) {
            if (SormProjectsPanel.this.projectsList.getSelectedValue() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                return;
            }
            SormProjectsPanel.this.sormSettingsPanel.setSormProject((SormProject)SormProjectsPanel.this.projectsList.getSelectedValue());
            SormProjectsPanel.this.sormSettingsPanel.performAction("refresh");
            SormProjectsPanel.this.showPanel(SormProjectsPanel.SETTINGS_PANEL);
        }
    };
    AbstractBGUPanel.DefaultAction refresh = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            List projects = ((SormService)((ClientContext)SormProjectsPanel.this.getContext()).getPort(SormService.class)).getSormProjects();
            SormProjectsPanel.this.projectsList.setData(projects);
            if (Utils.notEmptyCollection((Collection)projects)) {
                SormProjectsPanel.this.sormStatisticPanel.loadStatisticOfProject((SormProject)projects.get(0));
            }
        }
    };
    AbstractBGUPanel.DefaultAction delete = new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            SormProject selectedProject = (SormProject)SormProjectsPanel.this.projectsList.getSelectedValue();
            if (selectedProject == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                return;
            }
            if (ClientUtils.confirmDelete((Object)selectedProject.getTitle())) {
                SormProjectsPanel.this.getService().deleteSormProject(selectedProject.getId());
                SormProjectsPanel.this.sormSettingsPanel.performAction("refresh");
                SormProjectsPanel.this.performAction("refresh");
            }
        }
    };

    protected void jbInit() throws Exception {
        this.setLayout(new CardLayout());
        this.sormSettingsPanel = new SormSettingsPanel(this);
        this.sormStatisticPanel = new SormStatisticPanel();
        final JPopupMenu popupMenu = new JPopupMenu();
        final JMenuItem addItem = new JMenuItem("\u0421\u043e\u0437\u0434\u0430\u0442\u044c");
        addItem.addActionListener(e -> this.performAction("new"));
        final JMenuItem editItem = new JMenuItem("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        editItem.addActionListener(e -> this.performAction("edit"));
        final JMenuItem deleteItem = new JMenuItem("\u0423\u0434\u0430\u043b\u0438\u0442\u044c");
        deleteItem.addActionListener(e -> this.performAction("delete"));
        final JMenuItem showProjectConfig = new JMenuItem("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e \u043f\u0440\u043e\u0435\u043a\u0442\u0430");
        showProjectConfig.addActionListener(e -> this.showConfig());
        final JMenuItem showStatistic = new JMenuItem("\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u0432\u044b\u0433\u0440\u0443\u0437\u043e\u043a");
        showStatistic.addActionListener(e -> {
            try {
                this.sormStatisticPanel.loadStatisticOfProject((SormProject)this.projectsList.getSelectedValue());
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        final JMenuItem checkClosedContracts = new JMenuItem("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
        checkClosedContracts.addActionListener(e -> {
            try {
                new ContractsWithClosedSormResourcesDialog(this.getService(), (SormProject)this.projectsList.getSelectedValue());
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        this.projectsList = new BGUList();
        this.projectsList.setCellRenderer((ListCellRenderer)new ProjectsListCellRenderer((ClientContext)this.getContext()));
        this.projectsList.setSelectionMode(0);
        this.projectsList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    SormProjectsPanel.this.performAction("edit");
                }
                if (SwingUtilities.isRightMouseButton(e) && SormProjectsPanel.this.projectsList.isEnabled()) {
                    popupMenu.removeAll();
                    if (SormProjectsPanel.this.projectsList.getSelectedValue() != null) {
                        popupMenu.add((Action)SormProjectsPanel.this.uploadWithPayments);
                        popupMenu.add((Action)SormProjectsPanel.this.uploadWithoutPayments);
                        popupMenu.addSeparator();
                        popupMenu.add((Action)SormProjectsPanel.this.fullUploadWithPayments);
                        popupMenu.add((Action)SormProjectsPanel.this.fullUploadWithoutPayments);
                        popupMenu.addSeparator();
                        popupMenu.add(showStatistic);
                        popupMenu.add((Action)SormProjectsPanel.this.clearStatisticForProject);
                        popupMenu.addSeparator();
                        popupMenu.add(checkClosedContracts);
                        popupMenu.addSeparator();
                        popupMenu.add(showProjectConfig);
                        popupMenu.addSeparator();
                        popupMenu.add(addItem);
                        popupMenu.add(editItem);
                        popupMenu.add(deleteItem);
                    } else {
                        popupMenu.add(addItem);
                    }
                    popupMenu.show(SormProjectsPanel.this.projectsList.getParent(), e.getX(), e.getY());
                }
            }
        });
        this.add((Component)new BGSplitPaneNoBorder(1, (Component)new JScrollPane((Component)this.projectsList), (Component)((Object)this.sormStatisticPanel), 200L), LIST_PROJECTS_PANEL);
        this.add((Component)((Object)this.sormSettingsPanel), SETTINGS_PANEL);
        this.showPanel(LIST_PROJECTS_PANEL);
        this.performAction("refresh");
    }

    void showPanel(String titlePanel) {
        CardLayout cardLayout = (CardLayout)this.getLayout();
        cardLayout.show((Container)((Object)this), titlePanel);
    }

    private void showConfig() {
        SormProject selectedProject = (SormProject)this.projectsList.getSelectedValue();
        if (selectedProject == null) {
            return;
        }
        Preferences preferences = new Preferences();
        preferences.loadData(selectedProject.getConfig(), "\n");
        preferences.set("sorm.ftp.password", "******");
        String config = preferences.toString();
        JTextArea configText = new JTextArea();
        configText.setLineWrap(true);
        configText.setEditable(false);
        configText.setText(config);
        Dimension size = new Dimension(500, 400);
        JScrollPane scrollPane = new JScrollPane(configText);
        scrollPane.setPreferredSize(size);
        scrollPane.setMinimumSize(size);
        scrollPane.setMaximumSize(size);
        JOptionPane.showMessageDialog(null, scrollPane, "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0435\u043a\u0442\u0430 " + selectedProject.getTitle(), -1);
    }

    private SormService getService() {
        if (this.sormService == null) {
            this.sormService = (SormService)((ClientContext)this.getContext()).getPort(SormService.class);
        }
        return this.sormService;
    }

    private final class ProjectsListCellRenderer
    implements ListCellRenderer<SormProject> {
        private final Font font = new Font("Dialog", 0, 15);
        private Directory<UserInfo> userDirectory;
        private boolean hasCustomUpload;

        ProjectsListCellRenderer(ClientContext clientContext) {
            try {
                this.userDirectory = clientContext.getDirectory(UserInfo.class, 0);
                this.hasCustomUpload = SormProjectsPanel.this.getService().checkCustomUpload();
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends SormProject> jList, SormProject sormProject, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel title = new JLabel("\u041f\u0440\u043e\u0435\u043a\u0442: " + sormProject.getTitle());
            title.setFont(new Font("Monospaced", 1, 15));
            UserInfo userInfo = null;
            try {
                userInfo = (UserInfo)this.userDirectory.get(sormProject.getUserId());
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            JLabel projectType = new JLabel("\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a: " + SormManufacturer.getType((int)sormProject.getProjectType()).getGuiTitle());
            projectType.setFont(this.font);
            JLabel createDate = new JLabel("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f: " + TimeUtils.format((Date)sormProject.getCreateDate(), (String)"dd.MM.yyyy"));
            createDate.setFont(this.font);
            JLabel lastModifyDate = new JLabel("\u0414\u0430\u0442\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f: " + TimeUtils.format((Date)sormProject.getLastModifyDate(), (String)"dd.MM.yyyy"));
            lastModifyDate.setFont(this.font);
            JLabel user = new JLabel((String)(userInfo != null ? "\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0441\u0434\u0435\u043b\u0430\u043b: " + userInfo.getName() : "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>"));
            user.setFont(this.font);
            String projectComment = sormProject.getComment();
            JLabel comment = new JLabel((String)(Utils.notBlankString((String)projectComment) ? "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439: " + projectComment : ""));
            comment.setFont(this.font);
            JPanel renderedPanel = new JPanel(new GridBagLayout());
            renderedPanel.setBackground(isSelected ? jList.getSelectionBackground() : jList.getBackground());
            GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0);
            renderedPanel.add((Component)title, constraints);
            renderedPanel.add((Component)projectType, constraints);
            renderedPanel.add((Component)comment, constraints);
            renderedPanel.add((Component)createDate, constraints);
            renderedPanel.add((Component)lastModifyDate, constraints);
            renderedPanel.add((Component)user, constraints);
            if (this.hasCustomUpload) {
                JLabel customUploadLabel = new JLabel("(\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0435\u0441\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0430\u044f \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f)");
                customUploadLabel.setFont(new Font("Dialog", 0, 11));
                renderedPanel.add((Component)customUploadLabel, constraints);
            }
            return renderedPanel;
        }
    }
}

