/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormUploadStatistic;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class SormStatisticDao
extends AbstractIdDao<SormUploadStatistic> {
    private static final String SORM_UPLOAD_STATISTIC_TABLE = "sorm_upload_statistic";

    public SormStatisticDao(Connection con, int moduleId) {
        this(con, moduleId, SORM_UPLOAD_STATISTIC_TABLE);
    }

    private SormStatisticDao(Connection con, int moduleId, String tableName) {
        super(con, moduleId, tableName);
    }

    public void getList(SearchResult<SormUploadStatistic> searchResult) throws BGException {
        List result = searchResult.getList();
        Page page = searchResult.getPage();
        String where = searchResult.getAttribute("where");
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName;
        if (Utils.notBlankString((String)where)) {
            query = query + " where " + where;
        }
        query = query + " ORDER BY uploadDate DESC";
        if (page != null) {
            query = query + page.sqlLimit();
        }
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void getListByProject(SearchResult<SormUploadStatistic> searchResult, int sormProjectId) throws BGException {
        List result = searchResult.getList();
        String query = "select * from " + this.tableName + " where sormProjectId=" + sormProjectId;
        try (Statement statement = this.con.createStatement();
             ResultSet rs = statement.executeQuery(query);){
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    protected SormUploadStatistic getFromRS(ResultSet rs) throws SQLException, BGException {
        SormUploadStatistic statistic = new SormUploadStatistic();
        statistic.setId(rs.getInt("id"));
        statistic.setSormProjectId(rs.getInt("sormProjectId"));
        statistic.setUploadDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("uploadDate")));
        statistic.setContractUploadCount(rs.getInt("uploadContractCount"));
        statistic.setFirstUploadContractId(rs.getInt("firstUploadContractId"));
        statistic.setLastUploadContractId(rs.getInt("lastUploadContract"));
        statistic.setUploadToFtpStatus(rs.getInt("uploadFtpStatus") == 0);
        statistic.setFtpUploadErrorMessage(rs.getString("error_message"));
        return statistic;
    }

    protected void updateImpl(SormUploadStatistic statistic) throws BGException, SQLException {
        statistic.setUploadDate(new Date());
        String set = " SET sormProjectId=?, uploadContractCount=?, lastUploadContract=?, firstUploadContractId=?, uploadFtpStatus=?, uploadDate=NOW(), error_message=? ";
        String query = statistic.getId() <= 0 ? "INSERT INTO " + this.tableName + set : "UPDATE " + this.tableName + set + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, statistic.getSormProjectId());
            ps.setInt(index++, statistic.getContractUploadCount());
            ps.setInt(index++, statistic.getLastUploadContractId());
            ps.setInt(index++, statistic.getFirstUploadContractId());
            ps.setInt(index++, statistic.getUploadToFtpStatus() ? 0 : 1);
            ps.setString(index, statistic.getFtpUploadErrorMessage());
            ps.executeUpdate();
        }
    }

    public void deleteStatisticForSormProject(int sormProjectId, Date dateFilter) throws BGException {
        String query = "DELETE FROM " + this.tableName + " WHERE sormProjectId=?";
        if (dateFilter != null) {
            query = query + " AND uploadDate<?";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, sormProjectId);
            if (dateFilter != null) {
                ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)dateFilter));
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

