/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload;

import bitel.billing.server.admin.bean.AddressManager;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.contract.object.bean.ObjectManager;
import bitel.billing.server.contract.object.bean.ParamValueManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormUploadStatistic;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormContract;
import ru.bitel.bgbilling.modules.sorm.server.upload.PaymentsToUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.UploadVersion;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUploadHelper;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;

public abstract class Upload
implements UploadVersion {
    protected ServerContext serverContext;
    protected Connection con;
    protected SormProject sormProject;
    protected Preferences config;
    protected List<SormContract> contracts;
    protected AddressManager addressManager;
    protected HouseDao houseDao;
    protected ContractManager contractManager;
    protected ContractParameterManager cpm;
    protected ParamValueManager valueManager;
    protected ObjectManager objectManager;
    protected PaymentsToUpload paymentsToUpload;
    protected SormUploadHelper helper;
    protected String localUserPath;
    protected final String adminEmail;
    private final List<String> installedSormModules = new ArrayList<String>();
    protected final boolean isFullUpload;

    public Upload(SormProject sormProject, boolean isFullUpload) {
        this.isFullUpload = isFullUpload;
        this.serverContext = (ServerContext)ServerContext.get();
        this.con = this.serverContext.getConnection();
        this.sormProject = sormProject;
        this.config = sormProject.getLoadedConfig();
        this.contractManager = new ContractManager(this.con);
        this.addressManager = new AddressManager(this.con, (DefaultServerSetup)Setup.getSetup());
        this.houseDao = new HouseDao(this.con);
        this.cpm = new ContractParameterManager(this.con);
        this.valueManager = new ParamValueManager(this.con);
        this.objectManager = new ObjectManager(this.con);
        this.contracts = SormUtils.getUploadContracts(this.con, sormProject.getId(), isFullUpload, this.config);
        this.localUserPath = Utils.maskBlank((String)this.config.get("sorm.local.catalog"), (String)"");
        if (this.localUserPath.endsWith("/")) {
            this.localUserPath = this.localUserPath.substring(0, this.localUserPath.length() - 1);
        }
        this.adminEmail = SormUtils.getAdminEmail(this.config);
        this.paymentsToUpload = new PaymentsToUpload(this.serverContext, isFullUpload, sormProject);
        try {
            this.helper = new SormUploadHelper(this.config, this.con, this.addressManager);
            SormService sormService = (SormService)this.serverContext.getService(SormService.class, this.serverContext.getModuleId());
            sormService.getInstalledSormModules().forEach(module -> this.installedSormModules.add(module.getTitleModule()));
        }
        catch (BGException bGException) {
            // empty catch block
        }
    }

    public void uploadForStatistic(SormUploadStatistic statistic) {
        int firstContractId = statistic.getFirstUploadContractId();
        int lastContractId = statistic.getLastUploadContractId();
        this.contracts.removeIf(contract -> contract.getContractId() < firstContractId || contract.getContractId() > lastContractId);
    }

    public void closeResources() {
        if (Utils.notEmptyCollection(this.contracts)) {
            SormUtils.clearChangedContractsTable(this.con);
        }
        if (this.contractManager != null) {
            this.contractManager.recycle();
        }
    }

    protected boolean checkInstalledModule(UploadModulesTitle module) {
        return this.installedSormModules.contains(module.getTitleModule());
    }
}

