/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.server.bean;

import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.tariff.TariffModuleTree;
import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.modules.subscription.common.bean.RegistrationPeriod;
import ru.bitel.bgbilling.modules.subscription.common.bean.Subscription;
import ru.bitel.bgbilling.modules.subscription.common.bean.SubscriptionType;
import ru.bitel.bgbilling.modules.subscription.server.bean.CostSumTime;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionDao;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionJob;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionPeriodDao;
import ru.bitel.bgbilling.modules.subscription.server.bean.SubscriptionTypeDao;
import ru.bitel.bgbilling.modules.subscription.server.event.SubscriptionActivateEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.oss.kernel.job.server.JobScheduler;

public class SubscriptionUtils {
    private Connection con = null;
    private Logger logger = LogManager.getLogger();

    public SubscriptionUtils(Connection con) {
        this.con = con;
    }

    public void subscriptionActivate(Subscription subscription, Date initDate, int moduleId, int userId, SubscriptionDao subscriptionDao) throws BGException {
        this.subscriptionActivate(subscription, initDate, moduleId, userId, true, subscriptionDao);
    }

    public void subscriptionActivate(Subscription subscription, Date initDate, int moduleId, int userId, boolean changeBalance, SubscriptionDao subscriptionDao) throws BGException {
        PeriodWithTime subscriptionPeriod;
        int contractId = subscription.getContractId();
        int registrationPeriodId = subscription.getRegistrationPeriodId();
        if (registrationPeriodId > 0) {
            RegistrationPeriod registrationPeriod = null;
            try (SubscriptionPeriodDao subscriptionPeriodDao = new SubscriptionPeriodDao(this.con, moduleId, userId);){
                registrationPeriod = (RegistrationPeriod)subscriptionPeriodDao.get(registrationPeriodId);
            }
            if (registrationPeriod != null) {
                PeriodWithTime lastRegistrationPeriod = registrationPeriod.getPeriod();
                if (TimeUtils.dateInPeriod((LocalDateTime)TimeUtils.convertDateToLocalDateTime((Date)initDate), (PeriodWithTime)lastRegistrationPeriod)) {
                    throw new BGException("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u0430 \u0437\u0430\u0434\u0430\u043d\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u0443\u0436\u0435 \u0435\u0441\u0442\u044c \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434.");
                }
            }
        }
        if (!TimeUtils.dateInRangeWithTime((Date)new Date(), (Date)(subscriptionPeriod = subscription.getPeriod()).getDateFrom(), (Date)subscriptionPeriod.getDateTo())) {
            throw new BGException("\u041f\u0435\u0440\u0438\u043e\u0434 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u0435\u0449\u0435 \u043d\u0435 \u043d\u0430\u0441\u0442\u0443\u043f\u0438\u043b \u0438\u043b\u0438 \u0443\u0436\u0435 \u0437\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u0441\u044f");
        }
        SubscriptionTypeDao subscriptionTypeDao = new SubscriptionTypeDao(this.con, moduleId);
        SubscriptionType subscriptionType = (SubscriptionType)subscriptionTypeDao.get(subscription.getTypeId());
        subscriptionTypeDao.close();
        PeriodWithTime newRegistrationPeriod = subscriptionType.getNewRegistrationPeriod(initDate);
        if (subscriptionPeriod.getDateTo() != null && newRegistrationPeriod.getDateTo().after(subscriptionPeriod.getDateTo())) {
            throw new BGException("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u0434\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u0443\u0447\u0435\u0442\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438");
        }
        BigDecimal cost = BigDecimal.ZERO;
        try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
            if (changeBalance) {
                List<TariffModuleTree> tariffModuleTrees = this.getSubscriptionTariffModuleTree(contractId, initDate, moduleId);
                if (tariffModuleTrees == null || tariffModuleTrees.size() == 0) {
                    throw new BGException("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430, \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u0442\u0430\u0440\u0438\u0444 \u043d\u0430 \u0434\u0430\u0442\u0443 - " + TimeUtils.formatDate((Date)initDate));
                }
                cost = this.getSubscriptionCost(tariffModuleTrees, initDate, subscriptionType.getServiceId(), contractId);
                if (cost == null) {
                    throw new BGException("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430, \u0432 \u0442\u0430\u0440\u0438\u0444\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0446\u0435\u043d\u0430");
                }
                BigDecimal contractLimit = BigDecimal.ZERO;
                BigDecimal balanceSumma = balanceUtils.getBalance(initDate, contractId);
                if (Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId)).getBoolean("subscription.balance.contract.limit", false)) {
                    ContractDao contractDao = new ContractDao(this.con, 0);
                    Contract contract = (Contract)contractDao.get(contractId);
                    if (contract != null) {
                        contractLimit = contract.getBalanceLimit();
                    }
                    contractDao.close();
                }
                if (balanceSumma.subtract(contractLimit).compareTo(cost) == -1 && balanceSumma.compareTo(cost) == -1) {
                    throw new BGMessageException("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430, \u043d\u0435 \u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0435");
                }
            }
            this.subscriptionActivateApply(contractId, subscription.getId(), subscriptionType.getServiceId(), initDate, cost, newRegistrationPeriod, moduleId, userId, subscriptionDao, balanceUtils);
            this.addSubscriptionJob(subscription, moduleId, newRegistrationPeriod.getDateTo(), subscriptionDao);
            EventProcessor.getInstance().publish((Event)new SubscriptionActivateEvent(moduleId, subscription.getContractId(), userId, subscription.getId()));
        }
    }

    public long addSubscriptionJob(Subscription subscription, int moduleId, Date jobDateTime, SubscriptionDao subscriptionDao) throws BGException {
        long subscriptionJobId = -1L;
        if (subscription != null) {
            JobScheduler jobExecutor = JobScheduler.getInstance((String)"subscription", (int)moduleId);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("subscriptionId", String.valueOf(subscription.getId()));
            subscriptionJobId = jobExecutor.schedule(SubscriptionJob.class, (ParameterMap)new ParameterMap.DefaultParameterMap(params), jobDateTime);
            if (subscriptionJobId > 0L) {
                subscriptionDao.updateSubscriptionJobId(subscription.getId(), subscriptionJobId);
            }
        }
        return subscriptionJobId;
    }

    public void subscriptionActivateApply(int contractId, int subscriptionId, int serviceId, Date initDate, BigDecimal cost, PeriodWithTime newRegistrationPeriod, int moduleId, int userId, SubscriptionDao subscriptionDao, BalanceUtils balanceUtils) throws BGException {
        if (balanceUtils != null) {
            balanceUtils.addContractAccount(contractId, initDate, serviceId, cost.floatValue());
            balanceUtils.updateBalance(initDate, contractId);
        }
        RegistrationPeriod registrationPeriod = new RegistrationPeriod();
        registrationPeriod.setSubscriptionId(subscriptionId);
        registrationPeriod.setPeriod(newRegistrationPeriod);
        registrationPeriod.setDateCreate(initDate);
        registrationPeriod.setWhoCreate(userId);
        try (SubscriptionPeriodDao subscriptionPeriodDao = new SubscriptionPeriodDao(this.con, moduleId, userId);){
            subscriptionPeriodDao.update(registrationPeriod);
        }
        subscriptionDao.updateRegistrationPeriodId(subscriptionId, registrationPeriod.getId());
        CostSumTime costSumTime = new CostSumTime(-1, contractId, subscriptionId, cost, initDate);
        subscriptionDao.addDetail(costSumTime, registrationPeriod.getId());
    }

    public List<TariffModuleTree> getSubscriptionTariffModuleTree(int contractId, Date initDate, int moduleId) {
        try (ContractManager contractManager = new ContractManager(this.con);){
            List list = contractManager.getRealtimeTariffTreeSet(contractId, initDate, "subscription", moduleId, true).getTreeList(initDate);
            return list;
        }
    }

    public BigDecimal getSubscriptionCost(List<TariffModuleTree> tariffModuleTrees, Date initDate, int serviceId, int contractId) {
        BigDecimal result = null;
        for (TariffModuleTree tariffModuleTree : tariffModuleTrees) {
            TariffRequest tariffRequest = new TariffRequest();
            tariffRequest.setRequestParam("sid", (Object)serviceId);
            tariffRequest.setRequestParam("time", (Object)initDate);
            try {
                tariffRequest.setRequestParam("tariffOptions", (Object)ContractTariffOptionDao.getContractRealtimeTariffOptionList((Connection)this.con, (int)contractId, (Date)initDate));
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
            tariffModuleTree.processRequest(tariffRequest);
            BigDecimal cost = (BigDecimal)tariffRequest.getResponseParam("cost");
            if (cost == null) continue;
            result = cost;
            break;
        }
        return result;
    }
}

