/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.common.bean;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDevice;
import ru.bitel.bgbilling.modules.tv.common.bean.TvDeviceType;
import ru.bitel.bgbilling.modules.tv.server.bean.TvDeviceDao;
import ru.bitel.bgbilling.modules.tv.server.event.TvReloadEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.resource.server.bean.DevicePortDao;

public class TvDeviceMap
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private static final ConcurrentMap<Integer, TvDeviceMap> moduleMap = new ConcurrentHashMap<Integer, TvDeviceMap>();
    private final int moduleId;
    private volatile Map<Integer, TvDeviceMapItem> deviceMap;
    private final AtomicLong version = new AtomicLong();

    public static synchronized TvDeviceMap getInstance(int moduleId) throws BGException {
        TvDeviceMap result = (TvDeviceMap)moduleMap.get(moduleId);
        if (result == null) {
            result = new TvDeviceMap(moduleId);
            moduleMap.put(moduleId, result);
        }
        return result;
    }

    TvDeviceMap(int moduleId) throws BGException {
        this.moduleId = moduleId;
        EventProcessor.getInstance().addListener((EventListener)this, TvReloadEvent.class, moduleId, null);
    }

    public long getVersion() {
        return this.version.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, TvDeviceMapItem> load() throws BGException {
        logger.info("(Re)loading InetDeviceMap");
        Setup setup = Setup.getSetup();
        ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(this.moduleId));
        ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)Setup.getSetup(), (boolean)true);
        try {
            TvDeviceDao tvDeviceDao = new TvDeviceDao(connectionSet.getConnection(), this.moduleId, 0);
            DevicePortDao devicePortDao = new DevicePortDao(connectionSet.getConnection(), this.moduleId);
            TvDevice rootDevice = (TvDevice)tvDeviceDao.root(null, null, -1, null, null);
            HashMap<Integer, TvDeviceMapItem> idMap = new HashMap<Integer, TvDeviceMapItem>();
            this.loadDevice((ParameterMap)moduleSetup, idMap, devicePortDao, rootDevice, null);
            this.version.incrementAndGet();
            HashMap<Integer, TvDeviceMapItem> hashMap = idMap;
            return hashMap;
        }
        finally {
            connectionSet.recycle();
        }
    }

    private void loadDevice(ParameterMap moduleSetup, Map<Integer, TvDeviceMapItem> idMap, DevicePortDao devicePortDao, TvDevice tvDevice, TvDeviceMapItem parent) throws BGException {
        TvDeviceType tvDeviceType = (TvDeviceType)tvDevice.getDeviceType();
        Preferences vars = new Preferences();
        vars.set("deviceId", String.valueOf(tvDevice.getId()));
        Object config = null;
        if (Utils.notBlankString((String)tvDevice.getConfig())) {
            config = new Preferences((ParameterMap)vars, tvDevice.getConfig(), "\n");
        }
        if (tvDeviceType != null && Utils.notBlankString((String)tvDeviceType.getConfig())) {
            config = config != null ? new Preferences((ParameterMap)vars, tvDeviceType.getConfig(), "\n").inherit((ParameterMap)config) : new Preferences((ParameterMap)vars, tvDeviceType.getConfig(), "\n");
        }
        if (parent != null) {
            config = config != null ? parent.config.inherit((ParameterMap)config) : parent.config;
        } else {
            if (config == null) {
                config = new Preferences((ParameterMap)vars, tvDevice.getConfig(), "\n");
            }
            if (moduleSetup != null) {
                config = moduleSetup.inherit((ParameterMap)config);
            }
        }
        TvDeviceMapItem holder = new TvDeviceMapItem(parent, tvDevice, (ParameterMap)config);
        idMap.put(tvDevice.getId(), holder);
        TvDeviceMapItem iteratorParent = parent;
        while (iteratorParent != null) {
            iteratorParent.descendantIds0.add(tvDevice.getId());
            iteratorParent = iteratorParent.parent;
        }
        List children = tvDevice.getChildren();
        if (children != null && children.size() > 0) {
            for (TvDevice child : children) {
                this.loadDevice(moduleSetup, idMap, devicePortDao, child, holder);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TvDeviceMapItem get(int deviceId) throws BGException {
        Map<Integer, TvDeviceMapItem> deviceMap = this.deviceMap;
        if (deviceMap == null) {
            TvDeviceMap tvDeviceMap = this;
            synchronized (tvDeviceMap) {
                deviceMap = this.deviceMap = this.load();
            }
        }
        return deviceMap.get(deviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(Event e, EventListenerContext ctx) throws BGException {
        TvDeviceMap tvDeviceMap = this;
        synchronized (tvDeviceMap) {
            this.deviceMap = null;
        }
    }

    public class TvDeviceMapItem {
        final TvDeviceMapItem parent;
        final TvDevice device;
        final ParameterMap config;
        final Set<Integer> descendantIds0;
        final Set<Integer> descendantIds;

        public TvDeviceMapItem(TvDeviceMapItem parent, TvDevice device, ParameterMap config) {
            this.parent = parent;
            this.device = device;
            this.config = config;
            this.descendantIds0 = new HashSet<Integer>();
            this.descendantIds = Collections.unmodifiableSet(this.descendantIds0);
        }

        public TvDeviceMapItem getParent() {
            return this.parent;
        }

        public TvDevice getDevice() {
            return this.device;
        }

        public ParameterMap getConfig() {
            return this.config;
        }

        public Set<Integer> getDescendantIds() {
            return this.descendantIds;
        }
    }
}

