/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.runtime;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.ConvergenceBalanceManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSetDao;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeCache;
import ru.bitel.bgbilling.modules.tv.server.TvUtils;
import ru.bitel.bgbilling.modules.tv.server.bean.TvAccountDetailDao;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.ProductSpecRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeRoot;
import ru.bitel.bgbilling.modules.tv.server.runtime.bean.ProductRejectCause;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvServiceCost;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffWorkerContext;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOffering;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOfferingActivationMode;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;

public class TvTarifficationManager {
    private static final Logger logger = LogManager.getLogger();
    private final Setup setup;
    private final ConnectionSet connectionSet;
    private final int moduleId;
    private BalanceDao balanceDao;
    private PoolEventPublisher<ContractBalanceChangedEvent> balanceEP;
    private final Calendar utilCalendar = new GregorianCalendar();
    private int _dd = -1;
    private int _mm = -1;
    private int _yy = -1;
    private PreparedStatement insertDetailPS;
    private final int balanceRoundingScale = 5;
    private final RoundingMode balanceRoundingMode = RoundingMode.HALF_EVEN;

    private BalanceDao getBalanceDao() {
        if (this.balanceDao == null) {
            this.balanceDao = new BalanceDao(this.connectionSet.getConnection());
        }
        return this.balanceDao;
    }

    public TvTarifficationManager(Setup setup, ConnectionSet connectionSet, int moduleId) {
        this.setup = setup;
        this.connectionSet = connectionSet;
        this.moduleId = moduleId;
    }

    public TvTarifficationManager(Setup setup, ConnectionSet connectionSet, int moduleId, PoolEventPublisher<ContractBalanceChangedEvent> balanceEP) {
        this.setup = setup;
        this.connectionSet = connectionSet;
        this.moduleId = moduleId;
        this.balanceEP = balanceEP;
    }

    private static TvTariffRequest tarifficate(TvTariffContext tariffContext, TvTariffWorkerContext workerContext, int moduleId, ConnectionSet connectionSet, ContractRuntime contractRuntime, int contractId, TvAccountRuntime tvAccountRuntime, int tvAccountId, long contractGroups, List<TariffModuleTreeSet.Entry> treeList, BigDecimal balance, BigDecimal limit, ContractTariffOptionList contractTariffOptions, List<TvServiceCost> tvServiceCostList, Calendar tariffRequestTime) throws BGException {
        TvTariffRequest req = new TvTariffRequest(contractRuntime.getDomainId(), moduleId, contractId, tvAccountId, contractGroups, 0L);
        req.setConnectionSet(connectionSet);
        req.setTime(tariffRequestTime);
        req.setBalance(balance);
        req.setLimit(limit);
        req.setContractTariffOptions(contractTariffOptions);
        req.setContractProductPeriodRuntimeList(contractRuntime.getContractProductPeriods(tariffRequestTime.getTime()));
        if (tvAccountId != 0) {
            req.setProductPeriodRuntimeList(tvAccountRuntime.getProductPeriodRuntimeList());
        }
        for (TvServiceCost tvServiceCost : tvServiceCostList) {
            req.addServiceCost(tvServiceCost);
        }
        int size = treeList.size();
        for (int i = 0; i < size; ++i) {
            TariffModuleTreeSet.Entry tree = treeList.get(i);
            if (logger.isDebugEnabled()) {
                logger.debug("TariffRequest:\n" + req);
            }
            req.setTariffTreeSetEntry(tree);
            tree.getTree().execute((AbstractTariffRequest)req, (TariffContext)tariffContext, (ThreadContext)workerContext);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Executed TariffRequest:\n" + req);
        }
        return req;
    }

    private TvTariffRequest tarifficateOfferings(int contractId, int accountId, List<TariffModuleTreeSet.Entry> treeList, List<ProductOffering> productOfferingList, Date date, Calendar calendar) throws BGException {
        ProductOffering productOffering;
        ArrayList<TvServiceCost> serviceCostList = new ArrayList<TvServiceCost>();
        HashMap<Integer, ProductOfferingActivationMode> activationModeMap = new HashMap<Integer, ProductOfferingActivationMode>();
        ProductSpecRuntimeMap productSpecRuntimeMap = ProductSpecRuntimeMap.getInstance(this.connectionSet);
        int size = productOfferingList.size();
        for (int i = 0; i < size; ++i) {
            productOffering = productOfferingList.get(i);
            int productSpecId = productOffering.getProductSpec().getId();
            List activationModeList = productOffering.getActivationModeList();
            ProductSpecRuntime productSpecRuntime = (ProductSpecRuntime)productSpecRuntimeMap.get(productSpecId);
            int jsize = activationModeList.size();
            for (int j = 0; j < jsize; ++j) {
                ProductOfferingActivationMode activationMode = (ProductOfferingActivationMode)activationModeList.get(j);
                int activationModeId = activationMode.getProductSpecActivationMode().getId();
                TvServiceCost serviceCost = new TvServiceCost(-productSpecId, 0, activationModeId, date, productSpecRuntime, null, calendar, null, 1L);
                serviceCostList.add(serviceCost);
                activationModeMap.put(activationModeId, activationMode);
            }
        }
        TvTariffRequest req = this.tarifficate(contractId, null, accountId, treeList, serviceCostList, date, calendar);
        for (TvServiceCost serviceCost : req.getServiceCostList()) {
            int serviceId = serviceCost.serviceId;
            BigDecimal price = serviceCost.cost;
            if (serviceId <= 0 || price == null) continue;
            ProductOfferingActivationMode activationMode = (ProductOfferingActivationMode)activationModeMap.get(serviceCost.activationModeId);
            activationMode.setActivationPrice(serviceCost.activationPrice);
            activationMode.setPrice(price);
            activationMode.setPeriodMode(serviceCost.periodMode);
            activationMode.setPeriodAmount(serviceCost.periodAmount);
        }
        Iterator<ProductOffering> productOfferingIter = productOfferingList.iterator();
        while (productOfferingIter.hasNext()) {
            productOffering = productOfferingIter.next();
            List activationModeList = productOffering.getActivationModeList();
            int periodMode = -1;
            int periodAmount = -1;
            BigDecimal price = null;
            boolean priceEq = true;
            boolean periodEq = true;
            Iterator activationModeIter = activationModeList.iterator();
            while (activationModeIter.hasNext()) {
                ProductOfferingActivationMode activationMode = (ProductOfferingActivationMode)activationModeIter.next();
                BigDecimal activationModePrice = activationMode.getPrice();
                if (activationModePrice == null || activationMode.getActivationPrice() == null) {
                    activationModeIter.remove();
                    continue;
                }
                if (price == null) {
                    price = activationModePrice;
                } else if (price.compareTo(activationModePrice) != 0) {
                    priceEq = false;
                }
                if (periodMode == -1) {
                    periodMode = activationMode.getPeriodMode();
                    periodAmount = activationMode.getPeriodAmount();
                    continue;
                }
                if (periodMode == activationMode.getPeriodMode() && periodAmount == activationMode.getPeriodAmount()) continue;
                periodEq = false;
            }
            if (activationModeList.size() == 0) {
                productOfferingIter.remove();
                continue;
            }
            if (priceEq) {
                productOffering.setPrice(price);
            }
            if (!periodEq) continue;
            productOffering.setPeriodMode(periodMode);
            productOffering.setPeriodAmount(periodAmount);
        }
        return req;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TvTariffRequest tarifficate(int contractId, TvAccountRuntime tvAccountRuntime, Date date) throws BGException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Date)date);
        TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(this.connectionSet.getConnection());
        TariffModuleTreeSet treeSet = treeSetDao.getTariffTreeSetForDay(contractId, (Calendar)calendar, "tv", this.moduleId, this.moduleId, tvAccountRuntime.tvAccountId);
        treeSetDao.freeResources();
        List treeList = treeSet.getEntryList(calendar.getTimeInMillis());
        tvAccountRuntime.lock();
        try {
            List<TvServiceCost> serviceCostList = TvUtils.createServiceCostList(ProductSpecRuntimeMap.getInstance(this.connectionSet), tvAccountRuntime, date.getTime());
            TvTariffRequest tvTariffRequest = this.tarifficate(contractId, tvAccountRuntime, tvAccountRuntime.tvAccountId, treeList, serviceCostList, date, calendar);
            return tvTariffRequest;
        }
        finally {
            tvAccountRuntime.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TvTariffRequest tarifficate(int contractId, TvAccountRuntime tvAccountRuntime, int accountId, List<TariffModuleTreeSet.Entry> treeList, List<TvServiceCost> serviceCostList, Date date, Calendar calendar) throws BGException {
        TvTariffRequest req;
        TvTariffContext tariffContext = new TvTariffContext(this.connectionSet, this.moduleId, calendar.getTime(), TvTariffContext.TvTariffMode.realtime);
        TvTariffWorkerContext workerContext = new TvTariffWorkerContext(this.setup, this.moduleId);
        try {
            BigDecimal limit;
            BigDecimal balance;
            ContractRuntime contractRuntime = contractId == 0 ? ContractRuntime.STUB : ContractRuntimeMap.getInstance().getContractRuntime(this.connectionSet, Integer.valueOf(contractId));
            ContractTariffOptionList contractTariffOptions = contractRuntime.getTariffOptions(calendar.getTime());
            Map tariffOptionsMap = null;
            if (contractTariffOptions != null) {
                long millis = calendar.getTimeInMillis();
                tariffOptionsMap = contractTariffOptions.map(millis, millis);
            }
            logger.debug("TariffOptionMap: " + tariffOptionsMap);
            if (contractId == 0) {
                balance = BigDecimal.ZERO;
                limit = BigDecimal.ZERO;
            } else {
                ConvergenceBalance convergenceBalance = ConvergenceBalanceManager.getInstance().getBalance(this.connectionSet, Integer.valueOf(contractId), date.getTime());
                balance = convergenceBalance.getBalance();
                limit = convergenceBalance.getLimit();
            }
            if (tvAccountRuntime == null) {
                tariffContext.getTvAccountRuntimeMap().load(this.connectionSet, contractId);
                tvAccountRuntime = tariffContext.getTvAccountRuntimeMap().get(accountId);
            }
            req = TvTarifficationManager.tarifficate(tariffContext, workerContext, this.moduleId, this.connectionSet, contractRuntime, contractId, tvAccountRuntime, accountId, contractRuntime.getContractGroups(), treeList, balance, limit, contractTariffOptions, serviceCostList, calendar);
        }
        finally {
            workerContext.recycle();
        }
        return req;
    }

    public TvTariffRequest tarifficateOfferings(int contractId, int accountId, List<ProductOffering> productOfferingList, Date date) throws BGException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Date)date);
        TariffModuleTreeSetDao treeSetDao = new TariffModuleTreeSetDao(this.connectionSet.getConnection());
        TariffModuleTreeSet treeSet = treeSetDao.getTariffTreeSetForDay(contractId, (Calendar)calendar, "tv", this.moduleId, this.moduleId, accountId);
        treeSetDao.freeResources();
        List treeList = treeSet.getEntryList(calendar.getTimeInMillis());
        return this.tarifficateOfferings(contractId, accountId, treeList, productOfferingList, date, calendar);
    }

    public TvTariffRequest tarifficateOfferings(Connection con, int tariffPlanId, List<ProductOffering> productOfferingList, Date date) throws BGException {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Date)date);
        int treeId = new TariffPlanDao(con).getTariffPlanTreeId(tariffPlanId);
        AtomicReference tree = TariffTreeCache.getInstance().getModuleTree(con, treeId, this.moduleId, "tv");
        if (tree.get() == null) {
            logger.info("Tariff module tree not found for tariffPlanId:" + tariffPlanId + " and moduleId:" + this.moduleId);
            return null;
        }
        List<TariffModuleTreeSet.Entry> treeList = Collections.singletonList(new TariffModuleTreeSet.Entry(tree, 0L, 0L));
        return this.tarifficateOfferings(0, 0, treeList, productOfferingList, date, calendar);
    }

    private boolean init(int yy, int mm, int dd) throws SQLException {
        if (this._dd == dd) {
            if (this._mm == mm && this._yy == yy) {
                return false;
            }
        } else {
            this._dd = dd;
            if (this._mm == mm && this._yy == yy) {
                this.insertDetailPS.setInt(5, this._dd);
                return false;
            }
        }
        this._mm = mm;
        this._yy = yy;
        if (this.insertDetailPS != null) {
            this.insertDetailPS.close();
            this.insertDetailPS = null;
        }
        Connection con = this.connectionSet.getConnection();
        GregorianCalendar month = new GregorianCalendar(this._yy, this._mm - 1, 1);
        String detailTable = ServerUtils.getModuleMonthTableName((String)"tv_account_detail", (Date)month.getTime(), (int)this.moduleId);
        TvAccountDetailDao.checkTable(con, detailTable);
        this.insertDetailPS = con.prepareStatement("INSERT INTO " + detailTable + " (contractId, accountId, productId, sid, day, account) VALUES (?,?,?,?,?,?) ON DUPLICATE KEY UPDATE account=account+?");
        this.insertDetailPS.setInt(5, this._dd);
        return true;
    }

    private static void addAccountDelta(Map<Integer, AccountDelta> accountDeltaMap, int sid, BigDecimal account) {
        AccountDelta accountDelta = accountDeltaMap.get(sid);
        if (accountDelta == null) {
            accountDelta = new AccountDelta(account);
            accountDeltaMap.put(sid, accountDelta);
        } else {
            accountDelta.delta = accountDelta.delta.add(account);
        }
    }

    private static void addProductAccountDelta(Map<MonthKey, Map<ProductAccountKey, AccountDelta>> productAccountDeltaMonthMap, int productId, int serviceId, Calendar date, BigDecimal account) {
        int yy = date.get(1);
        int mm = date.get(2) + 1;
        int day = date.get(5);
        ProductAccountKey key = new ProductAccountKey(productId, serviceId, day);
        productAccountDeltaMonthMap.computeIfAbsent(new MonthKey(yy, mm), k -> new HashMap()).compute(key, (k, v) -> {
            if (v == null) {
                return new AccountDelta(account);
            }
            v.delta = v.delta.add(account);
            return v;
        });
    }

    public CalculateResult calculate(boolean detailAccount, boolean addAccount, TvTariffContext tariffContext, TvTariffWorkerContext workerContext, boolean activation, boolean period, ContractRuntime contractRuntime, int contractId, ContractTariffOptionList contractTariffOptions, TvAccountRuntimeRoot tvAccountRuntime, int accountId, List<TvServiceCost> serviceCostList, TariffModuleTreeSet treeSet, Calendar tariffRequestTime, Date currentTime, BigDecimal balance, BigDecimal limit, boolean error, boolean recalculate, Date filterTimeFrom, Date filterTimeTo, ProductRejectCause reject) throws BGException {
        assert (accountId == 0 == (tvAccountRuntime == null));
        if (addAccount) {
            detailAccount = true;
        }
        List<TariffModuleTreeSet.Entry> treeList = this.getTreeList(treeSet, tariffRequestTime, currentTime, filterTimeTo);
        TvTariffRequest req = TvTarifficationManager.tarifficate(tariffContext, workerContext, this.moduleId, this.connectionSet, contractRuntime, contractRuntime.contractId, tvAccountRuntime, accountId, contractRuntime.getContractGroups(), treeList, balance, limit, contractTariffOptions, serviceCostList, tariffRequestTime);
        HashSet<Integer> prolongatedProductSpecId = new HashSet<Integer>();
        try {
            Collection<TvServiceCost> processServiceCostList;
            Calendar calendar;
            HashMap<MonthKey, Map<ProductAccountKey, AccountDelta>> productAccountDeltaMonthMap;
            HashMap<MonthKey, Map<ProductAccountKey, AccountDelta>> hashMap = productAccountDeltaMonthMap = detailAccount || addAccount ? new HashMap<MonthKey, Map<ProductAccountKey, AccountDelta>>(4) : null;
            if (addAccount && recalculate && filterTimeFrom != null) {
                calendar = TimeUtils.convertDateToCalendar((Date)filterTimeFrom);
                int yy = calendar.get(1);
                int mm = calendar.get(2) + 1;
                productAccountDeltaMonthMap.put(new MonthKey(yy, mm), new HashMap());
            }
            calendar = new GregorianCalendar();
            if (tariffContext.isProlongation()) {
                processServiceCostList = serviceCostList;
                assert (serviceCostList.size() == req.getServiceCostList().size());
                assert (serviceCostList.containsAll(req.getServiceCostList()));
            } else {
                processServiceCostList = req.getServiceCostList();
            }
            for (TvServiceCost serviceCost : processServiceCostList) {
                BigDecimal cost = serviceCost.cost;
                BigDecimal activationPrice = serviceCost.activationPrice;
                int prolongation = serviceCost.prolongation;
                serviceCost.prolongation = 0;
                if ((serviceCost.periodTimeFrom == null || serviceCost.periodTimeTo == null) && cost == null) {
                    if (!error) continue;
                    throw new BGException("\u0426\u0435\u043d\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!");
                }
                Date timeFrom = serviceCost.productItem != null && serviceCost.productItem.productPeriodActivationTime != null && !serviceCost.periodTimeFrom.after(serviceCost.productItem.productPeriodActivationTime) && !serviceCost.periodTimeTo.before(serviceCost.productItem.productPeriodActivationTime) ? serviceCost.productItem.productPeriodActivationTime : serviceCost.periodTimeFrom;
                if (filterTimeFrom != null && filterTimeFrom.after(timeFrom) || filterTimeTo != null && filterTimeTo.before(timeFrom)) continue;
                calendar.setTime(timeFrom);
                if (serviceCost.activationServiceId <= 0) {
                    serviceCost.activationServiceId = serviceCost.serviceId;
                }
                if (this.isReject(serviceCost, reject)) {
                    if (!error) continue;
                    throw new BGException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442.");
                }
                if (!activation && tariffContext.isProlongation() && (!this.checkDependent(contractRuntime, tvAccountRuntime, accountId, tariffRequestTime, prolongatedProductSpecId, serviceCost) || !this.checkIncompatible(contractRuntime, tvAccountRuntime, accountId, tariffRequestTime, prolongatedProductSpecId, serviceCost)) || !TvTarifficationManager.checkServiceAndCost(activation, period, error, serviceCost, cost, activationPrice)) continue;
                if (!period) {
                    cost = BigDecimal.ZERO;
                }
                if (activation) {
                    this.utilCalendar.setTime(serviceCost.activationTime);
                    AtomicReference<BigDecimal> balanceRef = new AtomicReference<BigDecimal>(balance);
                    if (!this.processActivation(addAccount, balanceRef, limit, error, calendar, serviceCost, activationPrice, productAccountDeltaMonthMap)) continue;
                    balance = balanceRef.get();
                }
                if (BigDecimal.ZERO.compareTo(cost = cost.setScale(5, this.balanceRoundingMode)) != 0) {
                    if (balance != null) {
                        BigDecimal newBalance = balance.subtract(cost);
                        if (!recalculate && this.lowBalance(newBalance, limit, serviceCost)) continue;
                        balance = newBalance;
                    }
                    if (productAccountDeltaMonthMap != null) {
                        TvTarifficationManager.addProductAccountDelta(productAccountDeltaMonthMap, serviceCost.productId, serviceCost.serviceId, calendar, cost);
                    }
                }
                serviceCost.prolongation = prolongation;
                if (prolongation == 0) continue;
                prolongatedProductSpecId.add(serviceCost.productSpecRuntime.productSpec.getId());
            }
            if (addAccount && productAccountDeltaMonthMap.size() > 0) {
                this.updateAccount(contractRuntime, contractId, accountId, recalculate, productAccountDeltaMonthMap);
            }
            req.setBalance(balance);
            return new CalculateResult(req, balance, productAccountDeltaMonthMap);
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private boolean lowBalance(BigDecimal newBalance, BigDecimal limit, TvServiceCost serviceCost) {
        if (serviceCost.ignoreBalance) {
            logger.info("lowBalance: => serviceCost.ignoreBalance");
            return false;
        }
        BigDecimal negBalance = newBalance.subtract(limit);
        logger.info("lowBalance: negBalance => " + negBalance + ", ignoreBalanceSumma=>" + serviceCost.ignoreBalanceSumma);
        if (negBalance.compareTo(serviceCost.ignoreBalanceSumma) < 0) {
            logger.info("lowBalance: =>negBalance.compareTo( serviceCost.ignoreBalanceSumma)<0 ");
            return true;
        }
        return false;
    }

    private boolean isReject(TvServiceCost serviceCost, ProductRejectCause reject) {
        boolean result = false;
        logger.info("ProductRejectCause for productId[" + serviceCost.productId + "]=>" + reject.toString());
        logger.info("serviseCost=>" + serviceCost.toString());
        if (reject.isRejectBySecondary()) {
            logger.info("ProductRejectCause: => reject.isRejectBySecondary()");
            return true;
        }
        if (reject.getContractStatus() >= 0 && !serviceCost.contractStatusSet.isEmpty()) {
            logger.info("ProductRejectCause: => reject.getContractStatus()>=0&&!serviceCost.contractStatusSet.isEmpty()");
            if (!serviceCost.contractStatusSet.contains(reject.getContractStatus())) {
                logger.info("ProductRejectCause: => !serviceCost.contractStatusSet.contains( reject.getContractStatus()");
                result = true;
            }
        } else if (reject.isRejectByContractStatus()) {
            logger.info("ProductRejectCause: => reject.isRejectByContractStatus()");
            result = true;
        }
        if (reject.getDeviceState() != -2000 && !serviceCost.deviceStateSet.isEmpty()) {
            logger.info("ProductRejectCause: => reject.getDeviceState()!=-2000&&!serviceCost.deviceStateSet.isEmpty()");
            if (!serviceCost.deviceStateSet.contains(reject.getDeviceState())) {
                logger.info("ProductRejectCause: => !serviceCost.deviceStateSet.contains( reject.getDeviceState())");
                result = true;
            }
        } else if (reject.isRejectByDeviceState()) {
            logger.info("ProductRejectCause: => reject.isRejectByDeviceState()");
            result = true;
        }
        logger.info("ProductRejectCause:result =>" + result);
        return result;
    }

    private boolean checkDependent(ContractRuntime contractRuntime, TvAccountRuntimeRoot tvAccountRuntime, int accountId, Calendar tariffRequestTime, Set<Integer> prolongatedProductSpecId, TvServiceCost serviceCost) throws BGException {
        ProductPeriodRuntimeList productPeriodRuntimeList;
        Set depends = serviceCost.productSpecRuntime.getProductSpec().getDepends();
        if (depends == null || depends.size() == 0) {
            return true;
        }
        if (!Collections.disjoint(prolongatedProductSpecId, depends)) {
            return true;
        }
        ProductPeriodRuntimeList productPeriodRuntimeList2 = productPeriodRuntimeList = accountId == 0 ? null : tvAccountRuntime.getProductPeriodRuntimeList();
        if (productPeriodRuntimeList != null && productPeriodRuntimeList.containsActiveProductSpecIds(serviceCost.periodTimeFrom.getTime(), depends)) {
            return true;
        }
        ProductPeriodRuntimeList contractProductPeriodRuntimeList = contractRuntime.getContractProductPeriods(tariffRequestTime.getTimeInMillis());
        if (contractProductPeriodRuntimeList.containsActiveProductSpecIds(serviceCost.periodTimeFrom.getTime(), depends)) {
            return true;
        }
        logger.info("Reject prolongation (to dependent product) " + serviceCost.productId);
        return false;
    }

    private boolean checkIncompatible(ContractRuntime contractRuntime, TvAccountRuntimeRoot tvAccountRuntime, int accountId, Calendar tariffRequestTime, Set<Integer> prolongatedProductSpecId, TvServiceCost serviceCost) throws BGException {
        ProductPeriodRuntimeList productPeriodRuntimeList;
        Set incompatible = serviceCost.productSpecRuntime.getProductSpec().getIncompatible();
        if (incompatible == null || incompatible.size() == 0) {
            return true;
        }
        if (!Collections.disjoint(prolongatedProductSpecId, incompatible)) {
            logger.info("Reject prolongation (have incompatible product) " + serviceCost.productId);
            return false;
        }
        ProductPeriodRuntimeList productPeriodRuntimeList2 = productPeriodRuntimeList = accountId == 0 ? null : tvAccountRuntime.getProductPeriodRuntimeList();
        if (productPeriodRuntimeList != null && productPeriodRuntimeList.containsActiveProductSpecIds(serviceCost.periodTimeFrom.getTime(), incompatible)) {
            logger.info("Reject prolongation (have incompatible product) " + serviceCost.productId);
            return false;
        }
        ProductPeriodRuntimeList contractProductPeriodRuntimeList = contractRuntime.getContractProductPeriods(tariffRequestTime.getTimeInMillis());
        if (contractProductPeriodRuntimeList.containsActiveProductSpecIds(serviceCost.periodTimeFrom.getTime(), incompatible)) {
            logger.info("Reject prolongation (have incompatible product) " + serviceCost.productId);
            return false;
        }
        return true;
    }

    private List<TariffModuleTreeSet.Entry> getTreeList(TariffModuleTreeSet treeSet, Calendar tariffRequestTime, Date currentTime, Date filterTimeTo) {
        List treeList = treeSet.getEntryList(tariffRequestTime.getTimeInMillis());
        if (treeList.size() == 0) {
            if (currentTime != null) {
                treeList = treeSet.getEntryList(currentTime.getTime());
            } else {
                if (filterTimeTo != null) {
                    treeList = treeSet.getEntryList(filterTimeTo.getTime());
                }
                if (treeList.size() == 0) {
                    Calendar calendar = (Calendar)tariffRequestTime.clone();
                    TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
                    calendar.set(5, 1);
                    calendar.add(2, 1);
                    calendar.add(5, -1);
                    treeList = treeSet.getEntryList(calendar.getTime().getTime());
                }
            }
        }
        return treeList;
    }

    private void updateAccount(ContractRuntime contractRuntime, int contractId, int accountId, boolean recalculate, Map<MonthKey, Map<ProductAccountKey, AccountDelta>> productAccountDeltaMonthMap) throws SQLException, BGException {
        BalanceDao balanceDao = this.getBalanceDao();
        HashMap<Integer, AccountDelta> accountDeltaMap = new HashMap<Integer, AccountDelta>();
        for (Map.Entry<MonthKey, Map<ProductAccountKey, AccountDelta>> ee : productAccountDeltaMonthMap.entrySet()) {
            MonthKey monthKey = ee.getKey();
            int yy = monthKey.yy;
            int mm = monthKey.mm;
            Map<ProductAccountKey, AccountDelta> productAccountDeltaMap = ee.getValue();
            accountDeltaMap.clear();
            for (Map.Entry<ProductAccountKey, AccountDelta> e : productAccountDeltaMap.entrySet()) {
                ProductAccountKey key = e.getKey();
                AccountDelta accountDelta = e.getValue();
                this.init(yy, mm, key.day);
                this.insertDetailPS.setInt(1, contractRuntime.contractId);
                this.insertDetailPS.setInt(2, accountId);
                this.insertDetailPS.setInt(3, key.productId);
                this.insertDetailPS.setInt(4, key.serviceId);
                this.insertDetailPS.setInt(5, key.day);
                this.insertDetailPS.setBigDecimal(6, accountDelta.delta);
                this.insertDetailPS.setBigDecimal(7, accountDelta.delta);
                this.insertDetailPS.executeUpdate();
                TvTarifficationManager.addAccountDelta(accountDeltaMap, key.serviceId, accountDelta.delta);
            }
            boolean nonZero = false;
            BigDecimal accountSum = BigDecimal.ZERO;
            for (Map.Entry entry : accountDeltaMap.entrySet()) {
                AccountDelta accountDelta = (AccountDelta)entry.getValue();
                if (BigDecimal.ZERO.compareTo(accountDelta.delta) == 0) continue;
                accountSum = accountSum.add(accountDelta.delta);
                nonZero = true;
                balanceDao.addContractAccount(contractId, yy, mm, ((Integer)entry.getKey()).intValue(), accountDelta.delta);
            }
            BigDecimal accountSumRound = nonZero ? accountSum.setScale(2, RoundingMode.HALF_EVEN) : accountSum;
            if (recalculate || accountSumRound != accountSum && accountSumRound.compareTo(accountSum) != 0) {
                BigDecimal bigDecimal = balanceDao.setBalanceAccount(contractId, contractRuntime.getSuperContractId(), yy, mm);
                if (this.balanceEP != null) {
                    this.balanceEP.publish((Event)new ContractBalanceChangedEvent(contractId, 2, yy, mm, bigDecimal));
                    continue;
                }
                EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contractId, 2, yy, mm, bigDecimal));
                continue;
            }
            if (!nonZero) continue;
            balanceDao.addBalanceAccount(contractId, contractRuntime.getSuperContractId(), yy, mm, accountSumRound);
            if (this.balanceEP != null) {
                this.balanceEP.publish((Event)new ContractBalanceChangedEvent(contractId, 1, yy, mm, accountSum));
                continue;
            }
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(contractId, 1, yy, mm, accountSum));
        }
    }

    private boolean processActivation(boolean addAccount, AtomicReference<BigDecimal> balanceRef, BigDecimal limit, boolean error, Calendar date, TvServiceCost serviceCost, BigDecimal activationPrice, Map<MonthKey, Map<ProductAccountKey, AccountDelta>> productAccountDeltaMonthMap) throws BGException {
        if (!(activationPrice == null || serviceCost.serviceId <= 0 && serviceCost.activationServiceId <= 0 || BigDecimal.ZERO.compareTo(activationPrice) == 0 || serviceCost.productItem != null && serviceCost.productItem.activationTime.compareTo(serviceCost.productItem.productPeriodActivationTime) != 0)) {
            activationPrice = activationPrice.setScale(5, this.balanceRoundingMode);
            BigDecimal balance = balanceRef.get();
            if (balance != null) {
                BigDecimal newBalance = balance.subtract(activationPrice);
                if (newBalance.compareTo(limit) < 0) {
                    if (error) {
                        throw new BGException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
                    }
                    return false;
                }
                balance = newBalance;
                balanceRef.set(balance);
            }
            if (productAccountDeltaMonthMap != null) {
                TvTarifficationManager.addProductAccountDelta(productAccountDeltaMonthMap, serviceCost.productId, serviceCost.activationServiceId, date, activationPrice);
            }
        }
        return true;
    }

    private static boolean checkServiceAndCost(boolean activation, boolean period, boolean error, TvServiceCost serviceCost, BigDecimal cost, BigDecimal activationPrice) throws BGException {
        if (cost == null) {
            if (error) {
                throw new BGException("\u0426\u0435\u043d\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!");
            }
            if (!activation && period) {
                try {
                    logger.error("Cost not found for productId:" + serviceCost.productId + ", productSpecId:" + serviceCost.productItem.productSpecId + ", activationModeId:" + serviceCost.productItem.activationModeId);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            return false;
        }
        if (serviceCost.serviceId <= 0 || serviceCost.serviceId <= 0 && serviceCost.activationServiceId <= 0 && activationPrice != null && BigDecimal.ZERO.compareTo(activationPrice) != 0) {
            if (error) {
                throw new BGException("\u0423\u0441\u043b\u0443\u0433\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!");
            }
            if (!activation && period) {
                try {
                    logger.error("Service not found for productId:" + serviceCost.productId + ", productSpecId:" + serviceCost.productItem.productSpecId + ", activationModeId:" + serviceCost.productItem.activationModeId);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            return false;
        }
        return true;
    }

    public static class AccountDelta {
        public BigDecimal delta;

        AccountDelta(BigDecimal delta) {
            this.delta = delta;
        }
    }

    public static class ProductAccountKey {
        public final int productId;
        public final int serviceId;
        public final int day;

        public ProductAccountKey(int productId, int serviceId, int day) {
            this.productId = productId;
            this.serviceId = serviceId;
            this.day = day;
        }

        public int hashCode() {
            return 31 * (31 * (31 + this.productId) + this.serviceId) + this.day;
        }

        public boolean equals(Object obj) {
            ProductAccountKey other = (ProductAccountKey)obj;
            return this.productId == other.productId && this.serviceId == other.serviceId && this.day == other.day;
        }
    }

    public static class MonthKey {
        public final int yy;
        public final int mm;

        public MonthKey(int yy, int mm) {
            this.yy = yy;
            this.mm = mm;
        }

        public int hashCode() {
            return 31 * (31 + this.mm) + this.yy;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            MonthKey other = (MonthKey)obj;
            return this.mm == other.mm && this.yy == other.yy;
        }
    }

    public static final class CalculateResult {
        private final TvTariffRequest req;
        private final BigDecimal balance;
        private final Map<MonthKey, Map<ProductAccountKey, AccountDelta>> productAccountDeltaMonthMap;

        public CalculateResult(TvTariffRequest req, BigDecimal balance, Map<MonthKey, Map<ProductAccountKey, AccountDelta>> productAccountDeltaMonthMap) {
            this.req = req;
            this.balance = balance;
            this.productAccountDeltaMonthMap = productAccountDeltaMonthMap;
        }

        public TvTariffRequest getReq() {
            return this.req;
        }

        public BigDecimal getBalance() {
            return this.balance;
        }

        public Map<MonthKey, Map<ProductAccountKey, AccountDelta>> getProductAccountDeltaMonthMap() {
            return this.productAccountDeltaMonthMap;
        }
    }

    private static class TarifficationData {
        TvServiceCost serviceCost;
        Date time;
        BigDecimal account;

        private TarifficationData() {
        }
    }
}

