/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.math.BigDecimal;
import java.util.Set;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvServiceCost;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class ActivationModeTariffTreeNode
extends DefaultTariffTreeNode<TvTariffRequest, TariffContext> {
    private final Set<Integer> activationModeIds;
    private final int serviceId;
    private final BigDecimal cost;

    public ActivationModeTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        Set activationModeIds = Utils.toIntegerSet((String)parameterMap.get("activationModeIds", null));
        this.activationModeIds = activationModeIds.size() == 0 || activationModeIds.contains(0) ? null : activationModeIds;
        this.serviceId = parameterMap.getInt("serviceId", 0);
        BigDecimal cost = Utils.parseBigDecimal((String)parameterMap.get("cost", null), (BigDecimal)BigDecimal.ZERO);
        this.cost = cost == null ? null : (BigDecimal.ZERO.compareTo(cost) == 0 ? BigDecimal.ZERO : cost);
    }

    public int executeImpl(Long treeNodeId, TvTariffRequest req, TariffContext context) {
        if (this.activationModeIds == null || this.activationModeIds.contains(((TvServiceCost)req.serviceCost).activationModeId)) {
            if (((TvServiceCost)req.serviceCost).activationPriceExternal) {
                if (this.serviceId > 0) {
                    ((TvServiceCost)req.serviceCost).activationServiceId = this.serviceId;
                }
            } else {
                ((TvServiceCost)req.serviceCost).activationPrice = this.cost;
                if (this.serviceId > 0 && this.cost != null) {
                    ((TvServiceCost)req.serviceCost).activationServiceId = this.serviceId;
                }
            }
            return 1;
        }
        return 0;
    }
}

