/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.math.BigDecimal;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntime;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvAccountRuntimeMap;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvServiceCost;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class ChildAccountAddCostTariffTreeNode
extends TariffTreeNode<TvTariffRequest, TvTariffContext, TreeContext, TvTariffWorkerContext> {
    private final Set<Integer> tvAccountSpecIds;
    private final BigDecimal augend;

    public ChildAccountAddCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.tvAccountSpecIds = Utils.toIntegerSet((String)parameterMap.get("tvAccountSpecIds", ""));
        this.augend = parameterMap.getBigDecimal("augend", BigDecimal.ZERO);
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, TvTariffRequest req, TvTariffContext ctx, TreeContext treeContext, TvTariffWorkerContext workerContext) {
        if (this.tvAccountSpecIds.size() == 0) {
            return 0;
        }
        TvAccountRuntimeMap tvAccountRuntimeMap = ctx.getTvAccountRuntimeMap();
        try {
            List<TvAccountRuntime> children;
            tvAccountRuntimeMap.load(workerContext.getConnectionSet(), req.contractId);
            if (req.getTvAccountId() == 0) {
                children = tvAccountRuntimeMap.list(req.contractId, req.getTime().getTimeInMillis());
                if (children == null || children.size() == 0) {
                    return 0;
                }
            } else {
                children = tvAccountRuntimeMap.listChildren(req.getTvAccountId(), req.getTime().getTimeInMillis());
                TvAccountRuntime account = tvAccountRuntimeMap.get(req.getTvAccountId());
                if (this.tvAccountSpecIds.contains(account.getTvAccount().getSpecId())) {
                    if (req.serviceCost != null && ((TvServiceCost)req.serviceCost).cost != null) {
                        ((TvServiceCost)req.serviceCost).cost = ((TvServiceCost)req.serviceCost).cost.add(this.augend, ctx.mc);
                    }
                    if (children == null || children.size() == 0) {
                        return 1;
                    }
                } else if (children == null || children.size() == 0) {
                    return 0;
                }
            }
            for (TvAccountRuntime child : children) {
                if (!this.tvAccountSpecIds.contains(child.getTvAccount().getSpecId()) || req.serviceCost == null || ((TvServiceCost)req.serviceCost).cost == null) continue;
                ((TvServiceCost)req.serviceCost).cost = ((TvServiceCost)req.serviceCost).cost.add(this.augend, ctx.mc);
            }
        }
        catch (BGException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return 1;
    }
}

