/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.tariff;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvServiceCost;
import ru.bitel.bgbilling.modules.tv.server.tariff.TvTariffRequest;
import ru.bitel.common.ParameterMap;

public class NegativeBalanceTariffTreeNode
extends DefaultTariffTreeNode<TvTariffRequest, TariffContext> {
    private final BigDecimal multiplicand;
    private final boolean modeMult;

    public NegativeBalanceTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.multiplicand = parameterMap.getBigDecimal("value", BigDecimal.ONE);
        this.modeMult = parameterMap.getBoolean("mode", false);
    }

    public int executeImpl(Long treeNodeId, TvTariffRequest req, TariffContext ctx) {
        int result;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("NegativeBalanceTariffTreeNode:value=>" + this.multiplicand + ";mode=>" + this.modeMult);
        }
        if (req.serviceCost != null) {
            if (((TvServiceCost)req.serviceCost).cost != null) {
                ((TvServiceCost)req.serviceCost).ignoreBalanceSumma = this.calcSumma(((TvServiceCost)req.serviceCost).cost);
                result = 1;
            } else {
                result = 0;
            }
            this.log((TvServiceCost)req.serviceCost);
        } else {
            result = 0;
            for (Map.Entry e : req.getServiceCost().entrySet()) {
                List serviceCostList = (List)e.getValue();
                if (serviceCostList == null) continue;
                int jsize = serviceCostList.size();
                for (int j = 0; j < jsize; ++j) {
                    TvServiceCost serviceCost = (TvServiceCost)((Object)serviceCostList.get(j));
                    if (serviceCost.cost != null) {
                        result = 1;
                        if (BigDecimal.ZERO.compareTo(serviceCost.cost) != 0) {
                            serviceCost.ignoreBalanceSumma = this.calcSumma(serviceCost.cost);
                        }
                    }
                    this.log(serviceCost);
                }
            }
        }
        return result;
    }

    private BigDecimal calcSumma(BigDecimal cost) {
        BigDecimal result = this.multiplicand;
        if (this.modeMult) {
            result = cost.multiply(this.multiplicand);
        }
        return result;
    }

    private void log(TvServiceCost serviceCost) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("NegativeBalanceTariffTreeNode:productId=>" + serviceCost.productId + ";cost=>" + serviceCost.cost + ";ignoreBalanceSumma=>" + serviceCost.ignoreBalanceSumma);
        }
    }
}

