/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.contract;

import bitel.billing.module.contract.EntityTariffsPropertiesPanel;
import bitel.billing.module.services.ServicePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JTabbedPane;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.modules.voice.client.contract.AbonTab;
import ru.bitel.bgbilling.modules.voice.client.contract.VoiceAccountEditorForm;
import ru.bitel.bgbilling.modules.voice.client.contract.VoiceAccountPanel;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.oss.kernel.entity.client.EntityAttributesForm;

public class VoiceAccountEditor
extends BGUPanel {
    private JTabbedPane tabs = new JTabbedPane();
    private final VoiceAccountPanel parentPanel;
    private VoiceAccountEditorForm editorForm;
    private EntityAttributesForm entityAttributesForm;
    private AtomicReference<VoiceAccount> currentTypeRef = new AtomicReference();
    private ServicePanel tariffPanel;
    private List<AbonTab> abonPanels = new ArrayList<AbonTab>();
    private VoiceAccountService voiceAccountService = null;
    AbstractBGUPanel.DefaultAction editAccountAction = new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            VoiceAccount account = (VoiceAccount)VoiceAccountEditor.this.parentPanel.getAccountTableModel().getSelectedRow();
            if (account == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            account = VoiceAccountEditor.this.voiceAccountService.voiceAccountGet(account.getId());
            VoiceAccountEditor.this.editorForm.editAccount(account);
            VoiceAccountEditor.this.currentTypeRef.set(account);
            VoiceAccountEditor.this.entityAttributesForm.reset();
            VoiceAccountEditor.this.setTariffData(account.getId());
            VoiceAccountEditor.this.setAbonData(account.getId());
            VoiceAccountEditor.this.tabs.setSelectedIndex(0);
            VoiceAccountEditor.this.performActionOpen();
        }
    };
    AbstractBGUPanel.DefaultAction newAccountAction = new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439 \u0430\u043a\u043a\u0430\u0443\u043d\u0442"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            VoiceAccount voiceAccount = new VoiceAccount();
            VoiceAccountEditor.this.editorForm.newAccount(voiceAccount);
            VoiceAccountEditor.this.setTariffData(-1);
            VoiceAccountEditor.this.setAbonData(0);
            VoiceAccountEditor.this.currentTypeRef.set(voiceAccount);
            VoiceAccountEditor.this.entityAttributesForm.reset();
            VoiceAccountEditor.this.tabs.setSelectedIndex(0);
            VoiceAccountEditor.this.performActionOpen();
        }
    };
    AbstractBGUPanel.DefaultAction okAction = new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            if (VoiceAccountEditor.this.editorForm.checkAccount()) {
                VoiceAccountEditor.this.entityAttributesForm.performAction("ok");
                VoiceAccountEditor.this.editorForm.saveAccount();
                if (VoiceAccountEditor.this.tariffPanel.updateData() && VoiceAccountEditor.this.updateAbonPanels()) {
                    VoiceAccountEditor.this.performActionClose();
                    VoiceAccountEditor.this.parentPanel.performAction("refresh");
                }
            }
        }
    };

    public VoiceAccountEditor(VoiceAccountPanel parentPanel, VoiceAccountService voiceAccountService) {
        this.parentPanel = parentPanel;
        this.voiceAccountService = voiceAccountService;
    }

    protected void jbInit() throws Exception {
        this.entityAttributesForm = new EntityAttributesForm(this.currentTypeRef, (ClientContext)this.getContext());
        this.editorForm = new VoiceAccountEditorForm();
        this.editorForm.addPropertyChangeListener(e -> {
            if ("changeAccountType".equals(e.getPropertyName())) {
                this.entityAttributesForm.refresh();
            }
        });
        this.tariffPanel = new EntityTariffsPropertiesPanel();
        this.tabs.add("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440", (Component)((Object)this.editorForm));
        this.tabs.add("\u0422\u0430\u0440\u0438\u0444\u044b", (Component)this.tariffPanel);
        this.tabs.add("\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u044b", (Component)this.entityAttributesForm);
        this.addAbonPanels();
        this.setLayout(new BorderLayout());
        this.add(this.tabs);
    }

    private void addAbonPanels() throws BGException {
        ServicePanel panel = null;
        ModuleService service = (ModuleService)((ClientContext)this.getContext()).getPort(ModuleService.class, 0);
        String extensionPointName = "abon.entity.editor";
        for (BGModule module : service.moduleList()) {
            Element editor;
            Map extensionMap = module.getInstalledModule().getClientExtensionMap();
            if (extensionMap == null || !extensionMap.containsKey(extensionPointName) || (editor = XMLUtils.selectElement((Node)((Node)extensionMap.get(extensionPointName)), (String)"//control")) == null) continue;
            String className = editor.getAttribute("class");
            try {
                panel = (ServicePanel)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
                panel.setContractId(((ClientContext)this.getContext()).getContractId());
                this.tabs.add(module.getTitle(), (Component)panel);
                this.abonPanels.add(new AbonTab(panel, module.getId()));
            }
            catch (Exception e) {
                throw new BGException("\u041a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 " + className + " \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u043e\u0437\u0434\u0430\u043d", (Throwable)e);
            }
        }
    }

    private void setTariffData(int accountId) {
        this.tariffPanel.init(null, ((ClientContext)this.getContext()).getModuleId());
        this.tariffPanel.setId(String.valueOf(accountId));
        this.tariffPanel.setContractId(((ClientContext)this.getContext()).getContractId());
        this.tariffPanel.setData();
    }

    private void setAbonData(int accountId) {
        for (AbonTab tab : this.abonPanels) {
            ServicePanel panel = tab.panel;
            HashMap<String, Integer> params = new HashMap<String, Integer>(8);
            params.put("npayMid", tab.moduleId);
            panel.setParams(params);
            panel.setContext((ClientContext)this.getContext());
            panel.init("npay", ((ClientContext)this.getContext()).getModuleId());
            panel.setId(String.valueOf(accountId));
            panel.setContractId(((ClientContext)this.getContext()).getContractId());
            panel.setData();
        }
    }

    private boolean updateAbonPanels() {
        boolean result = true;
        for (AbonTab tab : this.abonPanels) {
            tab.panel.setId(String.valueOf(this.currentTypeRef.get().getId()));
            tab.panel.setAttr("accountDateTo", (Object)this.currentTypeRef.get().getDateTo());
            if (result &= tab.panel.updateData()) continue;
            break;
        }
        return result;
    }
}

