/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory.geocode;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.ErrorDialog;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.modules.voice.client.directory.geocode.VoiceGeographicCodePanel;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceGeographicCodeService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGSwingUtilites;

class VoiceGeographicCodeImportPanel
extends BGUPanel {
    private final VoiceGeographicCodePanel parentPanel;
    private static final String ACTION_LOAD_FROM_FILE = "loadFromFile";
    private static final String ACTION_IMPORT = "import";
    private static final String ADD_NEW_CHECKBOX_KEY = "addNewCheckbox";
    private static final String UPDATE_EXIST_CHECKBOX_KEY = "updateExistCheckbox";
    private BGButton chooseFileButton;
    private BGTextField fileNameTextField;
    private JCheckBox addNewCheckBox;
    private JCheckBox updateExistCheckBox;
    private JTextArea importContentTextArea;
    private BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{new BGButtonPanel.ButtonItem("\u0418\u043c\u043f\u043e\u0440\u0442", "import"), BGButtonPanel.CANCEL});
    private VoiceGeographicCodeService codeService;

    public VoiceGeographicCodeImportPanel(VoiceGeographicCodePanel voiceGeographicCodePanel) {
        super((LayoutManager)new GridBagLayout());
        this.parentPanel = voiceGeographicCodePanel;
    }

    protected void jbInit() throws Exception {
        this.codeService = (VoiceGeographicCodeService)((ClientContext)this.getContext()).getPort(VoiceGeographicCodeService.class);
        this.fileNameTextField = new BGTextField();
        this.chooseFileButton = new BGButton("...");
        this.importContentTextArea = new JTextArea();
        this.addNewCheckBox = new JCheckBox("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0435");
        boolean isSelected = ClientSetup.getInstance().getBoolean(((Object)((Object)this.parentPanel)).getClass().getCanonicalName() + ADD_NEW_CHECKBOX_KEY, true);
        this.addNewCheckBox.setSelected(isSelected);
        this.updateExistCheckBox = new JCheckBox("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435");
        isSelected = ClientSetup.getInstance().getBoolean(((Object)((Object)this.parentPanel)).getClass().getCanonicalName() + UPDATE_EXIST_CHECKBOX_KEY, true);
        this.updateExistCheckBox.setSelected(isSelected);
        this.fileNameTextField.setPromptText("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043a\u043d\u043e\u043f\u043a\u0438 '...' \u0441\u043f\u0440\u0430\u0432\u0430. \u0415\u0433\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u043e\u0442\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u0441\u044f \u0432 \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438.");
        this.buttonPanel.getButton(ACTION_IMPORT).setEnabled(false);
        JScrollPane scrollPane = new JScrollPane(this.importContentTextArea);
        scrollPane.setMinimumSize(new Dimension(100, 300));
        scrollPane.setPreferredSize(new Dimension(100, 300));
        this.add(new JLabel("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b, \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0433\u0435\u043e\u043a\u043e\u0434\u043e\u0432"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)this.fileNameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 3, 3), 0, 0));
        this.add((Component)this.chooseFileButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 3), 0, 0));
        this.add(this.addNewCheckBox, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
        this.add(this.updateExistCheckBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 3), 0, 0));
        this.add(BGSwingUtilites.wrapBorder((JComponent)scrollPane, (String)"\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u043c\u043e\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 (\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f)"), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(2, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
        this.buttonPanel.addActionListener(l -> this.performAction(l.getActionCommand()));
        this.chooseFileButton.addActionListener(l -> this.performAction(ACTION_LOAD_FROM_FILE));
        this.importContentTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processContent(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processContent(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processContent(e);
            }

            private void processContent(DocumentEvent e) {
                VoiceGeographicCodeImportPanel.this.buttonPanel.getButton(VoiceGeographicCodeImportPanel.ACTION_IMPORT).setEnabled(e.getDocument().getLength() > 0);
            }
        });
        this.addNewCheckBox.addItemListener(e -> {
            String key = ((Object)((Object)this.parentPanel)).getClass().getCanonicalName() + ADD_NEW_CHECKBOX_KEY;
            ClientSetup.getInstance().getUserConfig().set(key, String.valueOf(this.addNewCheckBox.isSelected()));
            ClientSetup.getInstance().saveUserConfig();
        });
        this.updateExistCheckBox.addItemListener(e -> {
            String key = ((Object)((Object)this.parentPanel)).getClass().getCanonicalName() + UPDATE_EXIST_CHECKBOX_KEY;
            ClientSetup.getInstance().getUserConfig().set(key, String.valueOf(this.updateExistCheckBox.isSelected()));
            ClientSetup.getInstance().saveUserConfig();
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction(ACTION_IMPORT, "\u0418\u043c\u043f\u043e\u0440\u0442"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                final String importContent = VoiceGeographicCodeImportPanel.this.importContentTextArea.getText();
                if (Utils.isBlankString((String)importContent)) {
                    BGToolTip.showErrorMessage((JComponent)VoiceGeographicCodeImportPanel.this.importContentTextArea, (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0444\u0430\u0439\u043b \u0441 \u0433\u0435\u043e\u043a\u043e\u0434\u0430\u043c\u0438 \u0438\u043b\u0438 \u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0438\u0445 \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430!");
                    return;
                }
                Holder content = new Holder();
                content.value = new DataHandler(new DataSource(){

                    public OutputStream getOutputStream() throws IOException {
                        return null;
                    }

                    public String getName() {
                        return null;
                    }

                    public InputStream getInputStream() throws IOException {
                        return new ByteArrayInputStream(importContent.getBytes("UTF-8"));
                    }

                    public String getContentType() {
                        return "application/octet-stream";
                    }
                });
                String importErrors = VoiceGeographicCodeImportPanel.this.codeService.importGeographicCode(VoiceGeographicCodeImportPanel.this.parentPanel.getOperatorId(), VoiceGeographicCodeImportPanel.this.addNewCheckBox.isSelected(), VoiceGeographicCodeImportPanel.this.updateExistCheckBox.isSelected(), content);
                if (Utils.notBlankString((String)importErrors)) {
                    ErrorDialog d = new ErrorDialog(importErrors, "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u041d\u0435 \u0432\u0441\u0435 \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u043a\u043e\u0434\u044b \u0431\u044b\u043b\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u044b!", false, true);
                    d.showDialog();
                }
                VoiceGeographicCodeImportPanel.this.parentPanel.performAction("refresh");
                VoiceGeographicCodeImportPanel.this.parentPanel.setVisibleBottomPanels(null, false, false);
            }
        };
        new AbstractBGUPanel.DefaultAction(ACTION_LOAD_FROM_FILE, "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0438\u0437 \u0444\u0430\u0439\u043b\u0430"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                BGFileChooser fileChooser = new BGFileChooser((Component)((Object)VoiceGeographicCodeImportPanel.this));
                fileChooser.setMultiSelectionEnabled(false);
                if (fileChooser.showOpenDialog() == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    try (FileInputStream fis = new FileInputStream(selectedFile);){
                        byte[] fileContent = Utils.readByBlock((InputStream)fis);
                        VoiceGeographicCodeImportPanel.this.importContentTextArea.setText(new String(fileContent, "UTF-8"));
                        VoiceGeographicCodeImportPanel.this.fileNameTextField.setText(selectedFile.getAbsolutePath());
                    }
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("cancel", "\u041e\u0442\u043c\u0435\u043d\u0430"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceGeographicCodeImportPanel.this.parentPanel.setVisibleBottomPanels(null, false, false);
            }
        };
    }

    public void performActionOpen() {
        this.importContentTextArea.setText("");
        this.fileNameTextField.setText("");
    }
}

