/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime;

import java.util.Arrays;
import ru.bitel.common.Utils;

public class BCDecimal {
    private byte[] value;

    public BCDecimal() {
    }

    public BCDecimal(byte[] value) {
        this.value = value;
    }

    public BCDecimal(String s) {
        this.value = BCDecimal.toBCDecimal(s);
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        BCDecimal other = (BCDecimal)obj;
        return Arrays.equals(this.value, other.value);
    }

    public static String toString(byte[] bytes) {
        int i;
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        int size = bytes.length - 1;
        for (i = 0; i < size; ++i) {
            sb.append(Utils.HEX[(bytes[i] & 0xF0) >> 4]);
            sb.append(Utils.HEX[bytes[i] & 0xF]);
        }
        sb.append(Utils.HEX[(bytes[i] & 0xF0) >> 4]);
        int last = bytes[i] & 0xF;
        if (last != 15) {
            sb.append(last);
        }
        return sb.toString();
    }

    public static byte[] toBCDecimal(String s) {
        byte[] result;
        if (Utils.isBlankString((String)s)) {
            return null;
        }
        int size = s.length();
        int i = 0;
        int j = 0;
        if (size % 2 == 0) {
            result = new byte[size / 2];
        } else {
            result = new byte[size / 2 + 1];
            result[result.length - 1] = (byte)(Character.digit(s.charAt(--size), 10) << 4 | 0xF);
        }
        while (i < size) {
            int digit1 = Character.digit(s.charAt(i++), 10);
            int digit2 = Character.digit(s.charAt(i++), 10);
            result[j++] = (byte)(digit1 * 16 + digit2);
        }
        return result;
    }

    public static boolean equals(byte[] a, byte[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = length - 1; i >= 0; --i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println(BCDecimal.toString(BCDecimal.toBCDecimal("123456")));
        System.out.println(BCDecimal.toString(BCDecimal.toBCDecimal("12345")));
        System.out.println(BCDecimal.startsWithCompare(BCDecimal.toBCDecimal("12345"), BCDecimal.toBCDecimal("12345")));
        System.out.println(BCDecimal.startsWithCompare(BCDecimal.toBCDecimal("123456"), BCDecimal.toBCDecimal("12345")));
        System.out.println(BCDecimal.startsWithCompare(BCDecimal.toBCDecimal("1234567"), BCDecimal.toBCDecimal("123456")));
        System.out.println(BCDecimal.startsWithCompare(BCDecimal.toBCDecimal("1234567"), BCDecimal.toBCDecimal("12345")));
        System.out.println(BCDecimal.startsWithCompare(BCDecimal.toBCDecimal("12345"), BCDecimal.toBCDecimal("123456")));
        System.out.println(BCDecimal.startsWithCompare(BCDecimal.toBCDecimal("123456"), BCDecimal.toBCDecimal("1234567")));
        System.out.println(BCDecimal.startsWithCompare(BCDecimal.toBCDecimal("12346"), BCDecimal.toBCDecimal("1234567")));
        System.out.println(BCDecimal.startsWithCompare(BCDecimal.toBCDecimal("123456"), BCDecimal.toBCDecimal("12245")));
        System.out.println(BCDecimal.startsWithCompare(BCDecimal.toBCDecimal("123456"), BCDecimal.toBCDecimal("22345")));
    }

    public static final boolean isPadded(byte[] bcd) {
        return bcd.length > 0 && (bcd[bcd.length - 1] & 0xF) == 15;
    }

    public static final int compare(byte[] v1, byte[] v2) {
        int len1 = v1.length;
        int len2 = v2.length;
        int n = Math.min(len1, len2);
        int lim = n;
        for (int k = 0; k < lim; ++k) {
            byte c1 = v1[k];
            byte c2 = v2[k];
            if (c1 == c2) continue;
            return (short)(c1 & 0xFF) - (short)(c2 & 0xFF);
        }
        return len1 - len2;
    }

    public static final int compare(byte[] v1, int v1Offset, byte[] v2, int v2Offset, int length) {
        short c1;
        short last;
        int len2;
        int len1 = Math.min(v1.length - v1Offset, length);
        int n = Math.min(len1, len2 = Math.min(v2.length - v2Offset, length));
        if (n == 0) {
            return 0;
        }
        while (n-- != 1) {
            byte c2;
            byte c12;
            if ((c12 = v1[v1Offset++]) == (c2 = v2[v2Offset++])) continue;
            return (short)(c12 & 0xFF) - (short)(c2 & 0xFF);
        }
        if (v2Offset == v2.length - 1) {
            last = v2[v2Offset];
            if ((last & 0xF) == 15) {
                c1 = (short)(v1[v1Offset] & 0xF0);
                short c2 = (short)(last & 0xF0);
                if (c1 != c2) {
                    return c1 - c2;
                }
            } else {
                if (v1Offset == v1.length - 1 && (v1[v1Offset] & 0xF) == 15) {
                    return -1;
                }
                c1 = v1[v1Offset];
                short c2 = last;
                if (c1 != c2) {
                    return (short)(c1 & 0xFF) - (short)(c2 & 0xFF);
                }
            }
        } else if (v1Offset == v1.length - 1) {
            last = v1[v1Offset];
            if ((last & 0xF) == 15) {
                c1 = (short)(last & 0xF0);
                short c2 = (short)(v2[v2Offset] & 0xF0);
                if (c1 != c2) {
                    return c1 - c2;
                }
            } else {
                c1 = last;
                byte c2 = v2[v2Offset];
                if (c1 != c2) {
                    return (short)(c1 & 0xFF) - (short)(c2 & 0xFF);
                }
            }
        }
        return len1 - len2;
    }

    public static boolean startsWith(byte[] bcd, byte[] code) {
        byte last;
        int i = code.length;
        if (i > bcd.length) {
            return false;
        }
        if (code.length == 0) {
            return true;
        }
        if (((last = code[--i]) & 0xF) == 15) {
            if ((last & 0xF0) != (bcd[i] & 0xF0)) {
                return false;
            }
        } else {
            if (code.length == bcd.length && (bcd[i] & 0xF) == 15) {
                return false;
            }
            if (last != bcd[i]) {
                return false;
            }
        }
        if (i > 0) {
            if (code[0] != bcd[0]) {
                return false;
            }
            --i;
            while (i > 0) {
                if (code[i] != bcd[i]) {
                    return false;
                }
                --i;
            }
        }
        return true;
    }

    public static int startsWithCompare(byte[] bcd, byte[] code) {
        System.out.println(BCDecimal.compare(bcd, 0, code, 0, code.length));
        if (code.length == 0) {
            return 0;
        }
        if (bcd.length >= code.length) {
            int i = code.length;
            --i;
            for (int j = 0; j < i; ++j) {
                if (code[j] == bcd[j]) continue;
                short c1 = (short)(bcd[j] & 0xFF);
                short c2 = (short)(code[j] & 0xFF);
                return c1 - c2;
            }
            byte last = code[i];
            if ((last & 0xF) == 15) {
                short c1 = (short)(bcd[i] & 0xF0);
                short c2 = (short)(last & 0xF0);
                if (c1 != c2) {
                    return c1 - c2;
                }
            } else {
                if (code.length == bcd.length && (bcd[i] & 0xF) == 15) {
                    return -1;
                }
                short c1 = (short)(bcd[i] & 0xFF);
                short c2 = (short)(last & 0xFF);
                if (c1 != c2) {
                    return c1 - c2;
                }
            }
        } else {
            byte last;
            int i = bcd.length;
            if (((last = bcd[--i]) & 0xF) == 15) {
                short c1 = (short)(last & 0xF0);
                short c2 = (short)(code[i] & 0xF0);
                if (c1 != c2) {
                    return c1 - c2;
                }
            } else {
                short c1 = (short)(last & 0xFF);
                short c2 = (short)(code[i] & 0xFF);
                if (c1 != c2) {
                    return c1 - c2;
                }
            }
            return (bcd.length - code.length) * 2;
        }
        return 0;
    }
}

