/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDeviceType;
import ru.bitel.bgbilling.modules.voice.common.mediation.Mediator;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDeviceService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceDeviceDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceDeviceTypeDao;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceDevicesReloadEvent;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceSessionFinishDeviceEvent;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceType;
import ru.bitel.oss.systems.inventory.resource.server.bean.DeviceTypeDao;
import ru.bitel.oss.systems.inventory.resource.server.service.AbstractDeviceServiceImpl;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceDeviceService")
public class VoiceDeviceServiceImpl
extends AbstractDeviceServiceImpl<VoiceDevice, VoiceDeviceType>
implements VoiceDeviceService {
    private VoiceDeviceTypeDao voiceDeviceTypeDao;
    private VoiceDeviceDao voiceDeviceDao;
    private Directory<VoiceDeviceType> voiceDeviceTypeDirectory;

    @PostConstruct
    protected void init() throws BGException {
        super.init();
    }

    public List<VoiceDevice> voiceDeviceSourceList() throws BGException {
        return this.getDeviceDao().listSource();
    }

    public List<VoiceDevice> voiceDeviceRadiusList() throws BGException {
        return this.getDeviceDao().listNas();
    }

    public VoiceDevice deviceGet(int deviceId) throws BGException {
        return (VoiceDevice)this.getDeviceDao().get(deviceId);
    }

    public int deviceUpdate(VoiceDevice device) throws BGException {
        this.getDeviceDao().update((Device)device);
        EventProcessor.getInstance().publishAfterCommit((Event)new VoiceDevicesReloadEvent(this.moduleId, this.userId));
        return device.getId();
    }

    public void deviceDelete(int id) throws BGException {
        super.deviceDelete(id);
        EventProcessor.getInstance().publishAfterCommit((Event)new VoiceDevicesReloadEvent(this.moduleId, this.userId));
    }

    public VoiceDeviceType deviceTypeGet(int deviceTypeId) throws BGException {
        return (VoiceDeviceType)this.context.getDirectory(VoiceDeviceType.class, this.moduleId).get(deviceTypeId);
    }

    public int deviceTypeUpdate(VoiceDeviceType deviceType) throws BGException {
        int result = super.deviceTypeUpdate((DeviceType)deviceType);
        EventProcessor.getInstance().publishAfterCommit((Event)new VoiceDevicesReloadEvent(this.moduleId, this.userId));
        return result;
    }

    public void deviceTypeDelete(int deviceTypeId) throws BGException {
        EventProcessor.getInstance().publishAfterCommit((Event)new VoiceDevicesReloadEvent(this.moduleId, this.userId));
        super.deviceTypeDelete(deviceTypeId);
    }

    public String getMediationIface() throws BGException {
        return Mediator.class.getCanonicalName();
    }

    public String deviceConfigPreview(int id) throws BGException {
        return null;
    }

    protected Directory<VoiceDeviceType> getDeviceTypeDirectory() throws BGException {
        if (this.voiceDeviceTypeDirectory == null) {
            this.voiceDeviceTypeDirectory = this.context.getDirectory(VoiceDeviceType.class, this.moduleId);
        }
        return this.voiceDeviceTypeDirectory;
    }

    protected VoiceDeviceDao getDeviceDao() throws BGException {
        if (this.voiceDeviceDao == null) {
            this.voiceDeviceDao = new VoiceDeviceDao(this.getConnection(), this.moduleId, this.userId);
        }
        return this.voiceDeviceDao;
    }

    protected DeviceTypeDao<VoiceDeviceType> getDeviceTypeDao() throws BGException {
        if (this.voiceDeviceTypeDao == null) {
            this.voiceDeviceTypeDao = new VoiceDeviceTypeDao(this.getConnection(), this.moduleId);
        }
        return this.voiceDeviceTypeDao;
    }

    public void finishSessions(int deviceId) throws BGException {
        EventProcessor.getInstance().publish((Event)new VoiceSessionFinishDeviceEvent(this.moduleId, this.userId, deviceId));
    }
}

