/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.tariff;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneMapItem;
import ru.bitel.bgbilling.modules.voice.server.runtime.geocode.GeoCodeCache;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffRequest;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffWorkerContext;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class ZoneMapTariffTreeNode
extends TariffTreeNode<VoiceTariffRequest, VoiceTariffContext, TreeContext, VoiceTariffWorkerContext> {
    private final int mapId;

    public ZoneMapTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.mapId = parameterMap.getInt("map_id", 0);
    }

    protected int executeImpl(Long treeNodeId, Long parentTreeNodeId, VoiceTariffRequest voiceTariffRequest, VoiceTariffContext ctx, TreeContext treeContext, VoiceTariffWorkerContext workerContext) {
        String phone = voiceTariffRequest.phoneTo;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("phone => " + phone);
        }
        VoiceZoneMapItem item = null;
        if (Utils.notBlankString((String)phone)) {
            item = ctx.getZoneMapCache().findZone(this.mapId, phone);
        }
        if (item != null) {
            VoiceGeographicCode code = null;
            try {
                code = GeoCodeCache.findCode(phone, workerContext.getModuleId(), voiceTariffRequest.getOperatorId(), workerContext.getConnection());
            }
            catch (BGException e) {
                this.logger.error("", (Throwable)e);
            }
            if (code != null && code.getDestinationId() > 0) {
                voiceTariffRequest.setDestId(code.getDestinationId());
            } else {
                this.logger.warn("Destination from " + phone + " not found.");
            }
            if (item.getZoneId() > 0) {
                voiceTariffRequest.setZoneId(item.getZoneId());
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("phone => " + phone + ", findZone => " + item.getZoneId());
                }
                return 1;
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("phone => " + phone + ", notFindZone...");
        }
        return 0;
    }
}

