<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib prefix = "c" uri = "http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix = "fmt" uri = "http://java.sun.com/jsp/jstl/fmt" %>

<html>
<head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8" />
    <style type="text/css"><![CDATA[
            th.thService, th.thAon, th { text-align: left; }
    ]]>
    </style>
</head>
<body>
<div style="text-align: center;">
    <h2>
        <br/>Договор:&#160;${contract.title}(${contract.comment})
    </h2><br/>

    Период с: <fmt:formatDate pattern = "dd.MM.yyyy" value = "${dateFrom}"/> по <fmt:formatDate pattern = "dd.MM.yyyy" value = "${dateTo}"/>

    <table width="100%" border="1" cellspacing="0" cellpadding="3">
        <tr bgcolor="#f0f0f0">
            <td>Аккаунт</td>
            <td>Направление</td>
            <td>Номер телефона A#164</td>
            <td>Номер телефона B#164</td>
            <td>Старт</td>
            <td>Стоп</td>
            <td>Длительность, мин.</td>
            <td>Длительность окр, мин.</td>
            <td>Стоимость звонка,<br/>руб.</td>
        </tr>

        <%pageContext.getELContext().getImportHandler().importClass("ru.bitel.common.Utils");%>

        <c:forEach items="${result.list}" var="session">
            <tr>
                <td>${session.accountTitle}</td>
                <td>${destinationMap[session.destinationId]}</td>
                <td>${session.e164CallingStationId}</td>
                <td>${session.e164CalledStationId}</td>
                <td><fmt:formatDate pattern = "dd.MM.yyyy HH:mm:ss" value = "${session.sessionStart}"/></td>
                <td><fmt:formatDate pattern = "dd.MM.yyyy HH:mm:ss" value = "${session.sessionStop}"/></td>
                <td>${Utils.formatSessionTime( session.sessionTime )}</td>
                <td>${Utils.formatSessionTime( session.roundedSessionTime )}</td>
                <td>${session.sessionCost}</td>
            </tr>
        </c:forEach>

    </table>

    <br/>
    <br/>
    Количество сессий:&#160;;${result.getAttribute("totalCount")}
    Итого [в секундах]:&#160;${result.getAttribute("totalTime")}&#160;
    Итого [в рублях]:&#160;${result.getAttribute("totalSum")}&#160;

</div>
</body>
</html>
