<%@ page contentType="text/html; charset=UTF-8"%>
<%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<form method='get' action=''>
<input type="hidden" name="action" value="LoginDirect" />
<input type="hidden" name="id" value="${dataMap['id']}" />
<input type="hidden" name="type" value="${dataMap['type']}" />
<input type="hidden" name="command" value="save"/>
<input type="hidden" name="module" value="${dataMap['module'] }"/>
<input type="hidden" name="mid" value="${dataMap['mid'] }"/>

<%@include file="../include/error.jsp" %>

<table class="filter">
<c:set var="per" value="${dataMap['per']}" ></c:set>
	<tr>
		<th>
			<c:if test="${dataMap['module'] eq 'voiceip'}">Логин:</c:if>
			<c:if test="${dataMap['module'] eq 'voice'}">Телефон:</c:if>
		</th>
		<td>
			<select name="login">
				<c:set var="l" value="${dataMap['loginId']}" ></c:set>
				<c:forEach var="item" items="${dataMap['loginList']}">
       				<c:choose>
						<c:when test="${l == item.id}">
							<option value="${item.id}" selected="selected">${item.login}[ ${item.comment} ]</option>
						</c:when>
						<c:otherwise>
							<option value="${item.id}">${item.login}[ ${item.comment} ]</option>
						</c:otherwise>
					</c:choose>
      			</c:forEach>
			</select>
		</td>
		<th>Месяц:</th>
		<td>
			<c:set var="selectNameMonth" value="month" />
			<c:set var="selectMonth" value="${per.month}" />
			<%@include file="../include/month.jsp" %>
		</td>
		<th>Год:</th>
		<td>
			<select name="year">
				<c:forEach var="item" items="${dataMap['yearList']}">
					<c:choose>
						<c:when test="${item==per.year}">
							<option value="${item}" selected="selected">${item}</option>
						</c:when>
						<c:otherwise>
							<option value="${item}">${item}</option>
						</c:otherwise>
					</c:choose>
				</c:forEach>
			</select>
		</td>
		<th nowrap="nowrap">Числа месяца:</th>
		<th style="text-align:center">c</th>
		<td>
			<input type="text" name="day_from" size="4" value="${per.dayFrom}" />

		</td>
		<th style="text-align:center">по</th>
		<td>
			<input type="text" name="day_to" size="4" value="${per.dayTo}"/>
		</td>
		<td>
			<input type="submit" value="Вывести"/>
		</td>
	</tr>
</table>

<div class="report" >
	<table cellspacing='1' class="table800">
		<thead>
			<tr>
       			<td>Направление</td>
       			<td>Количество звонков</td>
       			<td>Время мин:сек</td>
       			<td>Время окр. мин:сек</td>
       			<td>Сумма</td>
			</tr>
		</thead>
		<tbody>
			<c:forEach var="item" items="${dataMap['listMaps']}">
				<tr>
					<td>${item['dest'] }</td>
					<td>${item['col'] }</td>               
					<td>${item['time'] }</td>
					<td>${item['round_time'] }</td>
					<td>${item['sum'] }</td>               
				</tr>
			</c:forEach>
		</tbody>
		<tfoot>
			<tr>
				<td>Итого:</td>
        		<td>${dataMap['count_amount'] }</td>
    			<td>${dataMap['time_amount'] }</td>
        		<td>${dataMap['round_time_amount'] }</td>
        		<td>${dataMap['money_amount'] }</td>
			</tr>
		</tfoot>
	</table>
</div>
</form>
