<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">
<xsl:import href="layout.xsl"/>

<xsl:output encoding="UTF-8" method='html' indent='yes'/>

<xsl:variable name="mid" select="/data/@mid"/>

<xsl:template match="/">
	<xsl:call-template name="main">
  		<xsl:with-param name="mode" select="'pub'"/>
  	</xsl:call-template>
</xsl:template>


<xsl:template name="head">
<xsl:text disable-output-escaping="yes">
	<![CDATA[    
    <style TYPE="text/css" TITLE="voiceip style">
        <!-- 
/*
		#idTdLeftPanel,
		#idTableContractTitle
 		{ display: none; }
	
		#idTableHeader { position: relative; top: -56px; }		
		#idTdSubContracts { position: relative; top: 36px; display: block; height: 34px; }		
		#idTdSubContractsLine { position: relative; top: 36px; display: block; }		

		#id_menu {
			position: absolute;
			top: 152px;
			font-family: Arial, Helvetica, sans-serif;
			font-size: 12px;
			color: #FFFFFF !important;
			padding-left: 15px;
		}
		
		#id_menu img { margin: 0px; padding: 0px; }
		
		#id_menu a, #id_menu img {
			margin-right: 18px;
			color: #FFFFFF !important;
		}
*/
		-->
    </style>
    ]]>
</xsl:text>
</xsl:template>


<xsl:template name="title">
	<xsl:choose>
		<xsl:when test="/data/@action='ContractList'">Справочник VoiceIP</xsl:when>
		<xsl:otherwise>Регистрация VoiceIP</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template match="/data">
	<div id="id_menu">
		<a href="{$PUBEXECUTER}?action=CreateContract&amp;module=voiceip&amp;mid={$mid}" style="margin-right: 10px;">Регистрация</a> | 
		<a href="{$PUBEXECUTER}?action=ContractList&amp;module=voiceip&amp;mid={$mid}&amp;debug=1" style="margin-left: 10px;">Справочник</a>
	</div><br/>
	
	<xsl:choose>
		<xsl:when test="@action='ContractList'">
			<xsl:call-template name="ContractList"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="ContractCreate"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>


<xsl:template name="ContractCreate">

	<strong>Создание договора VoiceIP</strong>
	<div class="report">
	<form  method="post" action="{$PUBEXECUTER}?action=CreateContract&amp;module=voiceip&amp;mid={$mid}">
	<table width="500" border="0" cellpadding="0" cellspacing="0">
		<tr>
			<td>Введите ФИО:</td>
			<td align="right">
				<input name="fio" type="text" size="30" value="{/data/params/@fio}"/>
			</td>
		</tr>	
		<tr>
			<td>Введите email:</td>			
			<td align="right">
				<input name="email" type="text" size="30" value="{/data/params/@email}"/>
			</td>
		</tr>
		<tr>
			<td colspan="2"><input type="checkbox" name="ref" value="1">
			<xsl:if test="/data/params/@ref = 1"><xsl:attribute name="checked">1</xsl:attribute></xsl:if>
			</input>
				разрешать поиск в справочнике</td>
		</tr>
		<tr>
			<td>Телефон:</td>
			<td align="right">
				<input type="text" size="30" name="alias" value="{/data/params/@alias}"/>
			</td>
		</tr>
		
		<xsl:if test="not(/data/params/@find)">
		<input type="hidden" name="find" value="1"/>
		<tr>
			<!--
			<td colspan="2" align="right"><input type="submit" value="Проверить номер"/></td>
			-->			
			<td colspan="2" align="right">
				<xsl:call-template name="submit">
					<xsl:with-param name="title" select="'Проверить номер'"/>
				</xsl:call-template>
			</td>
		</tr>
		</xsl:if>
		
		<xsl:if test="/data/params/@find">
		<tr>
			<td>Укажите пароль:</td>
			<td align="right"><input type="password" size="30" name="passw1" value="{/data/params/@passw}"/></td>
		</tr>
		<tr>
			<td>Повторите пароль:</td>
			<td align="right"><input type="password" size="30" name="passw2" value="{/data/params/@passw}"/></td>
		</tr>
		<tr>
			<td colspan="2">Введите символы, показанные на картинке.</td>
		</tr>
		<tr>
			<td valign="middle"><img src="{$PUBEXECUTER}?module=voiceip&amp;action=CreateContract&amp;mid={$mid}&amp;getcaptcha={/data/params/@random}"/></td>
			<td align="right"><input type="text" size="30" name="captcha"/><br/>Буквы вводятся без учета регистра.</td>
		</tr>
		<tr>
			<td colspan="2" align="right"><input type="submit" value="Создать договор"/></td>
		</tr>
		</xsl:if>
		
		<tr><td colspan="2"><hr/></td></tr>
		
		<xsl:if test="/data/@status='error'">
			<tr><td colspan="2" style="color:red; font-weight: bold">				
				<xsl:value-of select="/data/text()"/>
			</td></tr>
		</xsl:if>

		<xsl:if test="/data/free">
			<tr><td colspan="2" style="font-weight: bold">			
				Свободные номера:
			</td></tr>
		<xsl:for-each select="/data/free/alias">
			<tr><td colspan="2" style="font-weight: bold">			
				<xsl:value-of select="@alias"/>
			</td></tr>
		</xsl:for-each>
		</xsl:if>
		
		<xsl:if test="/data/contract">
			<tr><td colspan="2" style="font-weight: bold">			
				Договор создан.<br/><br/>
				<xsl:apply-templates select="/data/contract"/>
			</td></tr>
		</xsl:if>

	</table>
	</form>
	</div>
</xsl:template>

<xsl:template match="contract">
	Название договора <xsl:value-of select="@title"/><br/>
	Для дальнейших операций с договором вам нужно перейти на 
	<a href="#">страницу статистики</a>.<br/>
	В качестве логина доступа
	используйте имя договора, в качестве пароля - заданный пароль
</xsl:template>

<xsl:template name="ContractList">
	<form method="post" action="{$PUBEXECUTER}#idDivReport" id="reportForm">
		<xsl:call-template name="action"/>	
		<xsl:call-template name="filters"/>
		<input type="hidden" name="debug" value="1"/>
		<input type="hidden" name="pageSize"><xsl:attribute name="value"><xsl:value-of select="/data/@pageSize"/></xsl:attribute></input>
	</form>

	<div class="bgPagesWidget" style="text-align: right; width: 800px;" formId="reportForm" recordCount="{/data/@recordCount}"
		pageIndex="{/data/@pageIndex}" pageSize="{/data/@pageSize}" pageCount="{/data/@pageCount}" />

	<table class="table800">
	<thead>
		<tr>
			<td>Номер</td>
			<td>ФИО</td>
			<td>Email</td>
      		</tr>
	</thead>
	<tbody>
		<xsl:for-each select="aliases/alias">
		<tr>
			<td><xsl:value-of select="@alias"/></td>
			<td><xsl:value-of select="@fio"/></td>
			<td><xsl:value-of select="@email"/></td>
		</tr>
		</xsl:for-each>
	</tbody>
	</table>
</xsl:template>


<xsl:template name="filters">
	<table class="filter">
		<tr>
			<td>Номер:</td>
			<td><input type="text" name="alias" size="8" value="{/data/@alias}"/></td>
			<td>ФИО:</td>
			<td><input type="text" name="fio" size="25" value="{/data/@fio}"/></td>
			<td>Email:</td>
			<td><input type="text" name="email" size="20" value="{/data/@email}"/></td>
			<td style="text-align: right; padding-right: 22px;">
				<xsl:call-template name="submit">
					<xsl:with-param name="title" select="'Вывести'"/>
				</xsl:call-template>
			</td>
		</tr>
	</table>
</xsl:template>


<xsl:template name="filters_hidden">
	<input type="hidden" name="alias" value="{/data/@alias}"/>
	<input type="hidden" name="fio" value="{/data/@fio}"/>
	<input type="hidden" name="email" value="{/data/@email}"/>
</xsl:template>


</xsl:stylesheet>
