/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.yoomoney.server.bean;

import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import org.apache.logging.log4j.LogManager;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.CurrencyBank;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.CurrencyCode;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.yoomoney.common.bean.TransactionStatus;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    private static Pattern pcontr = Pattern.compile("\\$\\{contract\\}");
    private static Pattern pcontrComment = Pattern.compile("\\$\\{contract_comment\\}");
    private static Pattern pOrderSumAmount = Pattern.compile("\\$\\{orderSumAmount\\}");
    private static Pattern pOrderSumCurrencyPaycash = Pattern.compile("\\$\\{orderSumCurrencyPaycash\\}");
    private static Pattern pShopSumAmount = Pattern.compile("\\$\\{shopSumAmount\\}");
    private static Pattern pShopSumCurrencyPaycash = Pattern.compile("\\$\\{shopSumCurrencyPaycash\\}");
    private static Pattern pDate = Pattern.compile("\\$\\{date\\}");
    private static Pattern pInvoiceId = Pattern.compile("\\$\\{invoiceId\\}");
    private static Pattern pPaymentPayerCode = Pattern.compile("\\$\\{paymentPayerCode\\}");

    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "yoomoney_transactions");
        this.logger = LogManager.getLogger();
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("paymentDateTime", "paymentDateTime");
        this.fields.put("invoiceId", "invoiceId");
        this.fields.put("shopSumAmount", "shopSumAmount");
    }

    public void searchTransactionList(SearchResult<Transaction> searchResult, int contractId, String contractTitle, String status) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            String[] sort = searchResult.getSort();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            if (page == null) {
                page = new Page(1, Integer.MAX_VALUE);
            }
            StringBuilder query = new StringBuilder(" FROM ").append(this.tableName).append(" AS pt ").append("LEFT JOIN contract ON contract.id=pt.cid WHERE true");
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND pt.paymentDateTime>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND pt.paymentDateTime<?");
                }
            }
            this.queryStatus(query, status);
            if (Utils.notBlankString((String)contractTitle)) {
                query.append(" AND contract.title LIKE ?");
            }
            if (contractId > 0) {
                query.append(" AND pt.cid=").append(contractId);
            }
            try {
                ResultSet rs = null;
                PreparedStatement ps = null;
                ps = this.con.prepareStatement("SELECT SUM(pt.shopSumAmount), SUM(pt.orderSumAmount), COUNT(*) " + query.toString());
                int parameterIndex = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((java.util.Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((java.util.Date)TimeUtils.getNextDay((java.util.Date)period.getDateTo())));
                    }
                }
                parameterIndex = this.psStatus(ps, status, parameterIndex);
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(parameterIndex++, "%" + contractTitle + "%");
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    BigDecimal sumShop = rs.getBigDecimal(1);
                    BigDecimal sumOrder = rs.getBigDecimal(2);
                    if (sumShop != null && sumOrder != null) {
                        searchResult.setSum(sumShop.compareTo(BigDecimal.ZERO) == 0 ? sumOrder : sumShop);
                    }
                    page.setRecordCount(rs.getInt(3));
                }
                rs.close();
                ps.close();
                if (page.getPageIndex() > page.getPageCount()) {
                    page.setPageIndex(page.getPageCount());
                }
                ps = this.con.prepareStatement("SELECT pt.*, contract.title, contract.comment AS con_comment" + query.toString() + this.getSQLOrder(sort, this.fields) + (page != null ? page.sqlLimit() : ""));
                parameterIndex = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((java.util.Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((java.util.Date)TimeUtils.getNextDay((java.util.Date)period.getDateTo())));
                    }
                }
                if (Utils.notBlankString((String)contractTitle)) {
                    ps.setString(parameterIndex++, "%" + contractTitle + "%");
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
                rs.close();
                ps.close();
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    public List<String> getCheckIds(int intervalMinute) throws BGException {
        ArrayList<String> list = new ArrayList<String>();
        try (ResultSet rs = this.con.createStatement().executeQuery("SELECT yoomoneyId FROM " + this.tableName + " WHERE status='pending' AND paymentId < 1 AND paymentDateTime < DATE_SUB( NOW(), INTERVAL " + intervalMinute + " MINUTE)");){
            while (rs.next()) {
                list.add(rs.getString(1));
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return list;
    }

    public Transaction getTransactionForInvoice(long invoiceId) throws BGException {
        try {
            Transaction transaction = null;
            String query = "SELECT payment.*, contract.title, contract.comment AS con_comment FROM " + this.tableName + " AS payment LEFT JOIN contract ON contract.id=payment.cid WHERE payment.invoiceId=" + invoiceId;
            Statement ps = this.con.createStatement();
            ResultSet rs = ps.executeQuery(query);
            if (rs.next()) {
                transaction = this.getFromRS(rs);
            }
            rs.close();
            ps.close();
            return transaction;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Transaction getTransactionByYoomoneyId(String yoomoneyId) throws BGException {
        if (Utils.isBlankString((String)yoomoneyId)) {
            return null;
        }
        String query = "SELECT payment.*, contract.title, contract.comment AS con_comment FROM " + this.tableName + " AS payment LEFT JOIN contract ON contract.id=payment.cid WHERE payment.yoomoneyId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, yoomoneyId);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return null;
            Transaction transaction = this.getFromRS(rs);
            return transaction;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public Transaction getTransactionByPaymentId(int paymentId) throws BGException {
        return (Transaction)this.get("paymentId=?", new Object[]{paymentId});
    }

    public int getFirstYear(int cid) throws BGException {
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT MIN(paymentDateTime) FROM " + this.tableName + " WHERE cid=" + cid);
            Date date = null;
            if (rs.next()) {
                date = rs.getDate(1);
            }
            rs.close();
            st.close();
            return (date != null ? TimeUtils.convertDateToCalendar((java.util.Date)date) : new GregorianCalendar()).get(1);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteTransaction(int id) throws BGException {
        try (Statement st = this.con.createStatement();){
            st.executeUpdate("DELETE FROM " + this.tableName + " WHERE id=" + id);
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateTransaction(Transaction transaction) throws BGException {
        boolean update = transaction.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET cid=?, invoiceId=?, orderSumAmount=?, orderSumCurrencyPaycash=?, orderSumBankPaycash=?, shopSumAmount=?, shopSumCurrencyPaycash=?, shopSumBankPaycash=?, paymentPayerCode=?, paymentDateTime=?, paymentType=?, rawRequest=?, yoomoneyId=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setLong(index++, transaction.getInvoiceId());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setInt(index++, transaction.getOrderSumCurrencyPaycash().getId());
            ps.setInt(index++, transaction.getOrderSumBankPaycash().getId());
            ps.setBigDecimal(index++, transaction.getShopSumAmount());
            ps.setInt(index++, transaction.getShopSumCurrencyPaycash().getId());
            ps.setInt(index++, transaction.getShopSumBankPaycash().getId());
            ps.setString(index++, transaction.getPaymentPayerCode());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((java.util.Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getPaymentType());
            ps.setString(index++, transaction.getRawRequest());
            ps.setString(index++, transaction.getYoomoneyId());
            if (update) {
                ps.setInt(index++, transaction.getId());
            }
            ps.executeUpdate();
            if (!update) {
                transaction.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    @Deprecated
    public void carryOutPayment(Transaction transaction) throws BGException {
        if (transaction != null) {
            int paymentType = this.moduleSetup.getInt("yoomoney.payment.type.id", this.moduleSetup.getInt("paymenttype", 0));
            String paymentComment = this.formatComment(this.moduleSetup.get("yoomoney.payment.comment", this.moduleSetup.get("paymentCommentPattern", "\u041f\u043b\u0430\u0442\u0451\u0436 \u0447\u0435\u0440\u0435\u0437 \u042eKassa")), transaction);
            boolean isOrderSumAmount = "order".equals(this.moduleSetup.get("yoomoney.payment.sum.amount", this.moduleSetup.get("paymentSumAmount", null)));
            Payment payment = new Payment();
            payment.setContractId(transaction.getContractId());
            payment.setTypeId(paymentType);
            payment.setDate(transaction.getTransactionDate());
            payment.setSum(isOrderSumAmount ? transaction.getSum() : transaction.getShopSumAmount());
            payment.setUserId(0);
            payment.setComment(paymentComment);
            try (PaymentDao paymentDao = new PaymentDao(this.con);){
                paymentDao.update((Object)payment);
            }
            ServerUtils.commitConnection((Connection)this.con);
            BalanceUtils bu = new BalanceUtils(this.con);
            bu.updateBalance(payment.getDate(), transaction.getContractId());
            bu.close();
            ServerUtils.commitConnection((Connection)this.con);
            EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
        }
    }

    public String formatComment(String pattern, Transaction transaction) {
        String desc = pOrderSumAmount.matcher(pattern).replaceAll(transaction.getSum() != null ? transaction.getSum().toString() : "?");
        desc = pShopSumAmount.matcher(desc).replaceAll(transaction.getShopSumAmount() != null ? transaction.getShopSumAmount().toString() : "?");
        desc = pDate.matcher(desc).replaceAll(TimeUtils.format((java.util.Date)transaction.getTransactionDate(), (String)"dd.MM.yyyy HH:mm:ss"));
        desc = pInvoiceId.matcher(desc).replaceAll(String.valueOf(transaction.getInvoiceId()));
        desc = pPaymentPayerCode.matcher(desc).replaceAll(transaction.getPaymentPayerCode() != null ? transaction.getPaymentPayerCode() : "?");
        desc = pOrderSumCurrencyPaycash.matcher(desc).replaceAll(transaction.getOrderSumCurrencyPaycash() != null ? transaction.getOrderSumCurrencyPaycash().getTitle() : "?");
        desc = pShopSumCurrencyPaycash.matcher(desc).replaceAll(transaction.getShopSumCurrencyPaycash() != null ? transaction.getShopSumCurrencyPaycash().getTitle() : "?");
        Contract contract = null;
        try (ContractDao contractDao = new ContractDao(this.con, 0);){
            contract = (Contract)contractDao.get(transaction.getContractId());
        }
        catch (BGException e) {
            e.printStackTrace();
        }
        desc = pcontr.matcher(desc).replaceAll(contract != null && contract.getTitle() != null ? contract.getTitle() : "?");
        desc = pcontrComment.matcher(desc).replaceAll(contract != null && contract.getComment() != null ? contract.getComment() : "?");
        return desc;
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        Transaction transaction = new Transaction();
        transaction.setId(rs.getInt("id"));
        transaction.setContractId(rs.getInt("cid"));
        transaction.setInvoiceId(rs.getLong("invoiceId"));
        transaction.setSum(rs.getBigDecimal("orderSumAmount"));
        transaction.setOrderSumCurrencyPaycash((CurrencyCode)Utils.getListItemEnumFromId(CurrencyCode.class, (int)rs.getInt("orderSumCurrencyPaycash")));
        transaction.setOrderSumBankPaycash((CurrencyBank)Utils.getListItemEnumFromId(CurrencyBank.class, (int)rs.getInt("orderSumBankPaycash")));
        transaction.setShopSumAmount(rs.getBigDecimal("shopSumAmount"));
        transaction.setShopSumCurrencyPaycash((CurrencyCode)Utils.getListItemEnumFromId(CurrencyCode.class, (int)rs.getInt("shopSumCurrencyPaycash")));
        transaction.setShopSumBankPaycash((CurrencyBank)Utils.getListItemEnumFromId(CurrencyBank.class, (int)rs.getInt("shopSumBankPaycash")));
        transaction.setPaymentPayerCode(rs.getString("paymentPayerCode"));
        transaction.setTransactionDate((java.util.Date)rs.getTimestamp("paymentDateTime"));
        transaction.setPaymentType(rs.getString("paymentType"));
        transaction.setRawRequest(rs.getString("rawRequest"));
        transaction.setPaymentId(rs.getInt("paymentId"));
        transaction.setStatus(rs.getString("status"));
        transaction.setYoomoneyId(rs.getString("yoomoneyId"));
        transaction.setContractTitle(rs.getString("contract.title"));
        transaction.setContractComment(rs.getString("con_comment"));
        return transaction;
    }

    protected void updateImpl(Transaction transaction) throws BGException, SQLException {
        try {
            boolean isInsert = transaction.getId() < 1;
            String query = (isInsert ? "INSERT INTO " : "UPDATE ") + this.tableName + " SET cid=?, invoiceId=?, yoomoneyId=?, orderSumAmount=?, orderSumCurrencyPaycash=?, paymentDateTime=?, paymentType=?, paymentId=?, status=?, rawRequest=?" + (isInsert ? "" : " WHERE  id=?");
            int parameterIndex = 1;
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(parameterIndex++, transaction.getContractId());
            ps.setLong(parameterIndex++, transaction.getInvoiceId());
            ps.setString(parameterIndex++, transaction.getYoomoneyId());
            ps.setBigDecimal(parameterIndex++, transaction.getSum());
            ps.setInt(parameterIndex++, transaction.getOrderSumCurrencyPaycash().getId());
            ps.setTimestamp(parameterIndex++, TimeUtils.convertDateToTimestamp((java.util.Date)transaction.getTransactionDate()));
            ps.setString(parameterIndex++, transaction.getPaymentType());
            ps.setInt(parameterIndex++, transaction.getPaymentId());
            ps.setString(parameterIndex++, transaction.getStatus());
            ps.setString(parameterIndex++, transaction.getRawRequest());
            if (!isInsert) {
                ps.setInt(parameterIndex++, transaction.getId());
            }
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    protected void setConnectionTimeout(HttpsURLConnection connection) {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        connection.setConnectTimeout(moduleSetup.getInt("yoomoney.connect.timeout", 5000));
        connection.setReadTimeout(moduleSetup.getInt("yoomoney.read.timeout", 3000));
    }

    public JSONObject getPaymentRequestJSON(BigDecimal sum, int contractId, String contractTitle) throws BGException {
        JSONObject amount = new JSONObject();
        amount.put("value", (Object)sum.toPlainString());
        amount.put("currency", (Object)"RUB");
        JSONObject confirmation = new JSONObject();
        confirmation.put("type", (Object)"redirect");
        confirmation.put("return_url", (Object)this.moduleSetup.get("yoomoney.shop.return.url", ""));
        JSONObject metadata = new JSONObject();
        metadata.put("contractId", contractId);
        JSONObject receipt = null;
        if (this.moduleSetup.getBoolean("yoomoney.fiscalization.enable", false)) {
            String customerAddress = ContractModuleConfigDao.getPaymentCheckAddress((Connection)this.con, (int)this.moduleId, (int)contractId);
            JSONObject customer = new JSONObject();
            if (!Utils.isBlankString((String)customerAddress)) {
                if (customerAddress.contains("@")) {
                    customer.put("email", (Object)customerAddress);
                } else {
                    customer.put("phone", (Object)customerAddress);
                }
            }
            JSONObject itemAmount = new JSONObject().put("value", (Object)sum.setScale(2, RoundingMode.HALF_UP).toPlainString().replace(',', '.')).put("currency", (Object)this.moduleSetup.get("yoomoney.fiscalization.receipt.currency", "RUB"));
            JSONObject item = new JSONObject();
            item.put("description", (Object)this.moduleSetup.get("yoomoney.fiscalization.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle));
            item.put("quantity", (Object)String.valueOf(this.moduleSetup.getInt("yoomoney.fiscalization.receipt.qty", 1)));
            item.put("amount", (Object)itemAmount);
            item.put("vat_code", this.moduleSetup.getInt("yoomoney.fiscalization.receipt.vat_code", 1));
            receipt = new JSONObject().put("customer", (Object)customer).put("items", (Object)new JSONArray().put((Object)item));
        }
        JSONObject data = new JSONObject();
        data.put("amount", (Object)amount);
        data.put("capture", true);
        data.put("confirmation", (Object)confirmation);
        data.put("description", (Object)("\u041e\u043f\u043b\u0430\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116" + contractTitle));
        data.put("metadata", (Object)metadata);
        if (receipt != null) {
            data.put("receipt", receipt);
        }
        return data;
    }

    public String doPaymentRequest(String data, String idempotenceKey) {
        StringBuilder spec = new StringBuilder(this.moduleSetup.get("yoomoney.payment.api.url", "https://api.yookassa.ru/v3/payments"));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + spec.toString());
        }
        StringBuilder resultJson = null;
        try {
            String shopId = this.moduleSetup.get("yoomoney.shopId", null);
            String apiKey = this.moduleSetup.get("yoomoney.api.key", null);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("Content-Type", "application/json; charset=utf-8");
            map.put("Idempotence-Key", idempotenceKey);
            map.put("Authorization", "Basic " + Base64.getEncoder().encodeToString((shopId + ":" + apiKey).getBytes("UTF-8")));
            resultJson = this.doConnection(spec.toString(), "POST", true, data, map);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\t\u041e\u0442\u0432\u0435\u0442: " + resultJson);
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
        }
        return String.valueOf(resultJson);
    }

    public void doCheckRequest(String objectId) {
        StringBuilder spec = new StringBuilder(this.moduleSetup.get("yoomoney.payment.api.url", "https://api.yookassa.ru/v3/payments")).append("/").append(objectId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + spec.toString());
        }
        StringBuilder resultJson = null;
        try {
            String shopId = this.moduleSetup.get("mobile.shopId", this.moduleSetup.get("yoomoney.shopId", null));
            String apiKey = this.moduleSetup.get("yoomoney.api.key", null);
            HashMap<String, CallSite> map = new HashMap<String, CallSite>();
            map.put("Authorization", (CallSite)((Object)("Basic " + Base64.getEncoder().encodeToString((shopId + ":" + apiKey).getBytes("UTF-8")))));
            resultJson = this.doConnection(spec.toString(), "GET", true, null, map);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\t\u041e\u0442\u0432\u0435\u0442: " + resultJson);
            }
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
        }
        JSONObject resultJsonObject = null;
        if (resultJson != null) {
            resultJsonObject = new JSONObject(resultJson.toString());
            String yoomoneyId = String.valueOf(resultJsonObject.optQuery("/id"));
            String status = String.valueOf(resultJsonObject.optQuery("/status"));
            BigDecimal sum = new BigDecimal(String.valueOf(resultJsonObject.optQuery("/amount/value")));
            this.doTransaction(yoomoneyId, status, sum, resultJsonObject);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void doTransaction(String yoomoneyId, String status, BigDecimal sum, JSONObject resultJsonObject) {
        block41: {
            try {
                transaction = this.getTransactionByYoomoneyId(yoomoneyId);
                if (transaction == null) break block41;
                transaction.setSum(sum);
                var6_7 = status;
                var7_8 = -1;
                switch (var6_7.hashCode()) {
                    case 945734241: {
                        if (!var6_7.equals("succeeded")) break;
                        var7_8 = 0;
                        break;
                    }
                    case -123173735: {
                        if (!var6_7.equals("canceled")) break;
                        var7_8 = 1;
                    }
                }
                switch (var7_8) {
                    case 0: {
                        if (transaction.getPaymentId() >= 1) break;
                        dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
                        capturedAt = String.valueOf(resultJsonObject.optQuery("/captured_at"));
                        if (capturedAt == null) {
                            capturedAt = String.valueOf(resultJsonObject.optQuery("/created_at"));
                        }
                        payment = new Payment();
                        payment.setContractId(transaction.getContractId());
                        payment.setSum(transaction.getSum());
                        payment.setDate((java.util.Date)new Date(dateFormat.parse(capturedAt).getTime() / 1000L * 1000L));
                        payment.setTypeId(this.moduleSetup.getInt("yoomoney.payment.type.id", 0));
                        payment.setComment(this.moduleSetup.get("yoomoney.payment.comment", "\u041f\u043b\u0430\u0442\u0451\u0436 \u0447\u0435\u0440\u0435\u0437 \u042eKassa"));
                        paymentDao = new PaymentDao(this.con);
                        try {
                            balanceUtils = new BalanceUtils(this.con);
                            try {
                                paymentDao.update((Object)payment);
                                ServerUtils.commitConnection((Connection)this.con);
                                balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
                            }
                            finally {
                                balanceUtils.close();
                            }
                        }
                        finally {
                            paymentDao.close();
                        }
                        transaction.setPaymentId(payment.getId());
                        transaction.setStatus(TransactionStatus.SUCCEEDED.getCode());
                        transaction.setRawRequest(resultJsonObject.toString(2));
                        this.update(transaction);
                        EventProcessor.getInstance().publishAfterCommit((Event)new PaymentEvent(0, payment));
                        EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getDate(), payment.getSum()));
                        saved = Boolean.valueOf(String.valueOf(resultJsonObject.optQuery("/payment_method/saved")));
                        if (!saved) break;
                        contractModuleConfigDao = new ContractModuleConfigDao(this.con, this.moduleId);
                        try {
                            paymentMethodId = String.valueOf(resultJsonObject.optQuery("/payment_method/id"));
                            contractModuleConfigDao.update(transaction.getContractId(), "payment.method.id", paymentMethodId);
                            break;
                        }
                        finally {
                            contractModuleConfigDao.close();
                        }
                    }
                    case 1: {
                        payment = null;
                        if (transaction.getPaymentId() <= 0) ** GOTO lbl71
                        paymentDao = new PaymentDao(this.con);
                        try {
                            payment = (Payment)paymentDao.get(transaction.getPaymentId());
                            paymentDao.delete(transaction.getPaymentId());
                        }
                        finally {
                            paymentDao.close();
                        }
                        transaction.setPaymentId(0);
lbl71:
                        // 2 sources

                        transaction.setRawRequest(resultJsonObject.toString(2));
                        transaction.setStatus(TransactionStatus.CANCELED.getCode());
                        this.update(transaction);
                        if (payment == null) ** GOTO lbl83
                        balanceUtils = new BalanceUtils(this.con);
                        try {
                            balanceUtils.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
                        }
                        finally {
                            balanceUtils.close();
                        }
                        EventProcessor.getInstance().publishAfterCommit((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum().negate()));
lbl83:
                        // 2 sources

                        if (!"payment_method_restricted".equals(cancellationDetailsReason = String.valueOf(resultJsonObject.optQuery("/cancellation_details/reason"))) && !"permission_revoked".equals(cancellationDetailsReason) && !"card_expired".equals(cancellationDetailsReason)) break;
                        contractModuleConfigDao = new ContractModuleConfigDao(this.con, this.moduleId);
                        try {
                            contractModuleConfigDao.delete(transaction.getContractId(), "payment.method.id");
                            break;
                        }
                        finally {
                            contractModuleConfigDao.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e);
            }
        }
    }
}

