/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.alfabank.server.event.worker;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.alfabank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.alfabank.server.event.AlfabankCheckEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class AlfabankCheckEventWorker
extends EventWorker {
    private static final Logger log = LogManager.getLogger();
    private final int moduleId;
    private TransactionManager transactionManager;

    public AlfabankCheckEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), AlfabankCheckEvent.class, moduleId, -1, null);
        this.moduleId = moduleId;
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 10000L;
        log.info("Starting AlfabankCheckEventWorker for moduleId: {}", (Object)moduleId);
        new Thread((Runnable)((Object)this), "alfabank-check-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        try {
            boolean bl = this.doTasks();
            return bl;
        }
        finally {
            this.transactionManager.close();
            this.transactionManager = null;
        }
    }

    public Object doTask(Object task) throws BGException {
        AlfabankCheckEvent event = (AlfabankCheckEvent)((Object)task);
        this.transactionManager.doCheckRequest(event.getContractId(), event.isAutopaymentTransaction());
        return null;
    }
}

