/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGControlPanelDateNoB;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.dynamic.client.ClientDynLoader;
import ru.bitel.bgbilling.plugins.assistant.client.AssistantActionBaseDialog;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantButton;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantFieldType;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantKeyValue;
import ru.bitel.bgbilling.plugins.assistant.common.bean.FilterTableModel;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Period;

public class AssistantActionDialog
extends AssistantActionBaseDialog {
    private String comment = "";
    private String actionId;
    private JTextArea commentTextArea = null;
    private Map<String, String> messages = new HashMap<String, String>();
    private JSONObject configJsonObject = null;
    private JSONObject options = null;
    private Map<String, Component> componentMap = new HashMap<String, Component>();
    private Map<String, String> hiddenFileld = new HashMap<String, String>();
    private List<JSONObject> tableSelectedRows;

    public AssistantActionDialog(String actionId, ClientContext clientContext) {
        super(clientContext);
        this.actionId = actionId;
        try {
            AssistantAction assistantAction = this.getAssistantService().getAssistantActionByActionId(actionId);
            this.setTitle(assistantAction.getTitle());
            this.configJsonObject = new JSONObject(assistantAction.getConfig());
            this.options = this.configJsonObject.optJSONObject("options");
            if (this.options == null) {
                this.options = new JSONObject();
            }
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getMessagePanel(), "North");
        this.getContentPane().add((Component)this.getPanelWithComponents(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        int width = this.options.optInt("windowSizeWidth", 600);
        int height = this.options.optInt("windowSizeHeight", 400);
        this.setSize(width, height);
        String windowSizeMode = this.options.optString("windowSizeMode");
        if ("\u0430\u0432\u0442\u043e".equals(windowSizeMode)) {
            this.pack();
        }
        this.moveWindowToCenterScreen();
    }

    private JPanel getMessagePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.comment = this.configJsonObject.optString("comment", null);
        if (Utils.notBlankString((String)this.comment)) {
            this.commentTextArea = new JTextArea(3, 5);
            this.commentTextArea.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.commentTextArea.setEditable(false);
            this.commentTextArea.setLineWrap(true);
            this.commentTextArea.setWrapStyleWord(true);
            this.commentTextArea.setText(this.comment);
            JScrollPane scrollPane = new JScrollPane(this.commentTextArea);
            scrollPane.setBorder(null);
            panel.add((Component)scrollPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(15, 15, 10, 15), 0, 0));
        }
        return panel;
    }

    private JScrollPane getPanelWithComponents() {
        FocusAdapter messageAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (AssistantActionDialog.this.commentTextArea != null) {
                    AssistantActionDialog.this.commentTextArea.setText(AssistantActionDialog.this.comment);
                }
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (AssistantActionDialog.this.commentTextArea != null) {
                    String message = AssistantActionDialog.this.messages.get(focusEvent.getComponent().getName());
                    AssistantActionDialog.this.commentTextArea.setText(Utils.notBlankString((String)message) ? message : AssistantActionDialog.this.comment);
                }
            }
        };
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        JSONArray params = this.configJsonObject.optJSONArray("params");
        if (params != null) {
            FieldLabelLayout labelLayout = this.defineLayout(this.configJsonObject.optJSONObject("options"));
            boolean isAbove = FieldLabelLayout.ABOVE.equals((Object)labelLayout);
            for (int index = 0; index < params.length(); ++index) {
                JSONObject paramObject = params.getJSONObject(index);
                String key = paramObject.optString("key");
                AssistantFieldType type = AssistantFieldType.getAssistantFieldTypeByCode((String)paramObject.optString("type"));
                String value = paramObject.optString("value");
                String comment = paramObject.optString("comment", null);
                if (comment != null) {
                    this.messages.put(key, comment);
                }
                if (type == null) continue;
                Object component = null;
                switch (type) {
                    case HIDDEN: {
                        this.hiddenFileld.put(key, value);
                        break;
                    }
                    case STRING: {
                        component = new JTextField(value);
                        gridy = this.addComponent(key, (Component)component, panel, paramObject, gridy, 1.0, 2, isAbove);
                        break;
                    }
                    case DATE: {
                        component = new BGControlPanelDateNoB();
                        gridy = this.addComponent(key, (Component)component, panel, paramObject, gridy, 0.0, 0, isAbove);
                        break;
                    }
                    case PERIOD: {
                        component = new BGControlPanelPeriodNoB();
                        gridy = this.addComponent(key, (Component)component, panel, paramObject, gridy, 0.0, 0, isAbove);
                        break;
                    }
                    case BOOLEAN: {
                        component = new JCheckBox();
                        gridy = this.addComponent(key, (Component)component, panel, paramObject, gridy, 0.0, 0, isAbove);
                        break;
                    }
                    case INTEGER: 
                    case DECIMAL: {
                        component = new JTextField();
                        ((AbstractDocument)((JTextField)component).getDocument()).setDocumentFilter(new DigitDocumentFilter(type == AssistantFieldType.INTEGER));
                        gridy = this.addComponent(key, (Component)component, panel, paramObject, gridy, 1.0, 2, isAbove);
                        break;
                    }
                    case CONTRACT: {
                        component = new BGControlPanelContractSelect(false, true);
                        gridy = this.addComponent(key, (Component)component, panel, paramObject, gridy, 1.0, 2, isAbove);
                        break;
                    }
                    case COMBOX: {
                        component = new BGComboBox();
                        gridy = this.addComponent(key, (Component)component, panel, paramObject, gridy, 1.0, 1, isAbove);
                        break;
                    }
                    case TEXTAREA: {
                        component = new JTextArea(2, 10);
                        ((JTextArea)component).setMargin(new Insets(3, 3, 3, 3));
                        gridy = this.addComponent(key, (Component)component, panel, paramObject, gridy, isAbove);
                        break;
                    }
                    case LIST: {
                        component = new JList();
                        ((JList)component).setSelectionMode(0);
                        gridy = this.addComponent(key, (Component)component, panel, paramObject, gridy, isAbove);
                        break;
                    }
                    case TABLE: {
                        component = new BGUTable(null);
                        gridy = this.addComponent(key, (Component)component, panel, paramObject, gridy, isAbove);
                        break;
                    }
                    case LINK: {
                        component = new LinkLabel("<html><u>" + value + "</u></html>", value, comment);
                        gridy = this.addComponent(key, (Component)component, panel, paramObject, gridy, 1.0, 2, isAbove);
                        break;
                    }
                    case LABEL: {
                        component = new JLabel();
                        gridy = this.addComponent(key, (Component)component, panel, paramObject, gridy, 1.0, 2, isAbove);
                        break;
                    }
                }
                if (component == null) continue;
                component.addFocusListener(messageAdapter);
            }
        }
        panel.add(Box.createGlue(), new GridBagConstraints(0, gridy, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        return scrollPane;
    }

    private int addComponent(String key, Component component, JPanel panel, JSONObject paramObject, int gridy, boolean isAbove) {
        component.setName(key);
        this.componentMap.put(component.getName(), component);
        JScrollPane scrollPane = new JScrollPane(component);
        scrollPane.setMinimumSize(component.getMinimumSize());
        int gridY = isAbove ? gridy++ : gridy;
        panel.add((Component)new JLabel(paramObject.optString("title")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, isAbove ? 5 : 10, isAbove ? 0 : 5, 5), 0, 0));
        int gridX = isAbove ? 0 : 1;
        panel.add((Component)scrollPane, new GridBagConstraints(gridX, gridy++, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 10), 0, 0));
        return gridy;
    }

    private int addComponent(String key, Component component, JPanel panel, JSONObject paramObject, int gridy, double weightx, int fill, boolean isAbove) {
        component.setName(key);
        this.componentMap.put(component.getName(), component);
        int gridY = isAbove ? gridy++ : gridy;
        panel.add((Component)new JLabel(paramObject.optString("title")), new GridBagConstraints(0, gridY, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, isAbove ? 5 : 10, isAbove ? 0 : 5, 5), 0, 0));
        int gridX = isAbove ? 0 : 1;
        panel.add(component, new GridBagConstraints(gridX, gridy++, 1, 1, weightx, 0.0, 17, fill, new Insets(0, 5, 5, 10), 0, 0));
        return gridy;
    }

    private FieldLabelLayout defineLayout(JSONObject options) {
        FieldLabelLayout labelLayout = FieldLabelLayout.defineLayout(options.optString("windowLayout"));
        return Objects.requireNonNullElse(labelLayout, FieldLabelLayout.LEFT);
    }

    private JPanel getButtonPanel() {
        ActionListener buttonActionListener = e -> this.doButton(e.getActionCommand());
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 5, 0));
        this.showButton("1", buttonPanel, buttonActionListener);
        this.showButton("2", buttonPanel, buttonActionListener);
        this.showButton("3", buttonPanel, buttonActionListener);
        this.showButton("4", buttonPanel, buttonActionListener);
        this.showButton("Cancel", buttonPanel, e -> {
            this.setVisible(false);
            this.dispose();
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)buttonPanel, "Center");
        return panel;
    }

    private void showButton(String key, JPanel panel, ActionListener buttonActionListener) {
        if (this.options.optBoolean("windowShowButton" + key, false)) {
            AssistantButton assistantButton = AssistantButton.getAssistantButtonByCode((String)("button" + key));
            JButton button = new JButton(this.options.optString("windowTextButton" + key, assistantButton.getTitle()));
            button.setActionCommand(assistantButton.getCode());
            button.addActionListener(buttonActionListener);
            panel.add(button);
        }
    }

    private void doButton(String button) {
        try {
            String status;
            JSONObject formData = this.getFormData();
            String resultOfPressButton = this.getAssistantService().doButton(this.actionId, formData.toString(), button);
            JSONObject resultJsonObject = new JSONObject(resultOfPressButton);
            JSONObject fieldsOfResponse = resultJsonObject.optJSONObject("fields");
            if (fieldsOfResponse != null) {
                JSONObject fieldsOfFromData = formData.optJSONObject("fields");
                if (fieldsOfFromData != null) {
                    for (String key : fieldsOfResponse.keySet()) {
                        fieldsOfFromData.put(key, fieldsOfResponse.get(key));
                    }
                }
                formData.put("fields", (Object)fieldsOfFromData);
            }
            if ("error".equals(status = resultJsonObject.optString("status"))) {
                ClientUtils.showMessageDialog((Object)resultJsonObject.optString("error"), (String)resultJsonObject.optString("errorTitle", "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435"));
            } else if ("ok".equals(status)) {
                int openContractId;
                String nextActionId = resultJsonObject.optString("nextActionId");
                if (Utils.notBlankString((String)nextActionId)) {
                    AssistantActionDialog assistantActionDialog = new AssistantActionDialog(nextActionId, this.getContext());
                    assistantActionDialog.setVisible(true);
                    assistantActionDialog.showAction(formData.toString());
                }
                if (fieldsOfResponse != null && (openContractId = Utils.parseInt((String)fieldsOfResponse.optString("openContract"), (int)-1)) > 0) {
                    BGClientBase.getFrame().getTabbedPane().addContractEditorTab(openContractId);
                }
                this.setVisible(false);
                this.dispose();
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void showAction(String formData) throws BGException {
        String windowSizeMode;
        JSONObject showData;
        JSONObject fieldsJsonObject;
        if (formData == null) {
            JSONObject data = new JSONObject();
            data.put("contractId", this.getContext().getContractId());
            formData = data.toString();
        }
        if ((fieldsJsonObject = (showData = new JSONObject(this.getAssistantService().doShow(this.actionId, formData))).optJSONObject("fieldValues")) != null) {
            for (String key : this.hiddenFileld.keySet()) {
                if (!fieldsJsonObject.has(key)) continue;
                this.hiddenFileld.put(key, fieldsJsonObject.optString(key));
            }
            for (String elementKey : this.componentMap.keySet()) {
                JSONObject json;
                JSONArray array;
                if (!fieldsJsonObject.has(elementKey)) continue;
                Component component = this.componentMap.get(elementKey);
                if (component instanceof BGControlPanelDateNoB) {
                    BGControlPanelDateNoB date = (BGControlPanelDateNoB)component;
                    array = fieldsJsonObject.optJSONArray(elementKey);
                    if (array == null) continue;
                    for (int index = 0; index < array.length(); ++index) {
                        JSONObject item = array.getJSONObject(index);
                        if (!"date".equals(item.optString("key"))) continue;
                        date.setLocalDate(TimeUtils.parseLocalDate((String)item.optString("value")));
                    }
                    continue;
                }
                if (component instanceof JTextArea) {
                    JTextArea textArea = (JTextArea)component;
                    array = fieldsJsonObject.optJSONArray(elementKey);
                    if (array == null || array.length() <= 0) continue;
                    JSONObject item = array.getJSONObject(0);
                    textArea.setText(item.optString("value", ""));
                    continue;
                }
                if (component instanceof JTextField) {
                    JTextField textField = (JTextField)component;
                    array = fieldsJsonObject.optJSONArray(elementKey);
                    if (array == null || array.length() <= 0) continue;
                    JSONObject item = array.getJSONObject(0);
                    textField.setText(item.optString("value", ""));
                    continue;
                }
                if (component instanceof LinkLabel) {
                    LinkLabel linkLabel = (LinkLabel)component;
                    JSONObject json2 = fieldsJsonObject.optJSONObject(elementKey);
                    if (json2 == null) continue;
                    linkLabel.setText(json2.optString("text", ""));
                    linkLabel.setUri(json2.optString("uri", "https://bgbilling.ru/"));
                    continue;
                }
                if (component instanceof JLabel) {
                    JLabel label = (JLabel)component;
                    array = fieldsJsonObject.optJSONArray(elementKey);
                    if (array == null || array.length() <= 0) continue;
                    JSONObject item = array.getJSONObject(0);
                    label.setText(item.optString("value", ""));
                    continue;
                }
                if (component instanceof BGControlPanelPeriodNoB) {
                    BGControlPanelPeriodNoB period = (BGControlPanelPeriodNoB)component;
                    array = fieldsJsonObject.optJSONArray(elementKey);
                    if (array == null) continue;
                    for (int index = 0; index < array.length(); ++index) {
                        JSONObject item = array.getJSONObject(index);
                        if ("dateFrom".equals(item.optString("key"))) {
                            period.setDateFrom(TimeUtils.parseDate((String)item.optString("value"), (String)"dd.MM.yyyy"));
                            continue;
                        }
                        if (!"dateTo".equals(item.optString("key"))) continue;
                        period.setDateTo(TimeUtils.parseDate((String)item.optString("value"), (String)"dd.MM.yyyy"));
                    }
                    continue;
                }
                if (component instanceof BGComboBox) {
                    BGComboBox bgComboBox = (BGComboBox)component;
                    array = fieldsJsonObject.optJSONArray(elementKey);
                    if (array == null) continue;
                    for (int index = 0; index < array.length(); ++index) {
                        JSONObject item = array.getJSONObject(index);
                        bgComboBox.addItem((Object)new AssistantKeyValue(item.optString("key"), item.optString("value")));
                    }
                    bgComboBox.setSelectedIndex(-1);
                    continue;
                }
                if (component instanceof JList) {
                    JList list = (JList)component;
                    array = fieldsJsonObject.optJSONArray(elementKey);
                    if (array == null) continue;
                    DefaultListModel<AssistantKeyValue> model = new DefaultListModel<AssistantKeyValue>();
                    for (int index = 0; index < array.length(); ++index) {
                        JSONObject item = array.getJSONObject(index);
                        model.addElement(new AssistantKeyValue(item.optString("key"), item.optString("value")));
                    }
                    list.setModel(model);
                    list.setSelectedIndex(-1);
                    continue;
                }
                if (component instanceof BGUTable) {
                    this.buildTable((BGUTable)component, fieldsJsonObject, elementKey);
                    continue;
                }
                if (component instanceof JCheckBox) {
                    JSONObject json3;
                    String value = "false";
                    array = fieldsJsonObject.optJSONArray(elementKey);
                    if (array != null && (json3 = array.optJSONObject(0)) != null) {
                        value = json3.optString("value");
                    }
                    if ("".equals(value)) {
                        value = fieldsJsonObject.optString(elementKey);
                    }
                    ((JCheckBox)component).setSelected("true".equals(value));
                    continue;
                }
                if (!(component instanceof BGControlPanelContractSelect) || (json = fieldsJsonObject.optJSONObject(elementKey)) == null) continue;
                ((BGControlPanelContractSelect)component).setContracts(json.optString("contractIds"), json.optString("title"));
            }
        }
        if ("\u0430\u0432\u0442\u043e".equals(windowSizeMode = this.options.optString("windowSizeMode"))) {
            this.pack();
            this.moveWindowToCenterScreen();
        }
    }

    private void buildTable(final BGUTable table, JSONObject fieldsJsonObject, String elementKey) {
        table.setSelectionMode(2);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setVisibilityChecker((VisibilityChecker)VisibilityChecker.Std.defaultInstance().withFieldVisibility(JsonAutoDetect.Visibility.ANY));
        JSONArray array = fieldsJsonObject.optJSONArray(elementKey);
        String loadedClass = array.getJSONObject(0).getString("key");
        String filterList = array.getJSONObject(0).getString("value");
        Class customFilterClass = null;
        try {
            String packagePath = loadedClass.substring(0, loadedClass.lastIndexOf("."));
            customFilterClass = new ClientDynLoader(this.getContext(), packagePath).loadClass(loadedClass, true);
            if (customFilterClass.getSuperclass() != FilterTableModel.class) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043a\u043b\u0430\u0441\u0441 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u043d\u0430\u0441\u043b\u0435\u0434\u043d\u0438\u043a\u043e\u043c FilterTableModel!");
            }
        }
        catch (ClassNotFoundException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        StringReader reader = new StringReader(filterList);
        try {
            CollectionType type = objectMapper.getTypeFactory().constructCollectionType(List.class, customFilterClass);
            List filterTableModelList = (List)objectMapper.readValue((Reader)reader, (JavaType)type);
            final BGTableModel<FilterTableModel> tableModel = this.buildTableModel(filterTableModelList);
            final JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem selectRowItem = new JMenuItem("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0435\u0433\u043e \u041c\u0430\u0441\u0442\u0435\u0440\u0430");
            popupMenu.add(selectRowItem);
            selectRowItem.addActionListener(e -> {
                this.tableSelectedRows = new ArrayList<JSONObject>();
                tableModel.getSelectedRows().forEach(row -> {
                    FilterTableModel selectedRow = row;
                    this.tableSelectedRows.add(new JSONObject((Object)selectedRow));
                });
            });
            table.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        for (int i = 0; i < table.getModel().getColumnCount(); ++i) {
                            int id;
                            String columnTitle = tableModel.getColumnName(i).toLowerCase();
                            if (!columnTitle.equals("contractid") && !columnTitle.equals("idcontract") && !columnTitle.equals("cid") && !columnTitle.equals("id \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430") || (id = ((Integer)tableModel.getValueAt(table.getSelectedRow(), i)).intValue()) <= 0) continue;
                            ContractService contractService = (ContractService)AssistantActionDialog.this.getContext().getPort(ContractService.class);
                            try {
                                Contract contract = contractService.contractGet(id);
                                if (contract == null || contract.getId() <= 0) continue;
                                BGClientBase.getFrame().getTabbedPane().addContractEditorTab(contract.getId());
                                break;
                            }
                            catch (BGException ex) {
                                ClientUtils.showErrorMessageDialog((Throwable)ex);
                            }
                        }
                    } else if (e.getClickCount() == 1 && e.getButton() == 3 && tableModel.getSelectedRow() != null) {
                        popupMenu.show((Component)table, e.getX(), e.getY());
                    }
                }
            });
            table.setModel(tableModel);
            tableModel.setData(filterTableModelList);
        }
        catch (IOException e2) {
            ClientUtils.showErrorMessageDialog((Throwable)e2);
        }
    }

    private BGTableModel<FilterTableModel> buildTableModel(final List<FilterTableModel> filterTableModelList) {
        return new BGTableModel<FilterTableModel>("filterTableModel"){

            protected void initColumns() {
                if (filterTableModelList != null && filterTableModelList.size() > 0) {
                    Field[] fields = ((FilterTableModel)filterTableModelList.get(0)).getClass().getDeclaredFields();
                    for (int x = 0; x < fields.length; ++x) {
                        Field field = fields[x];
                        String correctTitleColumn = ((FilterTableModel)filterTableModelList.get(0)).getCorrectTitleColumn(x);
                        if (correctTitleColumn == null) {
                            correctTitleColumn = field.getName();
                        }
                        this.addColumn(correctTitleColumn, field.getType(), false);
                    }
                }
            }

            public Object getValue(FilterTableModel val, int columnId) throws BGException {
                try {
                    Object data;
                    try {
                        Method correctDataMethod = val.getClass().getDeclaredMethod("getCorrectData", Integer.TYPE);
                        data = correctDataMethod.invoke((Object)val, columnId);
                        if (data != null) {
                            return data.toString();
                        }
                    }
                    catch (NoSuchMethodException | InvocationTargetException e) {
                        ClientUtils.showErrorMessageDialog((Throwable)e);
                    }
                    Field[] fields = val.getClass().getDeclaredFields();
                    Field field = fields[columnId];
                    field.setAccessible(true);
                    data = field.get(val);
                    if (data != null) {
                        return field.get(val);
                    }
                }
                catch (IllegalAccessException e) {
                    ClientUtils.showErrorMessageDialog((String)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u043a\u043e\u043b\u043e\u043d\u043a\u0438 " + columnId + " \u041e\u0448\u0438\u0431\u043a\u0430: " + e));
                }
                return super.getValue((Object)val, columnId);
            }
        };
    }

    private JSONObject getFormData() {
        JSONObject fieldsData = new JSONObject();
        for (String key : this.componentMap.keySet()) {
            AssistantKeyValue assistantKeyValue;
            Component component = this.componentMap.get(key);
            if (component instanceof JTextField) {
                fieldsData.put(key, (Object)((JTextField)component).getText());
                continue;
            }
            if (component instanceof JTextArea) {
                fieldsData.put(key, (Object)((JTextArea)component).getText());
                continue;
            }
            if (component instanceof JCheckBox) {
                fieldsData.put(key, ((JCheckBox)component).isSelected());
                continue;
            }
            if (component instanceof BGControlPanelContractSelect) {
                fieldsData.put(key, (Object)((BGControlPanelContractSelect)component).getContracts());
                continue;
            }
            if (component instanceof BGControlPanelDateNoB) {
                LocalDate date = ((BGControlPanelDateNoB)component).getLocalDate();
                fieldsData.put(key, (Object)(date == null ? "" : date.toString()));
                continue;
            }
            if (component instanceof BGControlPanelPeriodNoB) {
                Period period = ((BGControlPanelPeriodNoB)component).getPeriod();
                JSONObject periodJsonObject = new JSONObject();
                if (period.getLocalDateFrom() != null) {
                    periodJsonObject.put("from", (Object)period.getLocalDateFrom().toString());
                }
                if (period.getLocalDateTo() != null) {
                    periodJsonObject.put("to", (Object)period.getLocalDateTo().toString());
                }
                fieldsData.put(key, (Object)periodJsonObject);
                continue;
            }
            if (component instanceof JList) {
                assistantKeyValue = (AssistantKeyValue)((JList)component).getSelectedValue();
                if (assistantKeyValue == null) continue;
                fieldsData.put(key, (Object)assistantKeyValue.getKey());
                continue;
            }
            if (component instanceof BGComboBox) {
                assistantKeyValue = (AssistantKeyValue)((BGComboBox)component).getSelectedItem();
                if (assistantKeyValue == null) continue;
                fieldsData.put(key, (Object)assistantKeyValue.getKey());
                continue;
            }
            if (!(component instanceof BGUTable) || this.tableSelectedRows == null) continue;
            fieldsData.put(key, this.tableSelectedRows);
        }
        for (String hiddenKey : this.hiddenFileld.keySet()) {
            fieldsData.put(hiddenKey, (Object)this.hiddenFileld.get(hiddenKey));
        }
        JSONObject formData = new JSONObject();
        formData.put("fields", (Object)fieldsData);
        formData.put("contractId", this.getContext().getContractId());
        return formData;
    }

    static enum FieldLabelLayout {
        LEFT("\u0418\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u043b\u0435\u0432\u0430 \u043e\u0442 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432"),
        ABOVE("\u0418\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u0434 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430\u043c\u0438");

        String description;

        private FieldLabelLayout(String description) {
            this.description = description;
        }

        static FieldLabelLayout defineLayout(String desc) {
            for (FieldLabelLayout labelLayout : FieldLabelLayout.values()) {
                if (!labelLayout.description.equals(desc)) continue;
                return labelLayout;
            }
            return null;
        }
    }

    class DigitDocumentFilter
    extends DocumentFilter {
        private boolean isInteger = false;

        public DigitDocumentFilter(boolean isInteger) {
            this.isInteger = isInteger;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            String newString = fb.getDocument().getText(0, offset) + string + fb.getDocument().getText(offset, fb.getDocument().getLength());
            if (newString.matches(this.isInteger ? "^\\d*$" : "^\\d*|\\d+\\.?\\d*$")) {
                fb.insertString(offset, string, attr);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attr) throws BadLocationException {
            String newString = fb.getDocument().getText(0, offset) + string + (length == 0 ? "" : fb.getDocument().getText(offset + length, fb.getDocument().getLength()));
            if (newString.matches(this.isInteger ? "^\\d*$" : "^\\d*|\\d+\\.?\\d*$")) {
                fb.insertString(offset, string, attr);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    class LinkLabel
    extends JLabel {
        private String uri;

        public LinkLabel(String text, final String uri, String toolTipText) {
            super(text);
            this.uri = uri == null ? "https://bgbilling.ru/" : uri;
            this.setToolTipText(toolTipText);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().browse(new URI(uri));
                        }
                        catch (Exception e) {
                            ClientUtils.showErrorMessageDialog((Throwable)e);
                        }
                    }
                }
            });
        }

        public void setUri(String uri) {
            this.uri = uri;
        }
    }
}

