/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.client.admin;

import bitel.billing.module.common.BGControlPanelListSelect;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserGroupService;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.plugins.assistant.client.admin.AssistantMastersTab;
import ru.bitel.bgbilling.plugins.assistant.client.admin.ParameterEditor;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantFieldType;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.GuiTitlable;

public class EditorPanel
extends BGUPanel {
    private final Dimension dimension = new Dimension(100, 10);
    private JTabbedPane tabbedPane = null;
    private JTextArea actionComment = null;
    private ParameterEditor parameterEditor = null;
    private AssistantAction assistantAction = null;
    private BGTextField titleField = new BGTextField();
    private BGTextField actionIdField = new BGTextField();
    private ParameterTableModel tableModel = new ParameterTableModel(ParameterTableModel.class.getName());
    private BGButtonPanelOkCancel buttonPanel = new BGButtonPanelOkCancel();
    private BGControlPanelListSelect userGroupList = new BGControlPanelListSelect(5);
    private DynamicClassChooser chooser = new DynamicClassChooser(false, 2);
    private JCheckBox dependentBox = new JCheckBox();
    private AssistantMastersTab parent;

    public EditorPanel(AssistantMastersTab parent) {
        this.parent = parent;
    }

    protected void jbInit() throws Exception {
        this.buttonPanel.addActionListener(e -> {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals("ok")) {
                this.doSave();
            } else if (actionCommand.equals("cancel")) {
                this.assistantAction = null;
                this.setVisible(false);
            }
            this.parameterEditor.table.clearSelection();
            this.parent.actionList.setEnabled(true);
        });
        int gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.add(this.getActionIdPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 5, 5, 5), 0, 0));
        this.add(this.getCheckBoxPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.getTitlePanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.getFieldPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.getClassDialogPanel(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, gridy, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getActionIdPanel() {
        JLabel label = new JLabel("Action ID (#): ");
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)label, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.actionIdField, new GridBagConstraints(gridx, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getCheckBoxPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel infoLabel = new JLabel("(\u0435\u0441\u043b\u0438 \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u043a\u0430\u043a \u043d\u0435 \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043e\u043a\u043d\u043e \u041c\u0430\u0441\u0442\u0435\u0440\u0430)");
        infoLabel.setFont(new Font("SansSerif", 2, 12));
        panel.add((Component)new JLabel("\u0414\u043e\u0447\u0435\u0440\u043d\u0438\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.dependentBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)infoLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTitlePanel() {
        JLabel label = new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: ");
        label.setMinimumSize(this.dimension);
        label.setPreferredSize(this.dimension);
        int gridx = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)label, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.titleField, new GridBagConstraints(gridx, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getFieldPanel() {
        final BGUTable table = new BGUTable((TableModel)((Object)this.tableModel));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ParameterRow parameterRow = (ParameterRow)EditorPanel.this.tableModel.getSelectedRow();
                if (mouseEvent.getClickCount() == 2 && parameterRow != null) {
                    EditorPanel.this.editParameterRow(parameterRow, table);
                }
            }
        });
        BGDialogToolBar dialogToolBar = new BGDialogToolBar();
        dialogToolBar.setDefaultButtons(e -> this.doParameterCommand(e.getActionCommand(), table));
        dialogToolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem", "upItem", "downItem"});
        dialogToolBar.setFloatable(false);
        dialogToolBar.setOrientation(0);
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(new Dimension(100, 200));
        panel.add((Component)new JLabel("\u041f\u043e\u043b\u044f: "), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)dialogToolBar, new GridBagConstraints(1, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, gridy, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getClassDialogPanel() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add((Component)this.getCommentPanel(), "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
        this.tabbedPane.add((Component)this.getClassPanel(), "\u041a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430");
        this.tabbedPane.add((Component)this.getUserGroupPanel(), "\u0413\u0440\u0443\u043f\u043f\u044b \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439");
        JPanel panelWithParametersTable = new JPanel(new GridLayout(1, 2, 15, 5));
        panelWithParametersTable.setMinimumSize(new Dimension(100, 400));
        panelWithParametersTable.add(this.tabbedPane);
        panelWithParametersTable.add(this.getParamDialogPanel());
        return panelWithParametersTable;
    }

    private JPanel getUserGroupPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.userGroupList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getCommentPanel() {
        this.actionComment = new JTextArea();
        this.actionComment.setMargin(new Insets(3, 3, 3, 3));
        this.actionComment.setWrapStyleWord(true);
        this.actionComment.setLineWrap(true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.actionComment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getParamDialogPanel() {
        JSONArray config;
        try {
            InputStream inputStream = EditorPanel.class.getResourceAsStream("config.json");
            config = new JSONArray(new String(Utils.readByBlock((InputStream)inputStream), StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            config = new JSONArray();
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        this.parameterEditor = new ParameterEditor(config);
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b: "), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.parameterEditor, new GridBagConstraints(0, gridy, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void doSave() {
        if (Utils.isBlankString((String)this.actionIdField.getText())) {
            ClientUtils.showMessageDialog((Object)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 ActionId!");
            return;
        }
        if (Utils.isBlankString((String)this.titleField.getText())) {
            ClientUtils.showMessageDialog((Object)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043c\u0430\u0441\u0442\u0435\u0440\u0430!");
            return;
        }
        this.assistantAction.setTitle(this.titleField.getText());
        this.assistantAction.setActionId(this.actionIdField.getText());
        this.assistantAction.setActionClass(this.chooser.getSelectedClass());
        JSONObject config = new JSONObject();
        JSONArray params = new JSONArray();
        for (ParameterRow parameterRow : this.tableModel.getRows()) {
            JSONObject param = new JSONObject();
            param.put("key", (Object)parameterRow.key);
            param.put("type", (Object)parameterRow.type);
            param.put("title", (Object)parameterRow.title);
            param.put("value", (Object)parameterRow.value);
            param.put("comment", (Object)parameterRow.comment);
            params.put((Object)param);
        }
        config.put("params", (Object)params);
        config.put("options", (Object)this.parameterEditor.getOptions());
        config.put("comment", (Object)this.actionComment.getText());
        this.assistantAction.setConfig(config.toString());
        this.assistantAction.setUserGroupIds(this.userGroupList.getListIds());
        this.assistantAction.setDependent(this.dependentBox.isSelected() ? 1 : 0);
        this.setVisible(false);
    }

    private void editParameterRow(ParameterRow parameterRow, BGUTable table) {
        String value = parameterRow.getKey();
        BGTextField keyField = new BGTextField(15);
        keyField.setHorizontalAlignment(2);
        keyField.setEditable(value == null);
        keyField.setText(value != null ? value : "");
        value = parameterRow.getTitle();
        BGTextField titleField = new BGTextField(40);
        titleField.setHorizontalAlignment(2);
        titleField.setText(value != null ? value : "");
        value = parameterRow.getValue();
        BGTextField valueField = new BGTextField(40);
        valueField.setHorizontalAlignment(2);
        valueField.setText(value != null ? value : "");
        value = parameterRow.getComment();
        BGTextField commentField = new BGTextField(40);
        commentField.setHorizontalAlignment(2);
        commentField.setText(value != null ? value : "");
        value = parameterRow.getType();
        BGUComboBox typesComboBox = new BGUComboBox();
        typesComboBox.setData(Stream.of(AssistantFieldType.values()).map(a -> new KeyValue(a.getCode(), a.getTitle())).collect(Collectors.toList()));
        for (int index = 0; index < typesComboBox.getItemCount(); ++index) {
            KeyValue keyValue = (KeyValue)typesComboBox.getItemAt(index);
            if (!keyValue.key.equals(value)) continue;
            typesComboBox.setSelectedIndex(index);
            break;
        }
        int gridy = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041a\u043b\u044e\u0447:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)keyField, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0422\u0438\u043f:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)typesComboBox, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)titleField, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)valueField, new GridBagConstraints(1, gridy++, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, gridy, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
        panel.add((Component)commentField, new GridBagConstraints(1, gridy, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        int optionId = JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), panel, "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 2);
        if (optionId == 0) {
            if (Utils.isBlankString((String)keyField.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u0434\u0430\u0442\u044c \u043a\u043b\u044e\u0447 \u0434\u043b\u044f \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u0430!");
                return;
            }
            parameterRow.setType(((KeyValue)typesComboBox.getSelectedItem()).key);
            parameterRow.setTitle(titleField.getText());
            parameterRow.setValue(valueField.getText());
            parameterRow.setComment(commentField.getText());
            if (keyField.isEditable()) {
                parameterRow.setKey(keyField.getText());
                this.tableModel.addRow(parameterRow);
            }
        }
        table.repaint();
    }

    private void doParameterCommand(String actionCommand, BGUTable table) {
        ParameterRow parameterRow = (ParameterRow)this.tableModel.getSelectedRow();
        switch (actionCommand) {
            case "newItem": {
                this.editParameterRow(new ParameterRow(), table);
                break;
            }
            case "editItem": {
                this.editParameterRow(parameterRow, table);
                break;
            }
            case "deleteItem": {
                if (parameterRow == null) break;
                this.tableModel.deleteSelectedRows();
                table.repaint();
                break;
            }
            case "upItem": {
                if (parameterRow == null) break;
                this.tableModel.upSelectedRow();
                table.repaint();
                break;
            }
            case "downItem": {
                if (parameterRow == null) break;
                this.tableModel.downSelectedRow();
                table.repaint();
                break;
            }
        }
    }

    public AssistantAction getAssistantAction() {
        return this.assistantAction;
    }

    public void setAssistantAction(AssistantAction assistantAction, String ifaceName, String superclassName) {
        this.assistantAction = assistantAction;
        this.dependentBox.setSelected(assistantAction.getDependent() != 0);
        this.tabbedPane.setSelectedIndex(0);
        this.titleField.setText(assistantAction.getTitle());
        this.actionIdField.setText(assistantAction.getActionId());
        this.chooser.setNewClass(false);
        this.chooser.setIfaceName(ifaceName);
        this.chooser.setSuperclassName(superclassName);
        this.chooser.performAction("refresh");
        this.chooser.setSelectedItem(assistantAction.getActionClass());
        try {
            ClientUtils.buildList((JList)this.userGroupList.getList(), (List)((UserGroupService)((ClientContext)this.getContext()).getPort(UserGroupService.class)).getUserGroupList(false));
            ClientUtils.setListSelection((JList)this.userGroupList.getList(), (List)assistantAction.getUserGroupIds());
        }
        catch (BGException e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        this.tableModel.deleteRows();
        String configStr = assistantAction.getConfig();
        JSONObject config = new JSONObject(Utils.isEmptyString((String)configStr) ? "{}" : configStr);
        JSONArray params = config.optJSONArray("params");
        if (params != null) {
            int size = params.length();
            for (int index = 0; index < size; ++index) {
                JSONObject param = params.getJSONObject(index);
                ParameterRow parameterRow = new ParameterRow();
                parameterRow.setKey(param.optString("key"));
                parameterRow.setTitle(param.optString("title"));
                parameterRow.setType(param.optString("type"));
                parameterRow.setValue(param.optString("value"));
                parameterRow.setComment(param.optString("comment"));
                this.tableModel.addRow(parameterRow);
            }
        }
        this.actionComment.setText(config.optString("comment", ""));
        this.parameterEditor.setData(config.optJSONObject("options"));
    }

    private JPanel getClassPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)new JLabel("\u0421\u043e\u0437\u0434\u0430\u0442\u044c/\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430: "), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.chooser, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 0, 5), 0, 0));
        return panel;
    }

    private static class ParameterTableModel
    extends BGTableModel<ParameterRow> {
        public ParameterTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043b\u044e\u0447", 150, 150, 150, "key", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f", 100, 100, 100, "type", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 200, -1, -1, "title", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 200, -1, -1, "value", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 200, -1, -1, "comment", true).setTableCellRenderer((TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public static class ParameterRow {
        private String key = null;
        private String title = null;
        private String type = null;
        private String value = null;
        private String comment = null;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }

    public static class KeyValue
    implements GuiTitlable {
        String key;
        String value;

        public KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getGuiTitle() {
            return this.value;
        }
    }
}

