/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.modules.bill.common.bean.BillDocument;
import ru.bitel.bgbilling.modules.bill.server.bean.AbstractBillDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.model.Page;

public class BillDocumentDao
extends AbstractBillDao {
    public static final String BILL_DATA_FIELDS = "bill_data.format_number, bill_data.number, bill_data.number_in_month, bill_data.number_in_year, bill_data.id, bill_data.payment_id, bill_data.account_id, bill_data.cid, bill_data.npid, bill_data.type, bill_data.status, bill_data.unload_status, bill_data.uid, bill_data.yy, bill_data.mm, bill_data.create_dt, bill_data.pay_dt, bill_data.pay_uid, bill_data.summ";

    public BillDocumentDao(Setup setup, ParameterMap moduleSetup, Connection con, int moduleId) {
        super(setup, moduleSetup, con, moduleId, "bill_data_" + moduleId);
    }

    public static <B> List<B> getBillDocumentList(Connection con, int moduleId, String table, int contractId, Page page, Function<ResultSet, B> converter) {
        ArrayList<B> result = new ArrayList<B>();
        try {
            String query = "SELECT SQL_CALC_FOUND_ROWS " + BILL_DATA_FIELDS + ", type.title FROM " + table + " AS bill_data LEFT JOIN bill_doc_type_" + moduleId + " AS type ON bill_data.type=type.id WHERE bill_data.cid=? ORDER BY yy DESC, mm DESC, number DESC LIMIT ?, ?";
            PreparedStatement ps = con.prepareStatement(query, 1);
            ps.setInt(1, contractId);
            ps.setInt(2, page.getPageFirstRecordNumber());
            ps.setInt(3, page.getPageSize());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(converter.apply(rs));
            }
            rs.close();
            ps.close();
            page.setRecordCount(ServerUtils.foundRows((Connection)con));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<BillDocument> list(int contractId, Page page) throws BGException {
        try {
            return BillDocumentDao.getBillDocumentList(this.con, this.moduleId, this.tableName, contractId, page, rs -> {
                try {
                    return BillDocumentDao.getBillDocumentFromRS(rs, false, true);
                }
                catch (SQLException ex) {
                    throw new BGRuntimeException((Throwable)ex);
                }
            });
        }
        catch (BGRuntimeException ex) {
            Throwable t = ex;
            if (t.getCause() instanceof SQLException) {
                t = ex.getCause();
            }
            throw new BGException(t);
        }
    }

    private static BillDocument getBillDocumentFromRS(ResultSet rs, boolean loadContract, boolean loadType) throws SQLException {
        BillDocument bill = new BillDocument();
        bill.setNumberFormatted(rs.getString("format_number"));
        bill.setNumber(rs.getInt("number"));
        bill.setNumberInMonth(rs.getInt("number_in_month"));
        bill.setNumberInYear(rs.getInt("number_in_year"));
        bill.setId(rs.getInt("id"));
        bill.setPaymentId(rs.getInt("payment_id"));
        bill.setBankAccountId(rs.getInt("account_id"));
        bill.setContractId(rs.getInt("cid"));
        bill.setDocumentSpecId(rs.getInt("type"));
        if (loadContract) {
            bill.setContractTitle(rs.getString("contract.title"));
            bill.setContractComment(rs.getString("contract.comment"));
        }
        if (loadType) {
            bill.setDocumentSpecTitle(rs.getString("type.title"));
        }
        bill.setStatus(rs.getInt("status"));
        bill.setUnloadStatus(rs.getInt("unload_status"));
        bill.setUserId(rs.getInt("uid"));
        bill.setYear(rs.getInt("yy"));
        bill.setMonth(rs.getInt("mm"));
        bill.setDateCreated((Date)rs.getDate("create_dt"));
        bill.setPaymentDate((Date)rs.getDate("pay_dt"));
        bill.setPaymentUserId(rs.getInt("pay_uid"));
        bill.setTotal(rs.getBigDecimal("summ"));
        return bill;
    }
}

