/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGSelectFilePanel;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.bill.client.BillDoc;
import ru.bitel.bgbilling.modules.bill.client.ServiceConfigBillViewer;
import ru.bitel.bgbilling.modules.bill.client.bean.BGBillTablePos;
import ru.bitel.bgbilling.modules.bill.client.bean.BillPositionsEditor;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;

public abstract class BillServiceConfigTabbedPanel
extends ServiceConfigTabbedPanel {
    private String mode;
    protected BGTableModel<Element> tableModel;
    protected JLabel countLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432: 0, \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 0.00");
    protected String separator = ",";
    protected String typeBill = "bill";
    protected String currentId;
    protected BillPositionsEditor positionsEditor;
    protected List<BGBillTablePos> positionList = null;
    protected BGComboBox<ComboBoxItem> packageCb = new BGComboBox();
    protected BGComboBox<ComboBoxItem> sortModeCb = new BGComboBox();
    protected BGComboBox<ComboBoxItem> secondarySortModeCb = new BGComboBox();
    protected JPanel saveRegister = new JPanel(new GridBagLayout());
    protected BGSelectFilePanel selectFile = new BGSelectFilePanel(true);
    protected CardLayout cardLayout = new CardLayout();
    protected JPanel cardPanel = new JPanel(this.cardLayout);
    protected ServiceConfigBillViewer viewer = new ServiceConfigBillViewer(true);

    public BillServiceConfigTabbedPanel(String mode) {
        this.mode = mode;
        this.viewer.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("toList".equals(propertyChangeEvent.getPropertyName())) {
                    BillServiceConfigTabbedPanel.this.showCardPanel("table");
                }
            }
        });
        final JCheckBox saveOnServer = new JCheckBox("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0435");
        saveOnServer.setSelected(false);
        this.selectFile.setFileFilter("csv", "CSV");
        BGButton saveButton = new BGButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", "save", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = BillServiceConfigTabbedPanel.this.selectFile.getSelectedFile();
                if (!saveOnServer.isSelected() && file == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
                    return;
                }
                try {
                    Request request = BillServiceConfigTabbedPanel.this.getRequest();
                    request.setAttribute("forRegister", "1");
                    request.setAction("bill".equals(BillServiceConfigTabbedPanel.this.typeBill) ? "PreemptBill" : "PreemptInvoice");
                    request.setAttribute("saveOnServer", saveOnServer.isSelected());
                    Document doc = BillServiceConfigTabbedPanel.this.getDocument(request);
                    if (ClientUtils.checkStatus((Document)doc)) {
                        if (!saveOnServer.isSelected()) {
                            if (XMLUtils.selectElement((Node)doc, (String)"/data/data") == null) {
                                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0420\u0435\u0435\u0441\u0442\u0440 \u041d\u0415 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d");
                                return;
                            }
                            Element data = XMLUtils.selectElement((Node)doc, (String)"/data/data");
                            String csv = XMLUtils.getAttribute((Element)data, (String)"file");
                            ClientUtils.saveTextFile((String)csv, (File)file, (String)".csv");
                        }
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0420\u0435\u0435\u0441\u0442\u0440 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d");
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f " + ex.getLocalizedMessage(), "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                    ex.printStackTrace();
                }
            }
        });
        saveOnServer.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                BillServiceConfigTabbedPanel.this.selectFile.setEnabled(!saveOnServer.isSelected());
            }
        });
        this.saveRegister.setBorder(new TitledBorder("\u0420\u0435\u0435\u0441\u0442\u0440 \u0441\u0447\u0435\u0442\u043e\u0432"));
        this.saveRegister.add((Component)this.selectFile, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.saveRegister.add((Component)saveOnServer, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.saveRegister.add((Component)saveButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
    }

    protected void initCardPanel() {
        this.cardPanel.add((Component)this.getPanel(), "table");
        this.cardPanel.add((Component)((Object)this.viewer), "viewer");
        this.setLayout(new GridBagLayout());
        this.add(this.cardPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected JPanel getPanel() {
        return new JPanel();
    }

    protected JPanel getTopPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 1, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)this.saveRegister, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        return panel;
    }

    protected JPanel getFilterPanel() {
        return new JPanel();
    }

    protected abstract Request getRequest();

    protected abstract void addPopupItems(JPopupMenu var1);

    protected void initTable(String mode, BGUTable table) {
        this.mode = mode;
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem editItem = new JMenuItem("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
        editItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BillServiceConfigTabbedPanel.this.positionsEditor.editItem();
            }
        });
        popupMenu.add(editItem);
        popupMenu.addSeparator();
        JMenuItem addItem = new JMenuItem("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440");
        addItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BillServiceConfigTabbedPanel.this.openDocuments(false);
            }
        });
        popupMenu.add(addItem);
        JMenuItem insertItem = new JMenuItem("\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0432 \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440");
        insertItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BillServiceConfigTabbedPanel.this.openDocuments(true);
            }
        });
        popupMenu.add(insertItem);
        JMenuItem mailItem = new JMenuItem("\u041e\u0442\u043e\u0441\u043b\u0430\u0442\u044c \u043d\u0430 \u043f\u043e\u0447\u0442\u0443");
        mailItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BillServiceConfigTabbedPanel.this.sendDocuments(true);
            }
        });
        popupMenu.add(mailItem);
        popupMenu.addSeparator();
        JMenuItem gotoContractItem = new JMenuItem("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
        gotoContractItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BillServiceConfigTabbedPanel.this.gotoContract();
            }
        });
        popupMenu.add(gotoContractItem);
        popupMenu.addSeparator();
        this.countLabel.setFont(new Font("Arial", 1, 14));
        this.addPopupItems(popupMenu);
        table.setComponentPopupMenu(popupMenu);
        table.setSelectionMode(2);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    BillServiceConfigTabbedPanel.this.openDocuments(false);
                }
            }
        });
        this.positionsEditor = new BillPositionsEditor((BGPanel)this, null, true, mode, this.tableModel);
    }

    private void openDocuments(boolean insert) {
        List<BillDoc> docs = this.getSelectedDocs();
        if (docs.isEmpty()) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u044b");
        } else {
            this.showCardPanel("viewer");
            this.viewer.openDocuments(docs, insert);
        }
    }

    protected void showCardPanel(String name) {
        this.cardLayout.show(this.cardPanel, name);
    }

    protected List<BillDoc> getSelectedDocs() {
        ArrayList<BillDoc> result = new ArrayList<BillDoc>();
        for (Element rowElement : this.tableModel.getSelectedRows()) {
            BillDoc doc = new BillDoc();
            if (this.mode.equals("invoice")) {
                doc.type = 1;
            }
            doc.cid = Utils.parseInt((String)rowElement.getAttribute("cid"));
            doc.docId = Utils.parseInt((String)rowElement.getAttribute("id"));
            doc.number = rowElement.getAttribute("number");
            result.add(doc);
        }
        return result;
    }

    protected String getSelectedIds() {
        StringBuffer codes = new StringBuffer();
        for (Element rowElement : this.tableModel.getSelectedRows()) {
            String docId = rowElement.getAttribute("id");
            if (codes.length() != 0) {
                codes.append(",");
            }
            codes.append(docId);
        }
        return codes.toString();
    }

    protected void updateCountLabel(String number, String summ) {
        this.countLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432: " + new DecimalFormat("###,###,###,##0").format(new BigDecimal(number)) + ", \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 " + new DecimalFormat("###,###,###,##0.00").format(new BigDecimal(summ)));
    }

    protected void prepareFilters() {
        Request request = new Request();
        request.setModule(this.module);
        request.setModuleId(this.getModuleId());
        request.setAction("PackageList");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildComboBox(this.packageCb, (Node)XMLUtils.getElement((Document)doc, (String)"list"), null);
        }
        this.packageCb.insertItemAt((Object)new ComboBoxItem((Object)"0", "-- \u043b\u044e\u0431\u0430\u044f --"), 0);
        this.packageCb.setSelectedIndex(0);
        this.sortModeCb.addItem((Object)new ComboBoxItem(0, "\u0434\u043e\u0433\u043e\u0432\u043e\u0440"));
        this.sortModeCb.addItem((Object)new ComboBoxItem(9, "\u0434\u043e\u0433\u043e\u0432\u043e\u0440 (\u0443\u0447\u0438\u0442\u044b\u0432\u0430\u044f \u0441\u0443\u0431.)"));
        this.sortModeCb.addItem((Object)new ComboBoxItem(3, "\u043d\u043e\u043c\u0435\u0440"));
        this.sortModeCb.addItem((Object)new ComboBoxItem(4, "\u043d\u043e\u043c\u0435\u0440 \u043e\u0431\u0440."));
        this.sortModeCb.addItem((Object)new ComboBoxItem(5, "ID"));
        this.sortModeCb.addItem((Object)new ComboBoxItem(6, "ID \u043e\u0431\u0440."));
        this.sortModeCb.addItem((Object)new ComboBoxItem(1, "\u0443\u043b\u0438\u0446\u0430/\u0434\u043e\u043c"));
        this.sortModeCb.addItem((Object)new ComboBoxItem(2, "\u0438\u043d\u0434\u0435\u043a\u0441"));
        this.sortModeCb.addItem((Object)new ComboBoxItem(7, "\u0433\u043e\u0440\u043e\u0434/\u043a\u0432\u0430\u0440\u0442\u0430\u043b"));
        this.sortModeCb.addItem((Object)new ComboBoxItem(8, "\u0424\u0418\u041e/\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435"));
        this.sortModeCb.addItem((Object)new ComboBoxItem(10, "\u041f\u043e \u0448\u0430\u0431\u043b\u043e\u043d\u0443"));
        this.sortModeCb.addItem((Object)new ComboBoxItem(11, "\u041f\u043e \u043f\u0430\u0447\u043a\u0435"));
        this.sortModeCb.setSelectedIndex(0);
        this.secondarySortModeCb.addItem((Object)new ComboBoxItem(-1, "- \u043d\u0435\u0442 -"));
        this.secondarySortModeCb.addItem((Object)new ComboBoxItem(0, "\u0434\u043e\u0433\u043e\u0432\u043e\u0440"));
        this.secondarySortModeCb.addItem((Object)new ComboBoxItem(9, "\u0434\u043e\u0433\u043e\u0432\u043e\u0440 (\u0443\u0447\u0438\u0442\u044b\u0432\u0430\u044f \u0441\u0443\u0431.)"));
        this.secondarySortModeCb.addItem((Object)new ComboBoxItem(3, "\u043d\u043e\u043c\u0435\u0440"));
        this.secondarySortModeCb.addItem((Object)new ComboBoxItem(4, "\u043d\u043e\u043c\u0435\u0440 \u043e\u0431\u0440."));
        this.secondarySortModeCb.addItem((Object)new ComboBoxItem(5, "ID"));
        this.secondarySortModeCb.addItem((Object)new ComboBoxItem(6, "ID \u043e\u0431\u0440."));
        this.secondarySortModeCb.addItem((Object)new ComboBoxItem(1, "\u0443\u043b\u0438\u0446\u0430/\u0434\u043e\u043c"));
        this.secondarySortModeCb.addItem((Object)new ComboBoxItem(2, "\u0438\u043d\u0434\u0435\u043a\u0441"));
        this.secondarySortModeCb.addItem((Object)new ComboBoxItem(7, "\u0433\u043e\u0440\u043e\u0434/\u043a\u0432\u0430\u0440\u0442\u0430\u043b"));
        this.secondarySortModeCb.addItem((Object)new ComboBoxItem(8, "\u0424\u0418\u041e/\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435"));
        this.secondarySortModeCb.addItem((Object)new ComboBoxItem(10, "\u041f\u043e \u0448\u0430\u0431\u043b\u043e\u043d\u0443"));
        this.secondarySortModeCb.setSelectedIndex(0);
    }

    public void init(String module, int moduleId) {
        super.init(module, moduleId);
        this.viewer.init(module, moduleId);
        this.positionsEditor.init(module, moduleId);
    }

    private void sendDocuments(boolean insert) {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("BillDocsToMail");
        request.setModuleId(this.getModuleId());
        request.setAttribute("type", this.mode);
        request.setAttribute("codes", this.getSelectedIds());
        Document doc = this.getDocument(request);
        ClientUtils.checkStatus((Document)doc);
    }

    protected void gotoContract() {
        List rows = this.tableModel.getSelectedRows();
        if (rows.isEmpty()) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
        } else {
            for (Element rowElement : rows) {
                int contractId = Utils.parseInt((String)rowElement.getAttribute("cid"));
                if (contractId <= 0) continue;
                this.openContract(contractId);
            }
        }
    }
}

