/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.buyemoney.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.XMLUtils;

public class ServicePropertiesPanel
extends ServicePanel {
    private BGComboBox<ComboBoxItem> currency = new BGComboBox();
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private BGTable table = new BGTable();

    public ServicePropertiesPanel() {
        this.setTabbedPanel();
        this.setLayout(this.cardLayout1);
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u0414\u0430\u0442\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        filterPanel.add((Component)this.period, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add((Component)new JLabel("\u0412\u0430\u043b\u044e\u0442\u0430"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        filterPanel.add((Component)this.currency, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 10, new Insets(0, 10, 5, 5), 0, 0));
        filterPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 10, new Insets(0, 10, 5, 5), 0, 0));
        JPanel tablePanel = new JPanel(new GridBagLayout());
        tablePanel.add((Component)filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        tablePanel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        Calendar now = Calendar.getInstance();
        this.period.setDateCalendar1(TimeUtils.getStartMonth((Calendar)now));
        this.period.setDateCalendar2(TimeUtils.getEndMonth((Calendar)now));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ServicePropertiesPanel.this.editItem();
                }
            }
        });
        this.currency.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServicePropertiesPanel.this.setData();
            }
        });
        this.period.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("date1".equals(evt.getPropertyName()) || "date2".equals(evt.getPropertyName())) {
                    ServicePropertiesPanel.this.setData();
                }
            }
        });
        this.add(tablePanel, "table");
        this.cardLayout1.show((Container)((Object)this), "table");
        this.table.setHeader(this.rb_name, this.moduleDoc, "contract_buyemoney_payment");
    }

    public void setData() {
        if (!this.init) {
            this.init();
            this.init = true;
        }
        if (this.getContractId() > -1 && this.getModuleId() > -1) {
            Document doc;
            Request request = new Request();
            request.setModule(this.module);
            request.setModuleId(this.getModuleId());
            request.setAction("PayList");
            request.setContractId(this.getContractId());
            request.setPeriod(this.period.getPeriod());
            ComboBoxItem item = (ComboBoxItem)this.currency.getSelectedItem();
            if (item != null) {
                request.setAttribute("currency", String.valueOf(item.getObject()));
            }
            if (ClientUtils.checkStatus((Document)(doc = TransferManager.getDocument((Request)request)))) {
                this.table.updateData(XMLUtils.selectNode((Node)doc, (String)"/data/table"));
            }
        }
    }

    private void init() {
        Request req = new Request();
        req.setModule(this.module);
        req.setModuleId(this.getModuleId());
        req.setAction("CurrenciesList");
        Document doc = TransferManager.getDocument((Request)req);
        if (ClientUtils.checkStatus((Document)doc)) {
            ClientUtils.buildComboBox(this.currency, (Node)XMLUtils.selectNode((Node)doc, (String)"/data/currencies"), null);
            this.currency.insertItemAt((Object)new ComboBoxItem((Object)"", "\u043b\u044e\u0431\u0430\u044f"), 0);
            this.currency.setSelectedIndex(0);
        }
    }
}

