<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="layout.xsl"/>


<xsl:template name="title">
	<xsl:choose>
		<xsl:when test="data/@action = 'PayList'">Покупки электронных денег</xsl:when>
		<xsl:when test="data/@action = 'Pay'">Покупка</xsl:when>
	</xsl:choose>
</xsl:template>


<xsl:template name="head">
<xsl:text disable-output-escaping="yes">
	<![CDATA[    
<script type="text/javascript">
<!--

// мэп цен(ид=>сумма), заполняется ниже в шаблоне
var priceMap = new Array();
// мэп заполненности поля ввода кошелька (ид=>значение поля), заполняется ниже в шаблоне
// если что-то есть, то выводить это в поле, а поле дисейблить
var purseInputMap = new Array();
// мэп видимости подсказки о том, что можно прописать кошелёк руками в договоре (ид=>видима_подсказка), заполняется ниже в шаблоне
var purseInputWarningMap = new Array();

// либо цена единицы выбранной в комбобоксе, либо undefined
function getPriceValue()
{
	return priceMap[$('field_cur').value];
}
// выбрана ли валюта комбобоксом
function isSelectedCurrency()
{
	return $('field_cur').value > 0;
}

window.onload = function()
{
	$('field_sum').onkeyup = function(e)
	{
		if( isSelectedCurrency() )
		{
			$('field_sumtotal').value = $('field_sum').value * getPriceValue();
			if( $('field_sumtotal').value == "NaN" ) $('field_sumtotal').value = "error";
		}
		else
		{
			$('field_sumtotal').value = "";
		}
	};
	
	$('field_sumtotal').onkeyup = function(e)
	{
		if( isSelectedCurrency() )
		{
			$('field_sum').value = $('field_sumtotal').value / getPriceValue();
			if( $('field_sum').value == "NaN" ) $('field_sum').value = "error";
		}
		else
		{
			$('field_sum').value = "";
		}
	};
	
	$('field_cur').onchange = function(e)
	{
		// кошелёк рисуем есть есть чо
		$('field_purse').value = isSelectedCurrency() ? purseInputMap[$('field_cur').value] : "";
		// если что-то есть, дисейблим
		$('field_purse').disabled = ($('field_purse').value != "");
		// подсказка если надо показать		
		$('element_purseInputWarning').style.display = ( purseInputWarningMap[$('field_cur').value] ) ? 'block' : 'none';
		// будто мы ввели заново сумму
		$('field_sum').onkeyup(e);
	};
};

//-->
</script>   
    ]]>
</xsl:text>
</xsl:template>


<xsl:template match="/data">
	<xsl:choose>
		<xsl:when test="@action = 'PayList'">
			<xsl:call-template name="PayList"/>
		</xsl:when>
		<xsl:when test="@status = 'error' or @status = 'message'">
			<xsl:call-template name="PayDone"/>
		</xsl:when>
		<xsl:when test="@action = 'Pay'">
			<xsl:call-template name="PayConfirm"/>
		</xsl:when>
	</xsl:choose>
</xsl:template>


<xsl:template name="PayList">

	<div class="bgMonthAndYearWidget">
		<xsl:attribute name="month"><xsl:value-of select="/data/date/@month"/></xsl:attribute>
		<xsl:attribute name="year"><xsl:value-of select="/data/date/@year"/></xsl:attribute>
		<xsl:attribute name="query"><xsl:value-of select="$WEBEXECUTER"/>?action=<xsl:value-of select="/data/@action"/>&amp;module=<xsl:value-of select="/data/@module"/>&amp;mid=<xsl:value-of select="/data/@mid"/></xsl:attribute></div>

	<div class="report">
		История покупок:
		<table border="0" cellspacing="1" class="table800">
			<thead>
	  			<tr>
					<td>Дата/время</td>
					<td>Подробности операции</td>
					<td>Кошелёк</td>
					<td>Статус операции</td>
					<td>Транзакция</td>
	  			</tr>
	 		</thead>
	 		<tbody>	 		
	  			<xsl:for-each select="buyemoney/payment">
					<tr>	
						<xsl:attribute name="class">
							<xsl:choose>
	  							<xsl:when test="@status='NEW'">row_status_process</xsl:when>
	  							<xsl:when test="@status='OK'">row_status_ok</xsl:when>
	  							<xsl:when test="@status='FAIL'">row_status_fail</xsl:when>
	  						</xsl:choose>
						</xsl:attribute>
						
						<td><xsl:value-of select="@date"/></td>
						<td>
							Покупка <b><xsl:value-of select="@sumcur"/><xsl:text> </xsl:text><xsl:value-of select="@currency"/></b> за <xsl:value-of select="@sumtotal"/> <s>Р</s>;
							Курс при покупке: 1<xsl:value-of select="@currency"/>=<xsl:value-of select="@price"/><s>Р</s>
						</td>
						<td><xsl:value-of select="@purse"/></td>
						<td>
	  						<xsl:choose>
	  							<xsl:when test="@status='NEW'">В обработке</xsl:when>
	  							<xsl:when test="@status='OK'">Успешно</xsl:when>
	  							<xsl:when test="@status='FAIL'">Неуспешно</xsl:when>
	  						</xsl:choose>
	  						<xsl:if test="@comment != ''">
	  							(<xsl:value-of select="@comment"/>)
	  						</xsl:if>
						</td>
						<td nowrap="nowrap"><xsl:value-of select="@id"/></td>
					</tr>
	  			</xsl:for-each>
	 		</tbody>
		</table>
	</div>

 	<br/>
 	
 	Покупка валюты:
 	
 	<xsl:choose>
 		<xsl:when test="currencies/currency"> 		

		<form method="GET" action="{$WEBEXECUTER}">
		<xsl:call-template name="module"/>
		<input type="hidden" name="action" value="Pay" />
		
		<table class="layout">
			<tr>
				<td>Количество:</td>
				<td><input type="text" name="sum" size="7" id="field_sum"/></td>
				<td>
					<select class="gradbtn " name="currency" id="field_cur" style="width:100%;">
						<option value="-1">~ выберите валюту ~</option>
						<xsl:for-each select="currencies/currency">
							<option value="{@id}"><xsl:value-of select="@title"/> (1 <xsl:value-of select="@code"/> = <xsl:value-of select="@price"/><s>Р</s>)</option>
						</xsl:for-each>
					</select>
				</td>
				<td>
					за <input type="text" name="sumtotal" size="7" id="field_sumtotal"/>&#160;<s>Р</s>
				</td>				
			</tr>
			<tr>
				<td>Кошелёк для вывода:</td>
				<td colspan="3">
					 <input type="text" name="purse" id="field_purse" size="60"/>
				</td>
			</tr>
			<tr>
				<td>Комментарий:</td>
				<td colspan="3">
					<input type="text" name="userComment" size="60"/>
				</td>
			</tr>
			<tr class="foot">
				<td colspan="4">
					<xsl:call-template name="submit">
						<xsl:with-param name="title" select="'Купить'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
			
		</form>	
		
		<em class="comment" id="element_purseInputWarning" style="display: none;">Примечание: для данной валюты Вы можете указать 
		кошелёк в параметрах договора (через оператора), для безопасности
		совершения операций - вывести деньги можно будет только на указанный
		заранее кошелёк.</em>
		
 		</xsl:when>
 		<xsl:otherwise>
 			<br/>Покупка электронных денег недоступна.
 		</xsl:otherwise> 	
 	</xsl:choose>	

	<!-- заполняем мэп priceMap[id]=price; -->
	<xsl:text disable-output-escaping="yes">
		<![CDATA[
<script type="text/javascript">
<!--
    	]]>
    </xsl:text>

	<xsl:for-each select="currencies/currency">
priceMap[<xsl:value-of select="@id"/>]=<xsl:value-of select="@price"/>;
purseInputMap[<xsl:value-of select="@id"/>]="<xsl:value-of select="@purseInput"/>";
purseInputWarningMap[<xsl:value-of select="@id"/>]=<xsl:value-of select="@purseInputWarning='on'"/>;
	</xsl:for-each>

	<xsl:text disable-output-escaping="yes">
		<![CDATA[
//-->
</script>   
    	]]>
	</xsl:text>
	
</xsl:template>



<xsl:template name="PayConfirm">
	<form method="post" action="{$WEBEXECUTER}">
		<xsl:call-template name="action"/>
				<input type="hidden" name="confirm" value="1"/>
		<input type="hidden" name="sum" value="{@sum}"/>
		<input type="hidden" name="currency" value="{@currency}"/>
		<input type="hidden" name="purse" value="{@purse}"/>

		<div class="report">
			<table cellspacing="1" style="width: 500px;">
			<col style="width: 60%;"/>
			<col style="width: 40%;" align="center"/>
			<thead>
				<tr>
					<td colspan="2">Новая покупка</td>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td nowrap="nowrap">Текущий баланс</td>
					<td><xsl:value-of select="@balance"/></td>
				</tr>	
				<tr>
					<td nowrap="nowrap">Покупка</td>
					<td><xsl:value-of select="@sum"/><xsl:text> </xsl:text><xsl:value-of select="@currencytitle"/></td>
				</tr>
				<tr>
					<td nowrap="nowrap">Стоимость</td>
					<td><xsl:value-of select="@sumtotal"/> <s>Р</s></td>
				</tr>
				<tr>
					<td nowrap="nowrap">Ваш кошелёк (аккаунт)</td>
					<td><xsl:value-of select="@purse"/></td>
				</tr>
				<tr>
					<td nowrap="nowrap">Ваш комментарий</td>
					<td><input type="text" name="userComment" size="32" maxlength="32" value="{@userComment}"/></td>
				</tr>
				<tr>
					<td colspan="2">Нажмите "Купить" для проведения операции.</td>
				</tr>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="2">
						<xsl:call-template name="okCancel">
							<xsl:with-param name="title1" select="'Купить'"/>
							<xsl:with-param name="onclick2">window.location.replace( "<xsl:value-of select="$WEBEXECUTER"/>?action=PayList&#38;mid=<xsl:value-of select="/data/@mid"/>&#38;module=<xsl:value-of select="/data/@module"/>");</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</tfoot>
			</table>
		</div>
	</form>
</xsl:template>


<xsl:template name="PayDone">
	<!-- либо ошибку рисуем, либо полезноее сообщений -->
		<!-- и ссылку на список сразу даём -->
	<!--
	<xsl:call-template name="form Button">
		<xsl:with-param name="data">
			<xsl:call-template name="module"/>
			<input type="hidden" name="action" value="PayList" />
		</xsl:with-param>
		<xsl:with-param name="title" select="'К списку платежей'"/>
	</xsl:call-template>
	-->
	<form method='post' action='{$WEBEXECUTER}' style="display: inline;">
		<xsl:call-template name="module"/>
		<input type="hidden" name="action" value="PayList" />
					
		<xsl:call-template name="submit">
			<xsl:with-param name="title" select="'К списку платежей'"/>
		</xsl:call-template>
	</form>	
	 
</xsl:template>


</xsl:stylesheet>