/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.driver.shtrih2;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Map;
import jssc.SerialPortList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.ICashCheckDriver;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.shtrih2.PrinterShtrihErrorException;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.shtrih2.PrinterStatus;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.shtrih2.ShtrihFRKPrinter;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.DriverException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.NotImplementedException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.PrinterConnectException;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.BGByteBuffer;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.FrkUtils;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.SerialParameters;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.common.Utils;

public class Driver
implements ICashCheckDriver {
    private SerialParameters serialParameters = new SerialParameters();
    private int oneByteTimeout = 100;
    private static final Logger logger = LogManager.getLogger();
    private int waitNoprintTimeout = 1000;
    private int waitNoprintNumtry = 20;
    private boolean cutterDisabled = false;
    private boolean cutterForceManual = false;
    private boolean buzzerOnCheck = false;
    private int sno = -1;

    @Override
    public void init(Map<String, String> config) {
        if (config.containsKey("portName")) {
            this.serialParameters.setPortName(config.get("portName"));
        }
        if (config.containsKey("baudRate")) {
            this.serialParameters.setBaudRate(config.get("baudRate"));
        }
        if (config.containsKey("flowControlIn")) {
            this.serialParameters.setFlowControlIn(config.get("flowControlIn"));
        }
        if (config.containsKey("flowControlOut")) {
            this.serialParameters.setFlowControlOut(config.get("flowControlOut"));
        }
        if (config.containsKey("databits")) {
            this.serialParameters.setDatabits(config.get("databits"));
        }
        if (config.containsKey("stopbits")) {
            this.serialParameters.setStopbits(config.get("stopbits"));
        }
        if (config.containsKey("parity")) {
            this.serialParameters.setParity(config.get("parity"));
        }
        this.oneByteTimeout = Utils.parseInt((String)config.get("oneByteTimeout"), (int)this.oneByteTimeout);
        this.waitNoprintTimeout = Utils.parseInt((String)config.get("waitNoprintTimeout"), (int)this.waitNoprintTimeout);
        this.waitNoprintNumtry = Utils.parseInt((String)config.get("waitNoprintNumtry"), (int)this.waitNoprintNumtry);
        this.cutterDisabled = Utils.parseBoolean((String)config.get("cutterDisabled"), (boolean)this.cutterDisabled);
        this.cutterForceManual = Utils.parseBoolean((String)config.get("cutterForceManual"), (boolean)this.cutterForceManual);
        this.buzzerOnCheck = Utils.parseBoolean((String)config.get("buzzerOnCheck"), (boolean)this.buzzerOnCheck);
        this.sno = Utils.parseInt((String)config.get("sno"), (int)this.sno);
    }

    @Override
    public synchronized void touchDriver() {
        StringBuilder sb = new StringBuilder();
        String[] portNames = SerialPortList.getPortNames();
        sb.append("available serial ports:\n");
        for (String portName : portNames) {
            sb.append(portName).append("\n");
        }
        if (portNames.length <= 0) {
            sb.append("not available com ports!\n");
        }
        logger.debug(sb.toString());
        int[] baudrates = new int[]{2400, 4800, 9600, 19200, 38400, 57600, 115200};
        int[] flowcontrolins = new int[]{0};
        int[] flowcontrolouts = new int[]{0};
        int[] databits = new int[]{8};
        int[] stopbits = new int[]{1};
        int[] paritys = new int[]{0};
        SerialParameters portParam = new SerialParameters();
        ShtrihFRKPrinter printer = new ShtrihFRKPrinter(portParam, this.oneByteTimeout, 0L, logger);
        for (String comport : portNames) {
            portParam.setPortName(comport);
            for (int baudRate : baudrates) {
                portParam.setBaudRate(baudRate);
                for (int flowControlIn : flowcontrolins) {
                    portParam.setFlowControlIn(flowControlIn);
                    for (int flowControlOut : flowcontrolouts) {
                        portParam.setFlowControlOut(flowControlOut);
                        for (int databit : databits) {
                            portParam.setDatabits(databit);
                            for (int stopbit : stopbits) {
                                portParam.setStopbits(stopbit);
                                for (int parity : paritys) {
                                    portParam.setParity(parity);
                                    sb = new StringBuilder();
                                    sb.append(portParam.getPortName()).append(",BR:").append(portParam.getBaudRateString()).append(",DB:").append(portParam.getDatabitsString()).append(",SB:").append(portParam.getStopbitsString()).append(",P:").append(portParam.getParityString());
                                    String result = printer._touch();
                                    sb.append(" -> ").append(result).append("\n");
                                    logger.debug(sb.toString());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void buzzer(String operatorPass) throws PrinterShtrihErrorException, PrinterConnectException, DriverException {
        int oppass = FrkUtils.parseInt(operatorPass);
        try (ShtrihFRKPrinter printer = new ShtrihFRKPrinter(this.serialParameters, this.oneByteTimeout, oppass, logger);){
            printer.open();
            printer.buzzer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void printtext(String ... parameters) throws PrinterShtrihErrorException, PrinterConnectException, DriverException {
        int oppass = FrkUtils.parseInt(parameters[0]);
        try (ShtrihFRKPrinter printer = new ShtrihFRKPrinter(this.serialParameters, this.oneByteTimeout, oppass, logger);){
            printer.open();
            printer._waitToNoPrint(this.waitNoprintTimeout, this.waitNoprintNumtry);
            for (int i = 1; i < parameters.length; ++i) {
                if ("!CUT%)".equals(parameters[i]) && !this.cutterDisabled) {
                    printer.cut();
                    continue;
                }
                printer.printLine(parameters[i], false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String name(String operatorPass) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int oppass = FrkUtils.parseInt(operatorPass);
        String name = null;
        try (ShtrihFRKPrinter printer = new ShtrihFRKPrinter(this.serialParameters, this.oneByteTimeout, oppass, logger);){
            printer.open();
            name = printer.getName();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String status(String operatorPass) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int oppass = FrkUtils.parseInt(operatorPass);
        StringBuffer status = new StringBuffer(1024);
        try (ShtrihFRKPrinter printer = new ShtrihFRKPrinter(this.serialParameters, this.oneByteTimeout, oppass, logger);){
            printer.open();
            PrinterStatus ps = printer.getStatusShort();
            status.append("\u041f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ");
            status.append(ps.operatorNum);
            status.append("\n\u0420\u0443\u043b\u043e\u043d \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u0433\u043e \u0436\u0443\u0440\u043d\u0430\u043b\u0430: ");
            status.append(ps.rulonOpJournal != false ? "\u0435\u0441\u0442\u044c" : "\u043d\u0435\u0442");
            status.append("\n\u0420\u0443\u043b\u043e\u043d \u0447\u0435\u043a\u043e\u0432\u043e\u0439 \u043b\u0435\u043d\u0442\u044b: ");
            status.append(ps.rulonVoucherTape != false ? "\u0435\u0441\u0442\u044c" : "\u043d\u0435\u0442");
            status.append("\n\u042d\u041a\u041b\u0417: ");
            status.append(ps.haveEKLZ != false ? "\u0435\u0441\u0442\u044c" : "\u043d\u0435\u0442");
            status.append("\n\u041e\u043f\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0434\u0430\u0442\u0447\u0438\u043a \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u0433\u043e \u0436\u0443\u0440\u043d\u0430\u043b\u0430: ");
            status.append(ps.paperOpJournal != false ? "\u0431\u0443\u043c\u0430\u0433\u0430 \u0435\u0441\u0442\u044c" : "\u0431\u0443\u043c\u0430\u0433\u0438 \u043d\u0435\u0442");
            status.append("\n\u041e\u043f\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0434\u0430\u0442\u0447\u0438\u043a \u0447\u0435\u043a\u043e\u0432\u043e\u0439 \u043b\u0435\u043d\u0442\u044b: ");
            status.append(ps.paperVoucherTape != false ? "\u0431\u0443\u043c\u0430\u0433\u0430 \u0435\u0441\u0442\u044c" : "\u0431\u0443\u043c\u0430\u0433\u0438 \u043d\u0435\u0442");
            status.append("\n\u0420\u044b\u0447\u0430\u0433 \u0442\u0435\u0440\u043c\u043e\u0433\u043e\u043b\u043e\u0432\u043a\u0438 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0439 \u043b\u0435\u043d\u0442\u044b: ");
            status.append(ps.leverPrintheadControlTape != false ? "\u043e\u043f\u0443\u0449\u0435\u043d" : "\u043f\u043e\u0434\u043d\u044f\u0442");
            status.append("\n\u0420\u044b\u0447\u0430\u0433 \u0442\u0435\u0440\u043c\u043e\u0433\u043e\u043b\u043e\u0432\u043a\u0438 \u0447\u0435\u043a\u043e\u0432\u043e\u0439 \u043b\u0435\u043d\u0442\u044b: ");
            status.append(ps.leverPrintheadVoucherTape != false ? "\u043e\u043f\u0443\u0449\u0435\u043d" : "\u043f\u043e\u0434\u043d\u044f\u0442");
            status.append("\n\u041a\u0440\u044b\u0448\u043a\u0430 \u043a\u043e\u0440\u043f\u0443\u0441\u0430 \u0424\u0420: ");
            status.append(ps.coverCorpsFR != false ? "\u043f\u043e\u0434\u043d\u044f\u0442\u0430" : "\u043e\u043f\u0443\u0449\u0435\u043d\u0430");
            status.append("\n\u0414\u0435\u043d\u0435\u0436\u043d\u044b\u0439 \u044f\u0449\u0438\u043a: ");
            status.append(ps.moneyBox != false ? "\u043e\u0442\u043a\u0440\u044b\u0442" : "\u0437\u0430\u043a\u0440\u044b\u0442");
            status.append("\n\u042d\u041a\u041b\u0417 \u043f\u043e\u0447\u0442\u0438 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0430: ");
            status.append(ps.filledEKLZ != false ? "\u0434\u0430" : "\u043d\u0435\u0442");
            status.append("\n\u0420\u0435\u0436\u0438\u043c \u0424\u0420: ");
            status.append("#" + ps.modeNumString() + " : " + ps.modeString());
            status.append("\n\u041f\u043e\u0434\u0440\u0435\u0436\u0438\u043c \u0424\u0420: ");
            status.append("#" + ps.submode + " : " + ps.submodeString());
            status.append("\n\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439 \u0432 \u0447\u0435\u043a\u0435: ");
            status.append(ps.operationCount);
            status.append("\n\u041d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u0431\u0430\u0442\u0430\u0440\u0435\u0438: ");
            status.append(ps.voltageBackupBattery);
            status.append("\n\u041d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u043f\u0438\u0442\u0430\u043d\u0438\u044f: ");
            status.append(ps.voltagePowerSource);
            status.append("\n\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 \u0424\u041f: ");
            status.append(ps.errorFP);
            status.append("\n\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 \u042d\u041a\u041b\u0417: ");
            status.append(ps.errorEKLZ);
        }
        return status.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void xreport(String adminPass) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int adminpass = FrkUtils.parseInt(adminPass);
        try (ShtrihFRKPrinter printer = new ShtrihFRKPrinter(this.serialParameters, this.oneByteTimeout, adminpass, logger);){
            printer.open();
            printer._waitToNoPrint(this.waitNoprintTimeout, this.waitNoprintNumtry);
            printer.xreport();
            if (this.cutterForceManual) {
                printer.cut();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void divreport(String adminPass) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int adminpass = FrkUtils.parseInt(adminPass);
        try (ShtrihFRKPrinter printer = new ShtrihFRKPrinter(this.serialParameters, this.oneByteTimeout, adminpass, logger);){
            printer.open();
            printer._waitToNoPrint(this.waitNoprintTimeout, this.waitNoprintNumtry);
            printer.divreport();
            if (this.cutterForceManual) {
                printer.cut();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void zreport(String adminPass) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int adminpass = FrkUtils.parseInt(adminPass);
        try (ShtrihFRKPrinter printer = new ShtrihFRKPrinter(this.serialParameters, this.oneByteTimeout, adminpass, logger);){
            printer.open();
            printer._waitToNoPrint(this.waitNoprintTimeout, this.waitNoprintNumtry);
            printer.zreport();
            if (this.cutterForceManual) {
                printer.cut();
            }
        }
    }

    private int vat_convert_salev2(Integer vat) {
        if (vat == null) {
            return 0;
        }
        switch (vat) {
            default: {
                return vat;
            }
            case 1000999: {
                return 8;
            }
            case 1000000: {
                return 4;
            }
            case 1000010: {
                return 2;
            }
            case 1000110: {
                return 32;
            }
            case 1000020: {
                return 1;
            }
            case 1000120: {
                return 16;
            }
            case 1000005: {
                return 129;
            }
            case 1000105: {
                return 132;
            }
            case 1000007: {
                return 130;
            }
            case 1000107: 
        }
        return 136;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String _check(int type, String ... parameters) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        FrkUtils.CommandCheckParameters commandCheckParameters = FrkUtils.processCommandCheckParameters(parameters, logger);
        if (commandCheckParameters.checkType != null) {
            int newtype = -1;
            switch (commandCheckParameters.checkType) {
                case PAYMENT: {
                    newtype = 1;
                    break;
                }
                case PAYMENTREFUND: {
                    newtype = 2;
                    break;
                }
                case PAYMENTCORRECTION: {
                    throw new NotImplementedException("checkType=PAYMENTCORRECTION", NotImplementedException.CAN_BE_IMPLEMENTED);
                }
            }
            if (newtype != type) {
                logger.debug("Driver: overwrite check type from " + type + " to " + newtype);
                type = newtype;
            }
        }
        int oppass = FrkUtils.parseInt(parameters[0]);
        BigDecimal par1 = FrkUtils.parseBigDecimal(parameters[1]);
        BigDecimal clientsumma = type == 1 ? par1 : BigDecimal.ZERO;
        BigDecimal mul100 = new BigDecimal(100);
        logger.debug("Driver: check/checkreturn(clientsumma=" + clientsumma + ",type=" + type + "):");
        Integer tax_check = commandCheckParameters.tax;
        Integer payMethodTotal = commandCheckParameters.payMethod;
        Integer payObjectTotal = commandCheckParameters.payObject;
        Integer paymentType = commandCheckParameters.paymentType;
        if (type == 1 && clientsumma.compareTo(commandCheckParameters.paymentsum) < 0) {
            throw new PrinterShtrihErrorException("\u0414\u0435\u043d\u0435\u0433 \u0432\u043d\u0435\u0441\u0435\u043d\u043e (" + clientsumma.toPlainString() + ") \u043c\u0435\u043d\u044c\u0448\u0435 \u0441\u0443\u043c\u043c\u044b \u0447\u0435\u043a\u0430 (" + commandCheckParameters.paymentsum.toPlainString() + ")");
        }
        ShtrihFRKPrinter.CloseCheckReturn subn = null;
        try (ShtrihFRKPrinter printer = new ShtrihFRKPrinter(this.serialParameters, this.oneByteTimeout, oppass, logger);){
            int val_17_1_7;
            printer.open();
            printer._waitToNoPrint(this.waitNoprintTimeout, this.waitNoprintNumtry);
            int tax1 = tax_check != null ? tax_check : 0;
            boolean tax2 = false;
            boolean tax3 = false;
            boolean tax4 = false;
            if (commandCheckParameters.onlyElCheck && (val_17_1_7 = printer.readTableByte(17, 1, 7)) == 0) {
                printer.writeTableByte(17, 1, 7, 1);
            }
            for (Check.CheckLine checkLine : commandCheckParameters.lines) {
                if (checkLine.getSumma() == null) {
                    printer.printLine(checkLine.getText(), true);
                    continue;
                }
                Integer payMethod = checkLine.payMethod != null ? checkLine.payMethod : payMethodTotal;
                Integer payObject = checkLine.payObject != null ? checkLine.payObject : payObjectTotal;
                Integer tax_item = checkLine.tax;
                if (tax_item == null) {
                    tax_item = tax_check;
                }
                printer.saleV2(type, 1000000L, checkLine.getSumma().multiply(mul100).longValue(), checkLine.getDep(), checkLine.getText(), this.vat_convert_salev2(tax_item), payMethod != null ? payMethod : 0, payObject != null ? payObject : 0);
                if (type == 2) {
                    clientsumma = clientsumma.add(checkLine.getSumma());
                }
                for (Map.Entry tagOperation : checkLine.customTags.entrySet()) {
                    Object vtag = tagOperation.getValue();
                    if (vtag instanceof byte[]) {
                        printer.sendTLVOperation((Integer)tagOperation.getKey(), (byte[])vtag);
                        continue;
                    }
                    if (vtag instanceof Long) {
                        printer.sendTLVOperation((Integer)tagOperation.getKey(), new byte[]{((Long)vtag).byteValue()});
                        continue;
                    }
                    if (!(vtag instanceof String)) continue;
                    printer.sendTLVOperation((Integer)tagOperation.getKey(), ((String)vtag).getBytes(Charset.forName("cp866")));
                }
            }
            if (commandCheckParameters.customerEmail != null) {
                printer.sendTLV(1008, commandCheckParameters.customerEmail.getBytes(OFD_TAG_ENCODING));
            }
            if (commandCheckParameters.cashierName != null) {
                printer.sendTLV(1021, commandCheckParameters.cashierName.getBytes(OFD_TAG_ENCODING));
            }
            if (commandCheckParameters.cashierINN != null) {
                printer.sendTLV(1203, commandCheckParameters.cashierINN.getBytes(OFD_TAG_ENCODING));
            }
            for (Map.Entry entry : commandCheckParameters.customTags.entrySet()) {
                Object vtag = entry.getValue();
                if (vtag instanceof byte[]) {
                    printer.sendTLV((Integer)entry.getKey(), (byte[])vtag);
                    continue;
                }
                if (vtag instanceof Long) {
                    printer.sendTLV((Integer)entry.getKey(), new byte[]{((Long)vtag).byteValue()});
                    continue;
                }
                if (!(vtag instanceof String)) continue;
                printer.sendTLV((Integer)entry.getKey(), ((String)vtag).getBytes(Charset.forName("cp866")));
            }
            long sum = clientsumma.multiply(mul100).longValue();
            int summa_num = 0;
            summa_num = paymentType == null || paymentType == 1 ? 1 : (paymentType == 2 ? 2 : paymentType);
            if (summa_num < 1 || summa_num > 16) {
                throw new DriverException("payment type must be 1..16");
            }
            if (this.sno < 0 || this.sno > 5) {
                throw new DriverException("sno must be 0..5");
            }
            subn = printer.closeCheckExV2(sum, summa_num, "", this.sno);
            if (this.buzzerOnCheck) {
                printer.buzzer();
            }
            if (this.cutterForceManual) {
                printer.cut();
            }
        }
        return String.valueOf(subn.submit / 100L) + "." + String.valueOf(subn.submit % 100L);
    }

    @Override
    public synchronized String check(String ... parameters) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        return this._check(1, parameters);
    }

    @Override
    public synchronized String checkreturn(String ... parameters) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        return this._check(2, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String closecheck_fix(String adminPass, String summa) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int adminpass = FrkUtils.parseInt(adminPass);
        ShtrihFRKPrinter printer = new ShtrihFRKPrinter(this.serialParameters, this.oneByteTimeout, adminpass, logger);
        long subn = 0L;
        BigDecimal clientsumma = FrkUtils.parseBigDecimal(summa);
        long sum = clientsumma.multiply(new BigDecimal(100)).longValue();
        try {
            printer.open();
            printer._waitToNoPrint(this.waitNoprintTimeout, this.waitNoprintNumtry);
            subn = printer.closeCheck(sum, 0L, 0L, 0L, 0, "\u044d\u043a\u0441\u0442\u0440\u0435\u043d\u043d\u043e\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0447\u0435\u043a\u0430", 0, 0, 0, 0);
            if (this.buzzerOnCheck) {
                printer.buzzer();
            }
            if (this.cutterForceManual) {
                printer.cut();
            }
        }
        finally {
            printer.close();
        }
        return String.valueOf(subn / 100L) + "." + String.valueOf(subn % 100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void continueprint(String pass) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int ipass = FrkUtils.parseInt(pass);
        try (ShtrihFRKPrinter printer = new ShtrihFRKPrinter(this.serialParameters, this.oneByteTimeout, ipass, logger);){
            printer.open();
            printer._waitToNoPrint(this.waitNoprintTimeout, this.waitNoprintNumtry);
            printer.continuePrint();
            if (this.cutterForceManual) {
                printer.cut();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String purecommand(String operatorPass, String command) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int pass = FrkUtils.parseInt(operatorPass);
        String ret = "?";
        try (ShtrihFRKPrinter printer = new ShtrihFRKPrinter(this.serialParameters, this.oneByteTimeout, pass, logger);){
            printer.open();
            BGByteBuffer bb = printer.pureCmd(command);
            if (bb != null) {
                ret = bb.toString();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void repeatcheck(String operatorPass) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int pass = FrkUtils.parseInt(operatorPass);
        try (ShtrihFRKPrinter printer = new ShtrihFRKPrinter(this.serialParameters, this.oneByteTimeout, pass, logger);){
            printer.open();
            printer._waitToNoPrint(this.waitNoprintTimeout, this.waitNoprintNumtry);
            printer.repeatDoc();
            if (this.cutterForceManual) {
                printer.cut();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void cancelcheck(String operatorPass) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int pass = FrkUtils.parseInt(operatorPass);
        try (ShtrihFRKPrinter printer = new ShtrihFRKPrinter(this.serialParameters, this.oneByteTimeout, pass, logger);){
            printer.open();
            printer.cancelCheck();
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getStatus() {
        return this.serialParameters.getStringStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openday(String adminPass) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int adminpass = FrkUtils.parseInt(adminPass);
        try (ShtrihFRKPrinter printer = new ShtrihFRKPrinter(this.serialParameters, this.oneByteTimeout, adminpass, logger);){
            printer.open();
            printer._waitToNoPrint(this.waitNoprintTimeout, this.waitNoprintNumtry);
            printer.openDay();
        }
    }
}

