/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.task.SubscribeSynchronizer;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.LoggingAbstractManager;
import ru.bitel.common.model.Page;

public class UserCardManager
extends LoggingAbstractManager<UserCard> {
    public UserCardManager(Connection con, int mid, int userId) {
        super(con, mid, "user_card", userId);
    }

    @Deprecated
    public List<UserCard> getListByDate(Calendar date) throws BGException {
        return this.getListByDate(TimeUtils.convertCalendarToDate((Calendar)date));
    }

    public List<UserCard> getListByDate(Date date) throws BGException {
        return this.list("(date1 IS NULL OR date1<=?) AND (date2 IS NULL or ?<=date2)", "", new Object[]{date, date});
    }

    public List<UserCard> getList(int cid, Date date) throws BGException {
        return this.list("(date1 IS NULL OR date1<=?) AND (date2 IS NULL or ?<=date2) AND cid=?", "", new Object[]{date, date, cid});
    }

    @Deprecated
    public UserCard getUserCard(long number, Calendar date) throws BGException {
        return this.getUserCard(number, TimeUtils.convertCalendarToDate((Calendar)date));
    }

    public UserCard getUserCard(long number, Date date) throws BGException {
        return (UserCard)this.get("(date1 IS NULL OR date1<=?) AND (date2 IS NULL or ?<=date2) AND number=?", new Object[]{date, date, number});
    }

    public List<UserCard> getListByNumber(long number) throws BGException {
        return this.list("number=?", "date1", new Object[]{number});
    }

    public List<UserCard> getListByGroups(long groups) throws BGException {
        ArrayList<UserCard> result = new ArrayList<UserCard>(10);
        try {
            String query = "SELECT card.* FROM user_card_" + this.moduleId + " as card  LEFT JOIN contract ON contract.id=card.cid WHERE (contract.gr & ?)>0 ORDER BY date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setLong(1, groups);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<UserCard> getList(int cid) throws BGException {
        return this.list_join_card("user_card_" + this.moduleId + ".cid=?", "date1", cid);
    }

    public List<UserCard> list_join_card(String filter, String orderBy, Object ... params) throws BGException {
        try {
            String join = "LEFT JOIN card_" + this.moduleId + " as card ON card.number=user_card_" + this.moduleId + ".number";
            return this.listImpl(new Page(), "*", join, filter, orderBy, params);
        }
        catch (SQLException e) {
            this.processException(e);
            return Collections.emptyList();
        }
    }

    public List<UserCard> getList(int cid, boolean slavecardsIncluding) throws BGException {
        return slavecardsIncluding ? this.getList(cid) : this.list("cid=? AND basecardId<=0", "date1", new Object[]{cid});
    }

    public Map<Integer, UserCard> getUserCardMap() throws BGException {
        return Id.newMap((List)this.list(null, null, new Object[0]));
    }

    public Map<Integer, UserCard> getUserCardMap(Calendar date, Collection<Integer> userCardIds) throws BGException {
        HashMap<Integer, UserCard> result = new HashMap<Integer, UserCard>(16);
        if (userCardIds != null) {
            for (Integer userCardId : userCardIds) {
                UserCard uc = (UserCard)this.get(userCardId);
                if (uc == null) continue;
                result.put(uc.getId(), uc);
            }
        } else {
            for (UserCard uc : this.getListByDate(date)) {
                result.put(uc.getId(), uc);
            }
        }
        return result;
    }

    public int[] getMinAndMaxCardNumber() throws BGException {
        int[] result = new int[2];
        try {
            String query = "SELECT MIN(number), MAX(number) FROM user_card_" + this.moduleId;
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result[0] = rs.getInt(1);
                result[1] = rs.getInt(2);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void updateSubscribe(Date date, int userCardId, boolean slavecardsProcess) throws BGException {
        UserCard usercard = (UserCard)this.get(userCardId);
        if (usercard != null) {
            List<UserCard> slavecards = slavecardsProcess ? this.getSlavecards(usercard) : null;
            this.updateSubscribe(date, usercard, slavecards);
        }
    }

    public void updateSubscribe(Date date, UserCard usercard, List<UserCard> slavecards) throws BGException {
        if (TimeUtils.dateBeforeOrEq((Date)date, (Date)new Date())) {
            if (usercard != null) {
                usercard.setNeedSync(true);
                this.update((Id)usercard);
                new RunTaskDataManager(this.con).addTask((RunTask)new SubscribeSynchronizer(this.moduleId, usercard));
            }
            if (slavecards != null) {
                for (UserCard slavecard : slavecards) {
                    slavecard.setNeedSync(true);
                    this.update((Id)slavecard);
                    new RunTaskDataManager(this.con).addTask((RunTask)new SubscribeSynchronizer(this.moduleId, slavecard));
                }
            }
        }
    }

    public List<UserCard> findConflictCards(UserCard usercard) throws BGException {
        ArrayList<UserCard> result = new ArrayList<UserCard>();
        try {
            String query = "SELECT * FROM user_card_" + this.moduleId + " WHERE  number=? AND id !=? AND (date1 IS NULL OR ? IS NULL OR date1<=?) AND (date2 IS NULL OR ? IS NULL OR ?<=date2) LIMIT 1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setLong(1, usercard.getNumber());
            ps.setInt(2, usercard.getId());
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)usercard.getDate2()));
            ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)usercard.getDate2()));
            ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)usercard.getDate1()));
            ps.setDate(6, TimeUtils.convertDateToSqlDate((Date)usercard.getDate1()));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    protected void updateImpl(UserCard b) throws BGException, SQLException {
        String query = null;
        PreparedStatement ps = null;
        if (b.getId() <= 0) {
            query = "INSERT INTO " + this.tableName + " (cid, number, date1, date2, subscr_dt, comment, basecardId, object_id, userdevice_id, need_sync, userdevice_sn)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            query = "UPDATE " + this.tableName + " SET cid=?, number=?, date1=?, date2=?, subscr_dt=?,comment=? ,basecardId=?, object_id=?, userdevice_id=?, need_sync=?, userdevice_sn=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(12, b.getId());
        }
        ps.setInt(1, b.getContractId());
        ps.setLong(2, b.getNumber());
        ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)b.getDate1()));
        ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)b.getDate2()));
        ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)b.getSubscrDate()));
        ps.setString(6, b.getComment());
        ps.setInt(7, b.getBasecardId());
        ps.setInt(8, b.getObjectId());
        ps.setInt(9, b.getUserdeviceId());
        ps.setBoolean(10, b.isNeedSync());
        ps.setString(11, b.getUserdeviceSN());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
        ps.close();
    }

    protected UserCard getFromRS(ResultSet rs) throws SQLException, BGException {
        UserCard userCard = new UserCard();
        userCard.setId(rs.getInt("id"));
        userCard.setContractId(rs.getInt("cid"));
        userCard.setNumber(rs.getLong("number"));
        userCard.setDate1((Date)rs.getDate("date1"));
        userCard.setDate2((Date)rs.getDate("date2"));
        userCard.setSubscrDate((Date)rs.getDate("subscr_dt"));
        userCard.setComment(rs.getString("comment"));
        userCard.setBasecardId(rs.getInt("basecardId"));
        userCard.setObjectId(rs.getInt("object_id"));
        userCard.setUserdeviceId(rs.getInt("userdevice_id"));
        userCard.setNeedSync(rs.getBoolean("need_sync"));
        userCard.setUserdeviceSN(rs.getString("userdevice_sn"));
        try {
            userCard.setPairingModule(rs.getString("card.pairing_module"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return userCard;
    }

    public List<UserCard> getSlavecards(UserCard basecard) throws BGException {
        List list = this.list("basecardId=?", "date1", new Object[]{basecard.getId()});
        for (UserCard card : list) {
            card.setBasecardTitle("\u041a\u043e\u043f\u0438\u044f \u043a\u0430\u0440\u0442\u044b '" + basecard.getGuiTitle() + "'");
        }
        return list;
    }

    public List<UserCard> getSlavecards(int basecardId) throws BGException {
        return this.getSlavecards((UserCard)this.get(basecardId));
    }

    public void deleteSlavesByBasecardId(int basecardId) throws BGException {
        this.delete("basecardId=?", new Object[]{basecardId});
    }

    public static Map<Integer, List<UserCard>> makeSlavecardListMap(List<UserCard> allContractUsercards) {
        HashMap<Integer, List<UserCard>> slavecardsMap = new HashMap<Integer, List<UserCard>>();
        for (UserCard userCard : allContractUsercards) {
            if (userCard.getBasecardId() <= 0) continue;
            ArrayList<UserCard> slavecards = (ArrayList<UserCard>)slavecardsMap.get(userCard.getBasecardId());
            if (slavecards == null) {
                slavecards = new ArrayList<UserCard>();
                slavecardsMap.put(userCard.getBasecardId(), slavecards);
            }
            slavecards.add(userCard);
        }
        return slavecardsMap;
    }

    public List<UserCard> getListByObject(int objectId) throws BGException {
        return this.list("object_id=?", "", new Object[]{objectId});
    }

    public void setSyncStatusUsercards(Collection<Integer> usercardsIds, boolean needSyncStatus) throws BGException {
        try {
            if (usercardsIds != null && !usercardsIds.isEmpty()) {
                String query = "UPDATE " + this.tableName + " SET need_sync=? WHERE id in (" + Utils.toString(usercardsIds) + ")";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setBoolean(1, needSyncStatus);
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void setSyncStatusCards(Collection<Long> cards, boolean needSyncStatus) throws BGException {
        try {
            if (cards != null && !cards.isEmpty()) {
                String query = "UPDATE " + this.tableName + " SET need_sync=? WHERE number in (" + Utils.toString(cards) + ")";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setBoolean(1, needSyncStatus);
                ps.executeUpdate();
                ps.close();
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<UserCard> getListNeedSync() throws BGException {
        return this.list("need_sync=?", null, new Object[]{true});
    }

    public Map<Integer, UserCard> getUserCardMap(int cid) {
        HashMap<Integer, UserCard> result = new HashMap<Integer, UserCard>(16);
        try {
            for (UserCard uc : this.getList(cid)) {
                result.put(uc.getId(), uc);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

