/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.cdcas30;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.modules.cerbercrypt.server.cdcas30.BitArrayOutputStream;
import ru.bitel.bgbilling.modules.cerbercrypt.server.cdcas30.CDCAS30Connection;
import ru.bitel.bgbilling.modules.cerbercrypt.server.cdcas30.EntitlementResponse;
import ru.bitel.bgbilling.modules.cerbercrypt.server.cdcas30.Request;

public class EntitlementRequest
extends Request<EntitlementRequest, EntitlementResponse> {
    private List<ProductEntry> productEntrys;
    private int enti_type;

    public EntitlementRequest(CDCAS30Connection connection, int dB_ID) {
        super(connection, dB_ID);
    }

    public void setProductEntrys(List<ProductEntry> productEntrys) {
        this.productEntrys = productEntrys;
    }

    public void setEntiType(int enti_type) {
        this.enti_type = enti_type;
    }

    @Override
    protected int getMessageId() {
        return 525;
    }

    @Override
    protected void writeDataCont(BitArrayOutputStream output) throws IOException {
        output.write(this.card_sn);
        output.writeBits(this.productEntrys.size(), 8);
        for (ProductEntry product : this.productEntrys) {
            output.writeBits(this.enti_type, 1);
            output.writeBits(0, 5);
            output.writeBits(product.prod_id, 10);
            output.writeBits(product.tape_ctrl, 8);
            output.writeTimeT32(product.start_time);
            output.writeTimeT32(product.end_time);
        }
    }

    @Override
    public EntitlementResponse getResponse() {
        return new EntitlementResponse(this.connection, this.DB_ID);
    }

    public static class ProductEntry {
        private int prod_id;
        private int tape_ctrl;
        private Date start_time;
        private Date end_time;

        public ProductEntry(int prod_id, int tape_ctrl, Date start_time, Date end_time) {
            this.prod_id = prod_id;
            this.tape_ctrl = tape_ctrl;
            this.start_time = start_time;
            this.end_time = end_time;
        }
    }
}

