/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.cticas4;

import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;

public class ByteSerializer {
    private byte[] buffer = null;
    private int pos = 0;

    public ByteSerializer(int cap) {
        this.buffer = new byte[cap];
    }

    public void put(byte value, int fieldlen) {
        this.put((long)value & 0xFFL, fieldlen);
    }

    public void put(int value, int fieldlen) {
        this.put((long)value & 0xFFFFFFFFL, fieldlen);
    }

    public void put(long value, int fieldlen) {
        for (int i = 0; i < fieldlen; ++i) {
            this.buffer[this.pos + fieldlen - i - 1] = (byte)(value & 0xFFL);
            value >>>= 8;
        }
        this.pos += fieldlen;
    }

    public byte[] getBuffer() {
        if (this.pos < this.buffer.length) {
            byte[] buffernew = new byte[this.pos];
            System.arraycopy(this.buffer, 0, buffernew, 0, buffernew.length);
            this.buffer = buffernew;
        }
        return this.buffer;
    }

    public void putSTMP(Date value) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        this.put(cal.get(1), 2);
        this.put(cal.get(2) + 1, 1);
        this.put(cal.get(5), 1);
        this.put(cal.get(11), 1);
        this.put(cal.get(12), 1);
        this.put(cal.get(13), 1);
    }

    public void put(byte[] value) {
        System.arraycopy(value, 0, this.buffer, this.pos, value.length);
        this.pos += value.length;
    }

    public void put(String value) {
        try {
            this.put(value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void putTLVInteger(int PI, int PL, long value) {
        this.put(PI, 2);
        this.put(PL, 2);
        this.put(value, PL);
    }

    public void putTLVStringVariable(int PI, String string) {
        this.putTLVStringVariable(PI, string, "UTF-8");
    }

    public void putTLVStringVariable(int PI, String string, String charsetName) {
        byte[] bytes;
        try {
            bytes = string.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        int PL = bytes.length;
        this.put(PI, 2);
        this.put(PL, 2);
        this.put(bytes);
    }

    public void putTLVSTMP(int PI, int PL, Date date) {
        if (PL != 7) {
            throw new RuntimeException("PL must by 7");
        }
        this.put(PI, 2);
        this.put(PL, 2);
        this.putSTMP(date);
    }
}

