/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.service;

import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.contract.object.bean.ObjectManager;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Card;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.UserCardService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.CerbercryptServiceActivator;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.TariffRequestManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardCopyManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.SubscriptionChangedEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.event.UserCardUpdateEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.task.Calculator;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.LogEntry;
import ru.bitel.common.model.MapHolder;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.cerbercrypt.common.service.UserCardService")
public class UserCardServiceImpl
extends AbstractService
implements UserCardService {
    public List<LogEntry> logList(String filter, Object ... args) throws BGException {
        try (UserCardManager userCardManager = new UserCardManager(this.getConnection(), this.moduleId, this.userId);){
            if ("oid".equals(filter)) {
                List list = userCardManager.logListByOid((Integer)args[0]);
                return list;
            }
            if ("cid".equals(filter)) {
                List list = userCardManager.logListByCid((Integer)args[0]);
                return list;
            }
            List<LogEntry> list = null;
            return list;
        }
    }

    public List<UserCard> getUserCardList(int cid, boolean slavecardsIncluding) throws BGException {
        List<UserCard> allContractCards = new UserCardManager(this.getConnection(), this.moduleId, this.userId).getList(cid, slavecardsIncluding);
        int multiroomMaxSlavecard = this.getModuleSetup().getInt("multiroom.max.slavecards", 0);
        if (multiroomMaxSlavecard > 0 && slavecardsIncluding) {
            this.fillMultiroomData(allContractCards, null);
        }
        return allContractCards;
    }

    public void updateUserCard(final UserCard uc) throws BGException, BGMessageException {
        TariffRequestManager tariffRequestManager;
        Set<Integer> autoaddPackets;
        int multiroomMaxCopycard;
        CardPacketManager cardPacketManager = new CardPacketManager(this.getConnection(), this.moduleId);
        CardManager cardManager = new CardManager(this.getConnection(), this.moduleId, this.userId);
        Card card = cardManager.getCard(uc.getNumber());
        if (card == null) {
            throw new BGMessageException("\u041a\u0430\u0440\u0442\u0430 " + uc.getNumber() + " \u043d\u0435 \u0437\u0430\u0432\u0435\u0434\u0435\u043d\u0430 \u0432 \u043c\u043e\u0434\u0443\u043b\u0435!");
        }
        if (card.getDealerId() <= 0) {
            throw new BGMessageException("\u041a\u0430\u0440\u0442\u0430 " + uc.getNumber() + " \u043d\u0435 \u043f\u0435\u0440\u0435\u0434\u0430\u043d\u0430 \u0434\u0438\u043b\u0435\u0440\u0443!");
        }
        UserCardManager manager = new UserCardManager(this.getConnection(), this.moduleId, this.userId);
        UserCard olduc = (UserCard)manager.get(uc.getId());
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"WSUserCard.updateUserCard", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            Date olddate1 = null;
            Date olddate2 = null;
            if (olduc != null) {
                olddate1 = olduc.getDate1();
                olddate2 = olduc.getDate2();
            }
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Date)olddate1, (Date)olddate2, (Date)uc.getDate1(), (Date)uc.getDate2());
        }
        if ((multiroomMaxCopycard = this.getModuleSetup().getInt("multiroom.max.slavecards", 0)) > 0) {
            List<CardPacket> packets;
            if (olduc != null && olduc.getBasecardId() > 0) {
                if (olduc.getBasecardId() != uc.getBasecardId()) {
                    throw new BGException("\u041a\u0430\u0440\u0442\u0430 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u043e\u043f\u0438\u0435\u0439, \u043d\u0435\u043b\u044c\u0437\u044f \u0435\u0451 \u043e\u0442\u0432\u044f\u0437\u0430\u0442\u044c \u0438\u043b\u0438 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u0442\u044c \u043a \u0434\u0440\u0443\u0433\u043e\u0439");
                }
                cardPacketManager.truncatePacketsToCard(uc);
            } else if (uc.getBasecardId() > 0 && (packets = cardPacketManager.getCardPacketList(uc.getId())).size() > 0) {
                throw new BGException("\u041a\u0430\u0440\u0442\u0430 '" + uc.getGuiTitle() + "' \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043f\u0430\u043a\u0435\u0442\u044b (" + packets.size() + "\u0448\u0442), \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0432 \u0442\u043e\u043c \u0447\u0438\u0441\u043b\u0435 \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435.\n\u0415\u0451 \u043d\u0435\u043b\u044c\u0437\u044f \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u0442\u044c \u043a \u0434\u0440\u0443\u0433\u043e\u0439. \u0417\u0430\u043a\u0440\u043e\u0439\u0442\u0435 \u044d\u0442\u0443 \u043a\u0430\u0440\u0442\u0443 \u0438 \u043e\u0442\u043a\u0440\u043e\u0439\u0442\u0435 \u0437\u0430\u043d\u043e\u0432\u043e.");
            }
        }
        if (cardPacketManager.checkCardPackets(uc)) {
            throw new BGMessageException("\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043e\u0434\u043d\u043e\u0433\u043e \u0438\u0437 \u043f\u0430\u043a\u0435\u0442\u043e\u0432 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043a\u0430\u0440\u0442\u044b " + uc.getNumber(), "packetinterval");
        }
        List<UserCard> conflictCards = manager.findConflictCards(uc);
        if (!conflictCards.isEmpty()) {
            UserCard conflictCard = conflictCards.get(0);
            ContractUtils cu = new ContractUtils(this.getConnection());
            String title = cu.getContractTitle(conflictCard.getContractId(), false, null);
            if (title != null) {
                throw new BGMessageException("\u041a\u0430\u0440\u0442\u0430 " + uc.getNumber() + " \u043a\u043e\u043d\u0444\u043b\u0438\u043a\u0442\u0443\u0435\u0442 \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u043c " + (String)title);
            }
        }
        manager.update((Id)uc);
        cardManager.updateCardContract(card, new GregorianCalendar());
        if (olduc == null && (autoaddPackets = (tariffRequestManager = new TariffRequestManager(this.getConnection(), this.moduleId)).getAutoaddPackets((ParameterMap)this.getModuleSetup(), uc.getContractId(), TimeUtils.convertDateToCalendar((Date)uc.getDate1()))) != null) {
            for (Integer packet : autoaddPackets) {
                CardPacket cardPacket = new CardPacket();
                cardPacket.setContractId(uc.getContractId());
                cardPacket.setUsercardId(uc.getId());
                cardPacket.setPacketId(packet.intValue());
                cardPacket.setDateFrom(uc.getDate1());
                cardPacket.setDateTo(uc.getDate2());
                cardPacket.setComment("\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0441 \u043a\u0430\u0440\u0442\u043e\u0439");
                cardPacketManager.updateCardPacket(cardPacket);
            }
        }
        if (olduc == null && (autoaddPackets = (tariffRequestManager = new TariffRequestManager(this.getConnection(), this.moduleId)).getPacketsAutosync((ParameterMap)this.getModuleSetup(), uc.getContractId(), uc.getDate1(), TariffRequestManager.AutosyncOnMode.ONCARDADD)) != null) {
            CardPacketManager cmp = new CardPacketManager(this.getConnection(), this.moduleId, this.userId);
            cmp.replaceCardPacketsUserCard(uc, uc.getDate1(), autoaddPackets, "[\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0441 \u043a\u0430\u0440\u0442\u043e\u0439 \u0438\u0437 \u0442\u0430\u0440\u0438\u0444\u0430]", "~\u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0435 \u0431\u044b\u043b\u043e, \u043d\u043e\u0432\u0430\u044f \u043a\u0430\u0440\u0442\u0430~");
            SubscriptionChangedEvent event = new SubscriptionChangedEvent(this.moduleId, uc.getContractId(), (Set<Integer>)new HashSet<Integer>(){
                {
                    this.add(uc.getId());
                }
            }, -3, 1, new HashSet<Integer>(autoaddPackets), uc.getDate1());
            this.context.publishAfterCommit((Event)event);
        }
        this.context.publishAfterCommit((Event)new UserCardUpdateEvent(this.userId, this.moduleId, uc.getContractId(), olduc, uc));
        manager.updateSubscribe(new Date(), uc, null);
        manager.close();
    }

    public void deleteUserCard(int id) throws BGException {
        UserCardManager userCardManager = new UserCardManager(this.getConnection(), this.moduleId, this.userId);
        UserCard uc = (UserCard)userCardManager.get(id);
        UserCardCopyManager userCardCopyManager = new UserCardCopyManager(this.getConnection(), this.moduleId, this.userId);
        CardPacketManager cardPacketManager = new CardPacketManager(this.getConnection(), this.moduleId);
        if (uc == null) {
            throw new BGException("\u042e\u0437\u0435\u0440\u043a\u0430\u0440\u0442\u0430 id=" + id + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!");
        }
        CardManager cardManager = new CardManager(this.getConnection(), this.moduleId, this.userId);
        Card card = cardManager.getCard(uc.getNumber());
        if (card == null) {
            throw new BGException("\u041a\u0430\u0440\u0442\u0430 " + uc.getNumber() + " \u043d\u0435 \u0437\u0430\u0432\u0435\u0434\u0435\u043d\u0430 \u0432 \u043c\u043e\u0434\u0443\u043b\u0435!");
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"WSUserCard.deleteUserCard", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (Date)uc.getDate1());
        }
        List<UserCard> slavecards = userCardManager.getSlavecards(uc);
        cardPacketManager.deleteCardPackets(id);
        userCardCopyManager.deleteCardCopies(id);
        userCardManager.delete(id);
        for (UserCard slavecard : slavecards) {
            cardPacketManager.deleteCardPackets(slavecard.getId());
            userCardCopyManager.deleteCardCopies(slavecard.getId());
            userCardManager.delete(slavecard.getId());
        }
        cardManager.updateCardContract(card, new GregorianCalendar());
        this.context.publishAfterCommit((Event)new UserCardUpdateEvent(this.userId, this.moduleId, uc.getContractId(), uc, null));
        userCardManager.updateSubscribe(new Date(), uc, slavecards);
        userCardManager.close();
        userCardCopyManager.close();
    }

    public MapHolder<String, String> getSystemInfo() throws BGException {
        HashMap<String, String> dm = new HashMap<String, String>();
        dm.put("sa", this.getModuleSetup().get("sa", CerbercryptServiceActivator.class.getName()));
        return new MapHolder(dm);
    }

    public BigDecimal checkSubscriptionCost(int cid, List<Integer> usercardIds, Date date) throws BGException {
        if (date == null || usercardIds.isEmpty()) {
            throw new BGIllegalArgumentException();
        }
        return this.getSubscriptionCost(cid, usercardIds, date);
    }

    private BigDecimal getSubscriptionCost(int cid, List<Integer> usercardIds, Date date) throws BGException {
        Calculator calculator = new Calculator();
        calculator.setOneDayMode();
        calculator.setExecutingTime(TimeUtils.convertDateToCalendar((Date)date));
        calculator.setCids(String.valueOf(cid));
        calculator.setUsercardIds(usercardIds);
        calculator.initTask(Setup.getSetup(), 0, "mid=" + this.moduleId + "\ncomment=calcalate price manual run");
        Map contractAccounts = calculator.preCalculate(this.getConnectionSet()).getContractAccounts();
        BigDecimal bd = (BigDecimal)contractAccounts.get(cid);
        return Utils.maskNull((BigDecimal)bd);
    }

    public List<UserCard> getMultiroomBasecards(int cid, int selfCardId) throws BGException {
        UserCardManager userCardManager = new UserCardManager(this.getConnection(), this.moduleId, this.userId);
        ArrayList<UserCard> baseGoodCards = new ArrayList<UserCard>();
        int multiroomMaxSlavecard = this.getModuleSetup().getInt("multiroom.max.slavecards", 0);
        if (multiroomMaxSlavecard > 0) {
            List<UserCard> allContractCards = userCardManager.getList(cid);
            Map<Integer, List<UserCard>> slavecardListMap = UserCardManager.makeSlavecardListMap(allContractCards);
            for (UserCard userCard : allContractCards) {
                if (userCard.getBasecardId() > 0 || userCard.getId() == selfCardId) continue;
                List<UserCard> slavecards = slavecardListMap.get(userCard.getId());
                int copiesall = slavecards != null ? slavecards.size() : 0;
                int copiesactive = 0;
                if (copiesall > 0) {
                    for (UserCard slavecard : slavecards) {
                        if (!TimeUtils.dateInRange((Date)new Date(), (Date)slavecard.getDate1(), (Date)slavecard.getDate2())) continue;
                        ++copiesactive;
                    }
                }
                if (copiesactive >= multiroomMaxSlavecard) continue;
                baseGoodCards.add(userCard);
            }
        }
        userCardManager.close();
        return baseGoodCards;
    }

    public void releaseSlave(int cid, int slavecardId) throws BGException {
        UserCardManager manager = new UserCardManager(this.getConnection(), this.moduleId, this.userId);
        UserCard slavecard = (UserCard)manager.get(slavecardId);
        if (slavecard == null) {
            throw new BGException("\u041d\u0435\u0442 \u043a\u0430\u0440\u0442\u044b id=" + slavecardId);
        }
        if (slavecard.getBasecardId() <= 0) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430: \u043e\u0441\u0432\u043e\u0431\u043e\u0436\u0434\u0430\u0435\u043c\u0430\u044f \u043a\u0430\u0440\u0442\u0430 \"" + slavecard.getGuiTitle() + "\" \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u0430 \u043d\u0438 \u043a \u043a\u0430\u043a\u043e\u0439 \u043a\u0430\u0440\u0442\u0435");
        }
        slavecard.setDate2(TimeUtils.getPrevDay((Date)new Date()));
        this.updateUserCard(slavecard);
        manager.updateSubscribe(new Date(), slavecard, null);
        manager.close();
    }

    private void fillMultiroomData(List<UserCard> allContractCards, UserCard uc2set) {
        Map<Integer, List<UserCard>> slavecardListMap = UserCardManager.makeSlavecardListMap(allContractCards);
        Map allContractCardsMap = Id.newMap(allContractCards);
        for (UserCard userCard : allContractCards) {
            if (userCard.getBasecardId() > 0) {
                UserCard basecard = (UserCard)allContractCardsMap.get(userCard.getBasecardId());
                Object basecardTitle = basecard != null ? basecard.getGuiTitle() : "?\u043a\u0430\u0440\u0442\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043a\u043e\u0434=" + userCard.getBasecardId();
                userCard.setBasecardTitle("\u041a\u043e\u043f\u0438\u044f \u0434\u043b\u044f " + (String)basecardTitle);
            } else {
                List<UserCard> slavecards = slavecardListMap.get(userCard.getId());
                int copiesall = slavecards != null ? slavecards.size() : 0;
                int copiesactive = 0;
                if (copiesall > 0) {
                    for (UserCard slavecard : slavecards) {
                        if (!TimeUtils.dateInRange((Date)new Date(), (Date)slavecard.getDate1(), (Date)slavecard.getDate2())) continue;
                        ++copiesactive;
                    }
                }
                userCard.setBasecardTitle("\u041e\u0441\u043d\u043e\u0432\u043d\u0430\u044f" + (String)(copiesall > 0 ? " (\u043a\u043e\u043f\u0438\u0439: \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0445 " + copiesactive + ", \u0432\u0441\u0435\u0433\u043e " + copiesall + ")" : ""));
                userCard.setSlavecardsNumber(copiesall);
            }
            if (uc2set == null || uc2set.getId() != userCard.getId()) continue;
            uc2set.setBasecardTitle(userCard.getBasecardTitle());
            uc2set.setSlavecardsNumber(userCard.getSlavecardsNumber());
        }
    }

    @Deprecated
    private void truncatePacketsToCard(UserCard uc) throws BGException {
        CardPacketManager cardPacketManager = new CardPacketManager(this.getConnection(), this.moduleId);
        cardPacketManager.truncatePacketsToCard(uc);
    }

    public List<IdTitle> getContractObjects(int contractId) throws BGException {
        return new ObjectManager(this.getConnection()).getObjectList(contractId).stream().map(f -> new IdTitle(f.getId(), f.getTitle())).collect(Collectors.toList());
    }

    public List<UserCard> getCardListByObject(int objectId) throws BGException {
        try (UserCardManager userCardManager = new UserCardManager(this.getConnection(), this.moduleId, this.userId);){
            List<UserCard> list = userCardManager.getListByObject(objectId);
            return list;
        }
    }

    public UserCard getUserCard(int id) throws BGException {
        try (UserCardManager userCardManager = new UserCardManager(this.getConnection(), this.moduleId, this.userId);){
            int multiroomMaxSlavecard;
            UserCard uc = (UserCard)userCardManager.get(id);
            if (uc != null && (multiroomMaxSlavecard = this.getModuleSetup().getInt("multiroom.max.slavecards", 0)) > 0) {
                List<UserCard> allContractCards = userCardManager.getList(uc.getContractId(), true);
                this.fillMultiroomData(allContractCards, uc);
            }
            UserCard userCard = uc;
            return userCard;
        }
    }
}

