/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.tariff;

import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.common.Utils;

public class DiscountCardTariffTreeNode
extends DefaultTariffTreeNode {
    private static final int LESS = 1;
    private static final int LESS_OR_EQ = 2;
    private static final int EQ = 3;
    private static final int MORE_OR_EQ = 4;
    private static final int MORE = 5;
    private int compare;
    private float discount;
    private int cardCount;

    public void init(String data, int deep, int nodeId) {
        super.init(data, deep, nodeId);
        Map dataHash = this.getDataInHash();
        this.discount = Utils.parseFloat((String)((String)dataHash.get("discount_card")), (float)0.0f);
        this.cardCount = Utils.parseInt((String)((String)dataHash.get("card_count")), (int)1);
        String compare = (String)dataHash.get("compare");
        if (compare.equals("<")) {
            this.compare = 1;
        } else if (compare.equals("<=")) {
            this.compare = 2;
        } else if (compare.equals("=")) {
            this.compare = 3;
        } else if (compare.equals(">=")) {
            this.compare = 4;
        } else if (compare.equals(">")) {
            this.compare = 5;
        }
    }

    public void processRequest(TariffRequest request) {
        Integer cardCount = (Integer)request.getRequestParam("card_count");
        if (cardCount == null) {
            cardCount = 0;
        }
        if (cardCount >= 0) {
            boolean check = false;
            switch (this.compare) {
                case 1: {
                    check = cardCount < this.cardCount;
                    break;
                }
                case 2: {
                    check = cardCount <= this.cardCount;
                    break;
                }
                case 3: {
                    check = cardCount == this.cardCount;
                    break;
                }
                case 4: {
                    check = cardCount >= this.cardCount;
                    break;
                }
                case 5: {
                    boolean bl = check = cardCount > this.cardCount;
                }
            }
            if (check) {
                request.setResponseParam("discount_card", (Object)Float.valueOf(this.discount));
            }
        }
    }
}

