/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cloudpayments.server;

import bitel.billing.server.ModuleBase;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.config.server.bean.ContractModuleConfigDao;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.cloudpayments.common.bean.Transaction;
import ru.bitel.bgbilling.modules.cloudpayments.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.cloudpayments.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.CloudPaymentsAutopaymentEvent;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.CloudPaymentsCheckEvent;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.worker.CloudPaymentsAutopaymentEventWorker;
import ru.bitel.bgbilling.modules.cloudpayments.server.event.worker.CloudPaymentsCheckEventWorker;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class Module
extends ModuleBase {
    private static final Logger log = LogManager.getLogger();

    public String[] getServerPackages() {
        return new String[]{"ru.bitel.bgbilling.modules.cloudpayments.server"};
    }

    public void start(Connection con, BGModule module) throws BGException {
        if (Setup.getSetup().getModuleSetup(Integer.valueOf(module.getId())).getBoolean("cloudpayments.event.worker", true)) {
            new CloudPaymentsCheckEventWorker(Setup.getSetup(), module.getId());
            new CloudPaymentsAutopaymentEventWorker(Setup.getSetup(), module.getId());
        } else {
            this.addListeners(module);
        }
    }

    @Deprecated
    private void addListeners(final BGModule module) throws BGException {
        EventProcessor.getInstance().addListener((EventListener)new EventListener<CloudPaymentsCheckEvent>(){

            public void notify(CloudPaymentsCheckEvent event, EventListenerContext ctx) throws BGException {
                try (TransactionManager transactionManager = new TransactionManager(ctx.getConnection(), module.getId());){
                    transactionManager.doCheckRequest(event.getContractId(), event.isAutopaymentTransaction());
                }
            }
        }, CloudPaymentsCheckEvent.class, module.getId(), null);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<CloudPaymentsAutopaymentEvent>(){

            public void notify(CloudPaymentsAutopaymentEvent event, EventListenerContext ctx) throws BGException {
                int moduleId = module.getId();
                int contractId = event.getContractId();
                Connection con = ctx.getConnection();
                AutopaymentManager autopaymentManager = new AutopaymentManager(con, moduleId);
                Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
                autopaymentManager.close();
                BigDecimal sum = event.getSum();
                if (sum == null) {
                    sum = autopayment.getSum();
                }
                if (autopayment != null && autopayment.getMode().getCode() == event.getMode()) {
                    ContractDao contractDao = new ContractDao(con, 0);
                    Contract contract = (Contract)contractDao.get(contractId);
                    contractDao.close();
                    if (contract != null) {
                        ContractModuleConfigDao contractModuleConfigDao;
                        String customerAddress = null;
                        try {
                            contractModuleConfigDao = new ContractModuleConfigDao(con, moduleId);
                            try {
                                customerAddress = contractModuleConfigDao.get(contractId, "customerAddress");
                            }
                            finally {
                                contractModuleConfigDao.close();
                            }
                        }
                        catch (Exception e) {
                            throw new BGException((Throwable)e);
                        }
                        if (Utils.isBlankString((String)customerAddress)) {
                            contractModuleConfigDao = new ContractModuleConfigDao(con, 0);
                            try {
                                customerAddress = contractModuleConfigDao.get(contractId, "payment.phone");
                                if (Utils.isBlankString((String)customerAddress)) {
                                    customerAddress = contractModuleConfigDao.get(contractId, "payment.email");
                                }
                            }
                            finally {
                                contractModuleConfigDao.close();
                            }
                        }
                        HashMap<String, Object> dataMap = new HashMap<String, Object>();
                        try (TransactionManager transactionManager = new TransactionManager(con, moduleId);){
                            Transaction transaction = transactionManager.registerOrder(contractId, contract.getTitle(), customerAddress, sum, dataMap, true, true);
                            String result = transactionManager.paymentOrderBinding(transaction, autopayment);
                            if (result != null) {
                                Map parameterMap = Utils.stringToPairsHash((String)result.replace("\n", ";"));
                                if ("0".equals(parameterMap.get("errorCode"))) {
                                    transactionManager.doCheckRequest(contractId, true);
                                } else {
                                    transaction.setStatus(TransactionStatus.ERROR.getCode());
                                    TransactionManager.addTransactionParameters(transaction, result);
                                    transactionManager.update(transaction);
                                }
                            }
                        }
                    }
                }
            }
        }, CloudPaymentsAutopaymentEvent.class, module.getId(), null);
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        super.moduleAction(serverContext, moduleId, event);
        int contractId = event.getContractId();
        try {
            ContractDeleteEvent contractDeleteEvent;
            Connection con = serverContext.getConnection();
            if (event instanceof ContractCreateEvent) {
                ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
                if (!contractCreateEvent.isCheck()) {
                    this.enableAutopayment(contractCreateEvent.getPattern().getData(), "cloudpayments", moduleId, contractId, con, serverContext.getUserId());
                }
            } else if (event instanceof ContractDeleteEvent && !(contractDeleteEvent = (ContractDeleteEvent)event).isCheck()) {
                this.removeAutopayment(moduleId, contractId, con);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

