/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.action;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.crm.common.model.PersonalRegisterTask;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterGroup;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterTask;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterGroupManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterProblemManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterTaskManager;
import ru.bitel.bgbilling.plugins.crm.server.model.TaskFilter;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public abstract class ActionBase
extends bitel.billing.server.ActionBase {
    protected static final String TIME_FORMAT = "dd.MM.yy HH:mm";
    protected BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.crm");

    protected Map<Integer, String> getRegisterTaskTypeMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>(20);
        try {
            String query = "SELECT id, title FROM register_task_type";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.put(rs.getInt(1), rs.getString(2));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    protected Map<Integer, String> getRegisterExecutorMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>(20);
        try {
            String query = "SELECT id, title FROM register_executor";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.put(rs.getInt(1), rs.getString(2));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    protected String getGroupEmail(int id) {
        String email = null;
        RegisterGroupManager manager = new RegisterGroupManager(this.con);
        RegisterGroup group = manager.getGroupById(id);
        if (group != null) {
            email = group.getEmail();
        }
        return email;
    }

    protected void addUserData(int uid, Date time, String format, Element el, String attrName) {
        User user = UserMap.getUser((Integer)uid);
        if (user != null && time != null) {
            StringBuffer message = new StringBuffer(20);
            message.append(TimeUtils.format((Date)time, (String)format));
            message.append(" (");
            message.append(user.getName());
            message.append(")");
            el.setAttribute(attrName, message.toString());
        }
    }

    protected String getTaskType(int id) throws SQLException {
        String result = "";
        String query = "SELECT title FROM register_task_type WHERE id=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = rs.getString(1);
        }
        rs.close();
        ps.close();
        return result;
    }

    protected void createRegisterReport(RegisterTask task, RegisterGroup group, String xslt, String email, String subject) throws SQLException {
        int value;
        Object phoneParam;
        RegisterTaskManager manager = new RegisterTaskManager(this.con);
        String fioParams = this.plugin.getSetup().get("contract.fio.param.id", null);
        if (fioParams == null) {
            fioParams = this.plugin.getSetup().get("register.param.fio", this.setup.get("register.param.fio", ""));
        }
        if ((phoneParam = this.plugin.getSetup().get("contract.phone.param.id", null)) == null && (value = this.plugin.getSetup().getInt("register.param.phone", this.setup.getInt("register.param.phone", 0))) > 0) {
            phoneParam = "text:" + value;
        }
        TaskFilter filter = new TaskFilter();
        filter.id = task.getId();
        filter.fioParams = fioParams;
        filter.setPhoneParams((String)phoneParam);
        filter.processed = -1;
        filter.orders = new ArrayList<String>();
        Page page = new Page();
        page.setPageIndex(1);
        page.setPageSize(1);
        List<PersonalRegisterTask> taskList = manager.getTaskList(filter, page);
        PersonalRegisterTask personalTask = taskList.get(0);
        String statusList = this.plugin.getSetup().get("register.task.status.list", "0:\u043e\u0442\u043a\u0440\u044b\u0442\u0430;1:\u043f\u0440\u0438\u043d\u044f\u0442\u0430;2:\u0437\u0430\u043a\u0440\u044b\u0442\u0430");
        Map<Integer, String> statusMap = RegisterProblemManager.getStatusMap(statusList);
        Element header = this.createElement(this.rootNode, "header");
        header.setAttribute("status", statusMap.get(task.getStatus()));
        header.setAttribute("id", String.valueOf(task.getId()));
        this.addUserData(task.getOpenUserId(), task.getOpenTime(), "dd.MM.yyyy HH:mm", header, "open");
        this.addUserData(task.getAcceptUserId(), task.getAcceptTime(), "dd.MM.yyyy HH:mm", header, "accept");
        this.addUserData(task.getCloseUserId(), task.getCloseTime(), "dd.MM.yyyy HH:mm", header, "close");
        this.addUserData(task.getLastmodUserId(), task.getLastmodTime(), "dd.MM.yyyy HH:mm", header, "lastmod");
        header.setAttribute("group", group.getTitle());
        ResultSet rs = null;
        header.setAttribute("type", this.getTaskType(task.getTypeId()));
        Element contract = this.createElement(this.rootNode, "contract");
        contract.setAttribute("title", personalTask.getContract());
        contract.setAttribute("city", personalTask.getCity());
        contract.setAttribute("quarter", personalTask.getQuarter());
        contract.setAttribute("street", personalTask.getStreet());
        contract.setAttribute("house", personalTask.getHouse());
        contract.setAttribute("flat", personalTask.getFlat());
        contract.setAttribute("fio", personalTask.getFio());
        contract.setAttribute("phone", personalTask.getPhone());
        Element executors = this.createElement(this.rootNode, "executors");
        List executorsList = task.getExecutors();
        if (executorsList.size() > 0) {
            String query = "SELECT id, title FROM register_executor WHERE id IN ( " + Utils.toString((Iterable)executorsList) + " )";
            PreparedStatement ps = this.con.prepareStatement(query);
            rs = ps.executeQuery();
            Element item = null;
            while (rs.next()) {
                item = this.createElement(executors, "item");
                item.setAttribute("id", rs.getString(1));
                item.setAttribute("title", rs.getString(2));
            }
            rs.close();
            ps.close();
        }
        Element comment = this.createElement(this.rootNode, "comment");
        this.stringToLines(comment, task.getComment());
        Element resolution = this.createElement(this.rootNode, "resolution");
        this.stringToLines(resolution, task.getResolution());
        if (Utils.isBlankString((String)email)) {
            XSLManager.getInstance().transform(this.response, xslt, (Source)new DOMSource(this.rootNode.getOwnerDocument()), null, "text/html", null, false);
        } else {
            XSLManager.getInstance().transformAndSend(xslt, (Source)new DOMSource(this.rootNode.getOwnerDocument()), null, "text/html", null, false, email, subject);
        }
    }

    protected String getGroupsExecutors(String groups) throws SQLException {
        StringBuffer result = new StringBuffer(100);
        String query = "SELECT DISTINCT eid FROM register_executor_group WHERE gid IN ( " + groups + ")";
        PreparedStatement ps = this.con.prepareStatement(query);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            if (result.length() != 0) {
                result.append(",");
            }
            result.append(rs.getString(1));
        }
        rs.close();
        ps.close();
        return result.toString();
    }

    protected String buildRef(int userID, Date time) {
        StringBuffer result = new StringBuffer(100);
        if (time != null) {
            User user = UserMap.getUser((Integer)userID);
            result.append("(");
            result.append(user.getName());
            result.append(") ");
            result.append(TimeUtils.format((Date)time, (String)"dd.MM.yy HH"));
        }
        return result.toString();
    }

    private String checkDates(Date now, RegisterTask task) {
        String result = null;
        if (task.getExecuteDate() != null && TimeUtils.dateBefore((Date)now, (Date)task.getExecuteDate())) {
            result = "\u0414\u0430\u0442\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u043e\u0437\u0436\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0434\u0430\u0442\u044b!";
        }
        return result;
    }

    protected String checkAcceptDates(Date now, RegisterTask task) {
        String result = null;
        if (task.getTargetDate() != null && TimeUtils.dateBefore((Date)task.getTargetDate(), (Date)now)) {
            result = "\u0421\u0440\u043e\u043a \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0430\u043d\u0435\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0434\u0430\u0442\u044b!";
        }
        if (result == null) {
            result = this.checkDates(now, task);
        }
        return result;
    }

    protected String checkCloseDates(Date now, RegisterTask task) {
        String result = null;
        if (task.getExecuteDate() == null) {
            result = "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0434\u0430\u0442\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f!";
        } else if (task.getTargetDate() == null) {
            result = "\u041d\u0443 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0440\u043e\u043a \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f!";
        }
        if (result == null && this.plugin.getSetup().getInt("close.task.future", 0) == 0) {
            result = this.checkDates(now, task);
        }
        return result;
    }
}

