/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dba.server.action;

import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.dba.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.dba.server.bean.BashScriptGenerator;
import ru.bitel.bgbilling.modules.dba.server.bean.BatchScriptGenerator;
import ru.bitel.bgbilling.modules.dba.server.bean.ScriptGenerator;
import ru.bitel.common.Utils;

public class ActionGenerateScript
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        String type = this.getParameter("type");
        String mysqlCommand = this.getParameter("mysql_command");
        String mysqlDumpCommand = this.getParameter("mysqldump_command");
        String backupPath = this.getParameter("backup_path");
        if (this.mid <= 0 || Utils.isBlankString((String)mysqlCommand) || Utils.isBlankString((String)mysqlDumpCommand) || Utils.isBlankString((String)backupPath) || !type.equals("bash") && !type.equals("batch")) {
            throw new BGIllegalArgumentException();
        }
        ScriptGenerator generator = null;
        if (type.equals("bash")) {
            generator = new BashScriptGenerator(this.setup, this.con, this.mid);
        } else if (type.equals("batch")) {
            generator = new BatchScriptGenerator(this.setup, this.con, this.mid);
        }
        generator.setMysqlCommand(mysqlCommand);
        generator.setMysqlDumpCommand(mysqlDumpCommand);
        generator.setBackupPath(backupPath);
        String script = generator.getScript();
        this.stringToLines(this.rootNode, script);
    }
}

