/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.sender.smsaero;

import java.io.IOException;
import java.util.List;
import javax.activation.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.sms.smsaero.SmsAero;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.server.sender.Sender;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class SmsAeroSender
implements Sender {
    private static final Logger logger = LogManager.getLogger();
    private Preferences pluginPreferences = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.dispatch").getSetup();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void send(Contact contact, String title, String messageBody, List<DataSource> messageFiles) throws BGException {
        if (contact != null) {
            String login = this.pluginPreferences.get("sender.sms.smsaero.login");
            String password = this.pluginPreferences.get("sender.sms.smsaero.password");
            String sign = this.pluginPreferences.get("sender.sms.smsaero.sign");
            String sign2 = this.pluginPreferences.get("sender.sms.smsaero.sign2");
            if (Utils.isBlankString((String)login) && Utils.isBlankString((String)password)) {
                throw new BGException("\u041d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043b\u043e\u0433\u0438\u043d \u0438/\u0438\u043b\u0438 \u043f\u0430\u0440\u043e\u043b\u044c.");
            }
            SmsAero smsAero = new SmsAero(login, password);
            try {
                String result = smsAero.sendMsg(contact.getValueForSend(), messageBody, sign, sign2, null);
                if (!logger.isDebugEnabled()) return;
                logger.debug("\t\t\tSms-\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443 " + contact.getValueForSend() + " \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e. \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442: " + result);
                return;
            }
            catch (IOException e) {
                throw new BGException("\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0435 \u0441\u043c\u0441!", (Throwable)e);
            }
        } else {
            logger.warn("\t\t\t\u0412 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0435 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043a\u043e\u043d\u0442\u0430\u043a\u0442! \u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043c\u0441-\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435");
        }
    }
}

