/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.client;

import bitel.billing.module.services.ServicePanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.RowData;

public class ServicePropertiesPanel
extends ServicePanel {
    private JPopupMenu popupMenu = null;
    private AccountTableModel accountTableModel = null;
    private BGButtonPanelRestoreOkCancelHelp controlPanel = new BGButtonPanelRestoreOkCancelHelp();
    private JPanel editorPanel = new JPanel();

    public ServicePropertiesPanel() {
        this.setTabbedPanel();
        this.jbInit();
    }

    private void jbInit() {
        this.controlPanel.addActionListener(e -> this.actionPerformed(e));
        this.setLayout(this.cardLayout1);
        this.add(this.getTablePanel(), "table");
        this.add(this.editorPanel, "editor");
        this.editorPanel.setLayout(new GridBagLayout());
        this.editorPanel.add((Component)this.editorsTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.editorPanel.add((Component)this.controlPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 10, 5, 10), 0, 0));
    }

    private JPanel getTablePanel() {
        this.popupMenu = new JPopupMenu();
        this.accountTableModel = new AccountTableModel();
        final BGUTable table = new BGUTable((TableModel)((Object)this.accountTableModel));
        table.setSelectionMode(0);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1 && Arrays.stream(table.getSelectedRows()).anyMatch(i -> i == table.rowAtPoint(e.getPoint()))) {
                    ServicePropertiesPanel.this.popupMenu.show((Component)table, e.getX(), e.getY());
                }
                if (e.getClickCount() == 2) {
                    ServicePropertiesPanel.this.editItem();
                }
            }
        });
        this.initTransferContractPopup(this.popupMenu, table, "MoveEmail", "id", "id");
        this.initWrapContractPopup(this.popupMenu, table, "MoveEmail", "id", "id");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        return panel;
    }

    public void setData() {
        if (this.getContractId() > -1 && this.getModuleId() > -1) {
            this.cardLayout1.show((Container)((Object)this), "table");
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("AccountTable");
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            this.setDocument(this.getDocument(request));
        }
    }

    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus((Document)doc)) {
            ArrayList<RowData> data = new ArrayList<RowData>();
            for (Element itemElement : XMLUtils.selectElements((Node)doc, (String)"//table/data/row")) {
                JSONObject json = new JSONObject();
                json.put("id", Utils.parseInt((String)itemElement.getAttribute("id")));
                json.put("email", (Object)itemElement.getAttribute("email"));
                json.put("period", (Object)itemElement.getAttribute("period"));
                json.put("status", (Object)itemElement.getAttribute("status_label"));
                json.put("quota", (Object)itemElement.getAttribute("quota"));
                json.put("comment", (Object)itemElement.getAttribute("comment"));
                data.add(new RowData(json));
            }
            this.accountTableModel.setData(data);
        }
    }

    public void newItem() {
        if (this.editorPanel.isVisible()) {
            this.showMessageDialog();
            return;
        }
        this.initServiceSubPanel(this.editorsTabbedPane, 0);
        this.editorsTabbedPane.setSelectedIndex(0);
        this.cardLayout1.show((Container)((Object)this), "editor");
    }

    public void editItem() {
        RowData rowData;
        if (!this.editorPanel.isVisible()) {
            rowData = (RowData)this.accountTableModel.getSelectedRow();
            if (rowData == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 E-Mail");
                return;
            }
        } else {
            this.showMessageDialog();
            return;
        }
        this.initServiceSubPanel(this.editorsTabbedPane, rowData.getJson().getInt("id"));
        this.editorsTabbedPane.setSelectedIndex(0);
        this.cardLayout1.show((Container)((Object)this), "editor");
    }

    public void deleteItem() {
        if (!this.editorPanel.isVisible()) {
            RowData rowData = (RowData)this.accountTableModel.getSelectedRow();
            if (rowData == null) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 E-Mail");
                return;
            }
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                Request request = new Request();
                request.setModule(this.module);
                request.setAction("DeleteAccount");
                request.setModuleId(this.getModuleId());
                request.setContractId(this.getContractId());
                request.setAttribute("id", rowData.getJson().getInt("id"));
                Document doc = this.getDocument(request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    this.cardLayout1.show((Container)((Object)this), "table");
                    this.setData();
                }
            } else {
                this.showMessageDialog();
            }
        }
    }

    class AccountTableModel
    extends BGTableModel<RowData> {
        public AccountTableModel() {
            super(AccountTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("E-Mail", 100, 200, 300, "email", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 200, 200, 200, "period", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 200, 200, 200, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u0432\u043e\u0442\u0430", 100, 100, 100, "quota", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(RowData rowData, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            JSONObject json = rowData.getJson();
            switch (identifier) {
                case "id": {
                    return json.optInt("id");
                }
            }
            return json.optString(identifier);
        }
    }
}

