/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.action;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.email.server.bean.DomainManager;
import ru.bitel.bgbilling.modules.email.server.bean.EmailUtils;
import ru.bitel.bgbilling.modules.email.server.event.AccountCreatedEvent;
import ru.bitel.bgbilling.modules.email.server.event.AccountUpdateEvent;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.bgbilling.server.util.PswdGen;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionUpdateAccount
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        String id = this.getParameter("id");
        String account = this.getParameter("account");
        String password = this.getParameter("password");
        int domainID = this.getIntParameter("domain", -1);
        long quota = this.getLongParameter("quota", -1L);
        int status = this.getIntParameter("status", -1);
        String comment = this.getParameter("comment", "");
        Date date1 = this.getDateParameter("date1");
        Date date2 = this.getDateParameter("date2");
        if (id == null || this.cid < 0 || Utils.isEmptyString((String)account) || domainID < 0 || quota < 0L) {
            throw new BGIllegalArgumentException();
        }
        if (Utils.notBlankString((String)this.getParameter("set_pswd"))) {
            password = PswdGen.generatePassword((ParameterMap)this.moduleSetup);
        } else {
            String error = ContractUtils.checkPassword((ParameterMap)this.moduleSetup, (String)password, (String)password);
            if (error != null) {
                throw new BGMessageException(error);
            }
        }
        AccountManager am = new AccountManager(this.con, this.mid);
        Account ac = am.getAccountById(Utils.parseInt((String)id, (int)-1));
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionUpdateAccount", (int)this.mid, (int)this.userId);
        if (closedDate != null) {
            Date oldDate1 = null;
            Date oldDate2 = null;
            if (ac != null) {
                oldDate1 = ac.getDate1();
                oldDate2 = ac.getDate2();
            }
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Date)oldDate1, (Date)oldDate2, (Date)date1, (Date)date2);
        }
        if (!EmailUtils.checkAccountName(account, (ParameterMap)this.moduleSetup)) {
            throw new BGMessageException("\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430!");
        }
        DomainManager dm = new DomainManager(this.con, this.mid);
        Domain domain = dm.get(domainID);
        if (domain == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043e\u043c\u0435\u043d \u0441 \u043a\u043e\u0434\u043e\u043c:" + domainID);
        }
        Account emailAccount = new Account();
        emailAccount.setId(Utils.parseInt((String)id));
        emailAccount.setAccount(account);
        emailAccount.setContractId(this.cid);
        emailAccount.setDomainId(domainID);
        emailAccount.setQuota(quota);
        emailAccount.setStatus(status);
        emailAccount.setComment(comment);
        emailAccount.setPassword(password);
        emailAccount.setDate1(date1);
        emailAccount.setDate2(date2);
        try {
            String error = am.checkAccount(emailAccount);
            if (Utils.notBlankString((String)error)) {
                throw new BGException(error);
            }
            Date thisDate = new Date();
            if (id.equals("new")) {
                if (TimeUtils.dateInRange((Date)thisDate, (Date)emailAccount.getDate1(), (Date)emailAccount.getDate2())) {
                    dm.getServiceActivator(domain).create(emailAccount);
                }
            } else {
                Account old = am.getAccountById(Utils.parseInt((String)id, (int)-1));
                boolean oldActual = TimeUtils.dateInRange((Date)thisDate, (Date)old.getDate1(), (Date)old.getDate2());
                boolean newActual = TimeUtils.dateInRange((Date)thisDate, (Date)emailAccount.getDate1(), (Date)emailAccount.getDate2());
                if (!oldActual && newActual) {
                    dm.getServiceActivator(domain).create(emailAccount);
                } else if (!newActual) {
                    dm.getServiceActivator(domain).cancel(emailAccount);
                } else if (oldActual && newActual) {
                    dm.getServiceActivator(domain).modify(emailAccount);
                }
            }
            emailAccount.setNeedOpenAndNeedClose(thisDate);
            am.updateAccount(emailAccount);
            if (id.equals("new")) {
                this.context.publishAfterCommit((Event)new AccountCreatedEvent(this.userId, this.mid, this.cid, emailAccount.getAccount() + "@" + domain.getName()));
            } else {
                this.context.publishAfterCommit((Event)new AccountUpdateEvent(this.userId, this.mid, this.cid, emailAccount.getAccount() + "@" + domain.getName()));
            }
        }
        catch (BGException e) {
            log.error("Can't update account", (Throwable)e);
            throw e;
        }
    }
}

