/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.email.server.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.EmailServiceActivator;
import ru.bitel.bgbilling.modules.email.server.bean.LdapEmailServiceActivator;
import ru.bitel.bgbilling.modules.email.server.bean._DomainManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Id;

public class DomainManager
extends AbstractIdDao<ru.bitel.bgbilling.modules.email.common.bean.Domain> {
    private static final Logger logger = LogManager.getLogger();
    private final Map<String, SoftReference<EmailServiceActivator>> serviceActivatorMap = Collections.synchronizedMap(new HashMap());

    public DomainManager(Connection con, int mid) {
        super(con, mid, "email_domain");
    }

    protected ru.bitel.bgbilling.modules.email.common.bean.Domain getFromRS(ResultSet rs) throws SQLException {
        ru.bitel.bgbilling.modules.email.common.bean.Domain result = new ru.bitel.bgbilling.modules.email.common.bean.Domain();
        result.setId(rs.getInt("id"));
        result.setName(rs.getString("name"));
        result.setParams(rs.getString("params"));
        result.setComment(rs.getString("comment"));
        result.setPos(rs.getInt("pos"));
        return result;
    }

    protected void updateImpl(ru.bitel.bgbilling.modules.email.common.bean.Domain domain) throws BGException, SQLException {
        PreparedStatement ps;
        if (domain.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO email_domain_" + this.moduleId + " (name, params, comment, pos) VALUES (?, ?, ?, ?)");
        } else {
            ps = this.con.prepareStatement("UPDATE email_domain_" + this.moduleId + " SET name=?, params=?, comment=?, pos=? WHERE id=?");
            ps.setInt(5, domain.getId());
        }
        ps.setString(1, domain.getName());
        ps.setString(2, domain.getParams());
        ps.setString(3, domain.getComment());
        ps.setInt(4, domain.getPos());
        ps.executeUpdate();
        if (domain.getId() <= 0) {
            domain.setId(ServerUtils.lastInsertId((Connection)this.con));
        }
    }

    public ru.bitel.bgbilling.modules.email.common.bean.Domain get(int id) throws BGException {
        int inheritFrom;
        ru.bitel.bgbilling.modules.email.common.bean.Domain result = (ru.bitel.bgbilling.modules.email.common.bean.Domain)super.get(id);
        if (result == null) {
            this.importFromOld();
            result = (ru.bitel.bgbilling.modules.email.common.bean.Domain)super.get(id);
        }
        if (result != null && (inheritFrom = result.getParameterMap().getInt("inherit", -1)) > 0) {
            ru.bitel.bgbilling.modules.email.common.bean.Domain ancestor = (ru.bitel.bgbilling.modules.email.common.bean.Domain)super.get(inheritFrom);
            if (ancestor != null) {
                result.inherit(ancestor);
            } else {
                logger.error("Domain ancestor not found [id=" + inheritFrom + "]");
            }
        }
        return result;
    }

    public List<ru.bitel.bgbilling.modules.email.common.bean.Domain> list(String order) throws BGException {
        List result;
        if (Utils.isBlankString((String)order)) {
            order = "name";
        }
        if ((result = super.list(null, order, new Object[0])).size() == 0) {
            this.importFromOld();
            result = super.list(null, order, new Object[0]);
        }
        Map map = Id.newMap((List)result);
        for (ru.bitel.bgbilling.modules.email.common.bean.Domain domain : result) {
            int inheritFrom = domain.getParameterMap().getInt("inherit", -1);
            if (inheritFrom <= 0) continue;
            ru.bitel.bgbilling.modules.email.common.bean.Domain ancestor = (ru.bitel.bgbilling.modules.email.common.bean.Domain)map.get(inheritFrom);
            if (ancestor != null) {
                int ancestorInheritFrom = ancestor.getParameterMap().getInt("inherit", -1);
                if (ancestorInheritFrom > 0) {
                    logger.error("Multiplie ancestors [id= " + domain.getId() + " => " + inheritFrom + " => " + ancestorInheritFrom + "]");
                }
                domain.inherit(ancestor);
                continue;
            }
            logger.error("Domain ancestor not found [id=" + inheritFrom + "]");
        }
        return result;
    }

    public EmailServiceActivator getServiceActivator(ru.bitel.bgbilling.modules.email.common.bean.Domain domain) throws BGException {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        String className = domain.getParameterMap().get("sa", moduleSetup.get("sa", "ru.bitel.bgbilling.modules.email.server.bean.LdapEmailServiceActivator")).trim();
        SoftReference<EmailServiceActivator> ref = this.serviceActivatorMap.get(this.moduleId + "_" + className);
        EmailServiceActivator sa = ref != null ? ref.get() : null;
        try {
            if (sa == null) {
                Class<EmailServiceActivator> clazz = Class.forName(className).asSubclass(EmailServiceActivator.class);
                sa = clazz.getConstructor(ru.bitel.bgbilling.modules.email.common.bean.Domain.class, ParameterMap.class).newInstance(domain, moduleSetup);
                this.serviceActivatorMap.put(this.moduleId + "_" + className, new SoftReference<EmailServiceActivator>(sa));
            }
            return sa;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new LdapEmailServiceActivator(domain, (ParameterMap)moduleSetup);
        }
    }

    private void add(ru.bitel.bgbilling.modules.email.common.bean.Domain b) throws BGException, SQLException {
        PreparedStatement ps = this.con.prepareStatement("INSERT INTO email_domain_" + this.moduleId + " (id, name, params, comment, pos) VALUES (?, ?, ?, ?, ?)");
        ps.setInt(1, b.getId());
        ps.setString(2, b.getName());
        ps.setString(3, b.getParams());
        ps.setString(4, b.getComment());
        ps.setInt(5, b.getPos());
        ps.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importFromOld() throws BGException {
        Class<DomainManager> clazz = DomainManager.class;
        synchronized (DomainManager.class) {
            if (super.list(null, null, new Object[0]).size() > 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            logger.info("Importing domains from config (old format)...");
            try {
                _DomainManager dm = new _DomainManager((Preferences)Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId)));
                for (Domain d : dm.getDomainList()) {
                    logger.info(d.getName());
                    ru.bitel.bgbilling.modules.email.common.bean.Domain domain = new ru.bitel.bgbilling.modules.email.common.bean.Domain();
                    domain.setId(d.getId());
                    domain.setName(d.getName());
                    domain.setComment("");
                    StringBuilder params = new StringBuilder();
                    if (d.getLikeId() > 0) {
                        params.append("inherit=").append(d.getLikeId());
                    } else {
                        params.append("sa=").append("ru.bitel.bgbilling.modules.email.server.bean.LdapEmailServiceActivator").append("\n");
                        params.append("sa.ldap.class=").append(d.getDriverClass()).append("\n");
                        params.append("sa.ldap.host=").append(d.getLDAPHost()).append("\n");
                        params.append("sa.ldap.port=").append(d.getLDAPPort()).append("\n");
                        params.append("sa.ldap.root=").append(d.getLDAPRootNode()).append("\n");
                        params.append("sa.ldap.user=").append(d.getLDAPUser()).append("\n");
                        params.append("sa.ldap.password=").append(d.getLDAPPassword()).append("\n");
                        params.append("sa.ldap.base=").append(d.getBase()).append("\n");
                        if (d.getAddAttributes() != null && d.getAddAttributes().size() > 0) {
                            params.append("sa.ldap.addattr=");
                            for (Map.Entry<String, String> e : d.getAddAttributes().entrySet()) {
                                params.append(e.getKey()).append(":").append(e.getValue()).append(";");
                            }
                        }
                    }
                    domain.setParams(params.toString());
                    this.add(domain);
                }
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
            return;
        }
    }
}

