/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import bitel.billing.server.contract.bean.ContractService;
import bitel.billing.server.contract.bean.ContractServiceManager;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.modules.email.server.bean.WebPermition;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class WebPermitionManager {
    private int moduleId;
    private Connection con;
    private Map<Integer, WebPermition> permForSeviceMap = new HashMap<Integer, WebPermition>();

    public WebPermitionManager(Connection con, int moduleId, ParameterMap moduleSetup) {
        this.con = con;
        this.moduleId = moduleId;
        this.load(moduleSetup);
    }

    private void load(ParameterMap moduleSetup) {
        ParameterMap map = moduleSetup.sub("service.");
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            int id = Utils.parseInt((String)key, (int)-1);
            if (id <= 0) continue;
            String permitionConfig = map.get(key, null);
            WebPermition perm = new WebPermition();
            StringTokenizer st = new StringTokenizer(permitionConfig, ";");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.startsWith("create")) {
                    perm.create = true;
                    String[] create_param = token.split(":");
                    if (create_param.length > 1) {
                        perm.maxCreate = Utils.parseInt((String)create_param[1], (int)0);
                    }
                    if (create_param.length > 2) {
                        perm.createDomains.addAll(Utils.toList((String)create_param[2]));
                    }
                    if (create_param.length > 3) {
                        perm.createQuota = Utils.parseLong((String)create_param[3], (long)0L);
                    }
                } else if (token.startsWith("delete")) {
                    perm.delete = true;
                } else if (token.startsWith("forward")) {
                    perm.forward = true;
                    int pos = token.indexOf(":");
                    if (pos > 0) {
                        perm.maxForward = Utils.parseInt((String)token.substring(pos + 1), (int)0);
                    }
                } else if (token.startsWith("view")) {
                    perm.view = true;
                } else if (token.startsWith("password")) {
                    perm.passwdChange = true;
                }
                this.permForSeviceMap.put(id, perm);
            }
        }
    }

    public WebPermition getPermition(int contractId) {
        WebPermition result = new WebPermition();
        List serviceList = new ContractServiceManager(this.con).getContractServiceList(contractId, this.moduleId, new Date());
        for (ContractService service : serviceList) {
            WebPermition wp = this.permForSeviceMap.get(service.getServiceId());
            if (wp == null) continue;
            result.add(wp);
        }
        return result;
    }
}

