/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gorod.server.action;

import bitel.billing.server.contract.bean.ContractAddressParamValue;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.directory.address.AddressArea;
import ru.bitel.bgbilling.kernel.directory.address.AddressCity;
import ru.bitel.bgbilling.kernel.directory.address.AddressCountry;
import ru.bitel.bgbilling.kernel.directory.address.AddressDirectoryManager;
import ru.bitel.bgbilling.kernel.directory.address.AddressHouse;
import ru.bitel.bgbilling.kernel.directory.address.AddressQuarter;
import ru.bitel.bgbilling.kernel.directory.address.AddressStreet;
import ru.bitel.bgbilling.modules.gorod.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.gorod.server.bean.GorodParams;
import ru.bitel.bgbilling.modules.gorod.server.bean.Register;
import ru.bitel.bgbilling.modules.gorod.server.bean.RegisterItem;
import ru.bitel.bgbilling.modules.gorod.server.bean.RegisterItemManager;
import ru.bitel.bgbilling.modules.gorod.server.bean.RegisterMacrosProcessor;
import ru.bitel.bgbilling.modules.gorod.server.bean.RegisterManager;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.server.bean.AddressStruct;

public class ActionGetRegister
extends ActionBase {
    private static Map<String, Pattern> insertPartPatterns = new HashMap<String, Pattern>(12);

    public void doAction() throws SQLException, BGException {
        GorodParams params = new GorodParams((Preferences)this.moduleSetup);
        int id = this.getIntParameter("id", -1);
        if (this.mid <= 0 || id <= 0) {
            throw new BGIllegalArgumentException();
        }
        Register register = new RegisterManager(this.con, this.mid).getRegisterById(id);
        String registerPattern = params.getRegisterPattern(String.valueOf(register.getTagId()));
        RegisterMacrosProcessor summProcessor = new RegisterMacrosProcessor(params);
        List<RegisterItem> itemList = new RegisterItemManager(this.con, this.mid, (Preferences)this.moduleSetup).getRegisterItems(id);
        StringBuilder registerContent = new StringBuilder();
        BigDecimal totalSumm = BigDecimal.ZERO;
        int account = 0;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("#############0.00", dfs);
        for (RegisterItem item : itemList) {
            AddressStruct addressStruct = this.getAddressStruct(params, item.contractID);
            registerPattern = this.insertPatternPart(registerPattern, "fio", item.fullname);
            registerPattern = this.insertPatternPart(registerPattern, "contractId", String.valueOf(item.contractID));
            registerPattern = this.insertPatternPart(registerPattern, "contractTitle", item.contract);
            if (!this.isEmptyAddress(addressStruct)) {
                if (params.isDropGFromAddress()) {
                    String city = addressStruct.getCity().replaceAll("^\\s*\u0433\\.\\s*", "");
                    registerPattern = this.insertPatternPart(registerPattern, "city", city);
                } else {
                    registerPattern = this.insertPatternPart(registerPattern, "city", addressStruct.getCity());
                }
                registerPattern = this.insertPatternPart(registerPattern, "street", addressStruct.getStreet());
                registerPattern = this.insertPatternPart(registerPattern, "house", addressStruct.getHouse());
                registerPattern = this.insertPatternPart(registerPattern, "frac", addressStruct.getFrac());
                registerPattern = this.insertPatternPart(registerPattern, "flat", addressStruct.getFlat());
            } else {
                String defaultAddress = params.getDefaultAddress().replace("${cid}", String.valueOf(item.contractID));
                registerPattern = this.insertPatternPart(registerPattern, "city", defaultAddress);
                registerPattern = this.insertPatternPart(registerPattern, "street", "");
                registerPattern = this.insertPatternPart(registerPattern, "house", "");
                registerPattern = this.insertPatternPart(registerPattern, "frac", "");
                registerPattern = this.insertPatternPart(registerPattern, "flat", "");
            }
            registerPattern = this.insertPatternPart(registerPattern, "dateFrom", TimeUtils.format((Date)TimeUtils.getStartMonth((Date)new Date()), (String)params.getDateFormat()));
            registerPattern = this.insertPatternPart(registerPattern, "dateTo", TimeUtils.format((Date)register.getDate().getTime(), (String)params.getDateFormat()));
            registerPattern = this.insertPatternPart(registerPattern, "account", String.valueOf(item.account));
            if (register.getType() == 7) {
                BigDecimal summ = summProcessor.getSumm(item.rest);
                registerPattern = this.insertPatternPart(registerPattern, "summ", String.valueOf(format.format(Utils.roundBigDecimalSumm((BigDecimal)summ))));
                totalSumm = totalSumm.add(summ);
            } else {
                registerPattern = this.insertPatternPart(registerPattern, "summ", "0");
            }
            account = item.account;
            registerContent.append(registerPattern + "\r\n");
            registerPattern = params.getRegisterPattern(String.valueOf(register.getTagId()));
        }
        int a = params.getHeaderAccount(register.getTagId());
        if (a >= 0) {
            account = a;
        }
        if (params.isNote()) {
            registerContent.insert(0, "\r\n");
            if (params.isNoteDate()) {
                registerContent.insert(0, TimeUtils.format((Date)new Date(System.currentTimeMillis()), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            registerContent.insert(0, "#NOTE ");
        }
        registerContent.insert(0, "\r\n");
        registerContent.insert(0, account);
        registerContent.insert(0, "#SERVICE ");
        registerContent.insert(0, "\r\n");
        registerContent.insert(0, register.getType());
        registerContent.insert(0, "#TYPE ");
        registerContent.insert(0, "\r\n");
        registerContent.insert(0, format.format(Utils.roundBigDecimalSumm((BigDecimal)totalSumm)));
        registerContent.insert(0, "#FILESUM ");
        try {
            this.getResponseOut().write(registerContent.toString().getBytes(params.getRegisterEncoding(String.valueOf(register.getTagId()))));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AddressStruct getAddressStruct(GorodParams params, int cid) throws SQLException {
        AddressDirectoryManager addressDirectoryManager;
        AddressHouse addressHouse;
        AddressStruct result = null;
        ContractAddressParamValue addressParam = new ContractParameterManager(this.con).getAddressParam(cid, params.getParamAddress());
        if (addressParam != null && (addressHouse = (addressDirectoryManager = new AddressDirectoryManager(this.con)).getAddressHouse(addressParam.getHouseId())) != null) {
            AddressArea addressArea = addressDirectoryManager.getAddressArea(addressHouse.getAreaId());
            AddressStreet addressStreet = addressDirectoryManager.getAddressStreet(addressHouse.getStreetId());
            int quarterId = addressHouse.getQuarterId();
            AddressQuarter addressQuarter = addressDirectoryManager.getAddressQuarter(quarterId);
            AddressCity addressCity = addressDirectoryManager.getAddressCity(addressStreet.getCityId());
            AddressCountry addressCountry = addressDirectoryManager.getAddressCountry(addressCity.getCountryId());
            result = new AddressStruct();
            result.setIndex(addressHouse.getPostIndex());
            result.setCountry(addressCountry.getTitle());
            result.setCity(addressCity.getTitle());
            result.setArea(addressArea != null ? addressArea.getTitle() : null);
            result.setQuarter(addressQuarter != null ? addressQuarter.getTitle() : null);
            result.setStreet(addressStreet.getTitle());
            result.setHouse(String.valueOf(addressHouse.getHouse()));
            result.setFrac(addressHouse.getFrac());
            result.setFlat(addressParam.getFlat());
            result.setRoom(addressParam.getRoom());
            result.setPod(String.valueOf(addressParam.getPod()));
            result.setFloor(String.valueOf(addressParam.getFloor()));
            result.setComment(addressParam.getComment());
        }
        return result;
    }

    private boolean isEmptyAddress(AddressStruct addressStruct) {
        boolean result = false;
        if (addressStruct == null) {
            result = true;
        } else if (addressStruct.getCity().equals("") && addressStruct.getStreet().equals("") && addressStruct.getHouse().equals("") && addressStruct.getFlat().equals("")) {
            result = true;
        }
        return result;
    }

    private String insertPatternPart(String pattern, String key, String value) {
        Matcher m;
        StringBuilder result = new StringBuilder(pattern.length());
        Pattern p = insertPartPatterns.get(key);
        if (p == null) {
            p = Pattern.compile("\\[([\\w\u0430-\u044f\u0410-\u042f\\,\\.\\:\\;\\s\\[\\]\\(\\)\\\\/#]*)\\$\\{" + key + "\\}([\\w\u0430-\u044f\u0410-\u042f\\,\\.\\:\\;\\s\\[\\]\\(\\)\\\\/#]*)\\]");
            insertPartPatterns.put(key, p);
        }
        if ((m = p.matcher(pattern)).find()) {
            if (Utils.notBlankString((String)value)) {
                result.append(pattern.substring(0, m.start()));
                String prefix = m.group(1);
                if (prefix.startsWith(",") && result.length() == 0) {
                    prefix = prefix.substring(1);
                }
                result.append(prefix);
                result.append(value);
                result.append(m.group(2));
                result.append(pattern.substring(m.end()));
            } else {
                result.append(pattern.substring(0, m.start()));
                result.append(pattern.substring(m.end()));
            }
        } else {
            result.append(pattern);
        }
        return result.toString();
    }
}

